/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rib.core;

import com.google.common.truth.Truth;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

public final class AndroidRecordingRx2Observer<T>
implements Observer<T> {
    private final BlockingDeque<Object> events = new LinkedBlockingDeque<Object>();

    public void onSubscribe(Disposable disposable) {
    }

    public void onComplete() {
        this.events.addLast(new OnCompleted());
    }

    public void onError(Throwable e) {
        this.events.addLast(new OnError(e));
    }

    public void onNext(T t) {
        this.events.addLast(new OnNext(t));
    }

    T takeNext() {
        OnNext event = this.takeEvent(OnNext.class);
        return event.value;
    }

    Throwable takeError() {
        OnError event = this.takeEvent(OnError.class);
        return event.throwable;
    }

    private <E> E takeEvent(Class<E> wanted) {
        Object event;
        try {
            event = this.events.pollFirst(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (event == null) {
            throw new NoSuchElementException("No event found while waiting for " + wanted.getSimpleName());
        }
        Truth.assertThat((Object)event).isInstanceOf(wanted);
        return wanted.cast(event);
    }

    void assertNoMoreEvents() {
        try {
            Object event = this.takeEvent(Object.class);
            throw new IllegalStateException("Expected no more events but got " + event);
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    private static final class OnError {
        private final Throwable throwable;

        private OnError(Throwable throwable) {
            this.throwable = throwable;
        }

        public String toString() {
            return "OnError[" + this.throwable + "]";
        }
    }

    private static final class OnCompleted {
        private OnCompleted() {
        }

        public String toString() {
            return "OnCompleted";
        }
    }

    private final class OnNext {
        final T value;

        private OnNext(T value) {
            this.value = value;
        }

        public String toString() {
            return "OnNext[" + this.value + "]";
        }
    }
}

