/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rib.core;

import androidx.annotation.Nullable;
import com.uber.rib.core.Bundle;
import com.uber.rib.core.Interactor;
import com.uber.rib.core.Router;
import org.mockito.AdditionalMatchers;
import org.mockito.Matchers;
import org.mockito.Mockito;

public final class InteractorHelper {
    private InteractorHelper() {
    }

    public static <P, R extends Router> void attach(Interactor<P, R> interactor, P presenter, R router, @Nullable Bundle savedInstanceState) {
        interactor.presenter = presenter;
        interactor.setRouter(router);
        interactor.dispatchAttach(savedInstanceState);
    }

    public static void reattach(Interactor interactor, @Nullable Bundle savedInstanceState) {
        interactor.dispatchAttach(savedInstanceState);
    }

    public static void detach(Interactor controller) {
        controller.dispatchDetach();
    }

    public static void verifyAttached(Interactor<?, ?> interactor) {
        ((Interactor)Mockito.verify(interactor)).dispatchAttach((Bundle)AdditionalMatchers.or((Object)Matchers.isNull(Bundle.class), (Object)Matchers.isA(Bundle.class)));
    }

    public static void verifyDetached(Interactor interactor) {
        ((Interactor)Mockito.verify((Object)interactor)).dispatchDetach();
    }
}

