/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rib.workflow.core;

import androidx.annotation.Nullable;
import com.google.common.base.Optional;
import com.google.common.truth.Truth;
import com.uber.rib.workflow.core.ActionableItem;
import com.uber.rib.workflow.core.Step;
import io.reactivex.Observable;
import io.reactivex.observers.TestObserver;

public final class StepTester {
    private StepTester() {
    }

    public static <T, A extends ActionableItem> Observable<Optional<Step.Data<T, A>>> exposeObservable(Step<T, A> step) {
        return step.asObservable();
    }

    @Nullable
    public static <T, A extends ActionableItem> T exposeStepData(Step.Data<T, A> step) {
        return (T)step.getValue();
    }

    public static <T, A extends ActionableItem> void assertStepNotYetEmitted(TestObserver<Optional<Step.Data<T, A>>> testSubscriber) {
        testSubscriber.assertNoValues();
        testSubscriber.assertNotComplete();
        testSubscriber.assertNoErrors();
    }

    public static <T, A extends ActionableItem> void assertStepEmitted(TestObserver<Optional<Step.Data<T, A>>> testSubscriber) {
        testSubscriber.assertValueCount(1);
        Optional stepData = (Optional)testSubscriber.values().get(0);
        Truth.assertThat((Boolean)stepData.isPresent()).isTrue();
        testSubscriber.assertComplete();
        testSubscriber.assertNoErrors();
    }
}

