/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rib.workflow.core;

import com.google.common.base.Optional;
import com.uber.rib.core.lifecycle.InteractorEvent;
import com.uber.rib.workflow.core.ActionableItem;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Single;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.BiFunction;

public class Step<T, A extends ActionableItem> {
    private final Single<Optional<Data<T, A>>> stepDataSingle;

    private Step(Single<Optional<Data<T, A>>> stepDataSingle) {
        this.stepDataSingle = stepDataSingle;
    }

    public static <T, A extends ActionableItem> Step<T, A> from(Single<Data<T, A>> stepDataSingle) {
        return new Step<T, A>(stepDataSingle.map(Optional::of));
    }

    public static <T, A extends ActionableItem> Step<T, A> fromOptional(Single<Optional<Data<T, A>>> stepDataSingle) {
        return new Step<T, A>(stepDataSingle);
    }

    public <T2, A2 extends ActionableItem> Step<T2, A2> onStep(BiFunction<T, A, Step<T2, A2>> func) {
        return new Step<T, A>(this.asObservable().flatMap(data -> data.isPresent() ? ((Step)func.apply(((Data)data.get()).value, (Object)((Data)data.get()).actionableItem)).asObservable() : Observable.just((Object)Optional.absent())).singleOrError());
    }

    protected Observable<Optional<Data<T, A>>> asObservable() {
        Observable cachedObservable = this.stepDataSingle.toObservable().observeOn(AndroidSchedulers.mainThread()).cache();
        return cachedObservable.flatMap(dataOptional -> {
            if (dataOptional.isPresent()) {
                ActionableItem actionableItem = ((Data)dataOptional.get()).actionableItem;
                return actionableItem.lifecycle().filter(interactorEvent -> interactorEvent == InteractorEvent.ACTIVE).zipWith((ObservableSource)cachedObservable, (interactorEvent, data) -> data);
            }
            return Observable.just((Object)Optional.absent());
        });
    }

    protected Observable<Optional<T>> asResultObservable() {
        return this.asObservable().map(data -> data.isPresent() ? Optional.of(((Data)data.get()).getValue()) : Optional.absent());
    }

    private static class NoValueHolder {
        private static final NoValue INSTANCE = new NoValue();

        private NoValueHolder() {
        }
    }

    public static class NoValue {
        private NoValue() {
        }
    }

    public static class Data<T, A extends ActionableItem> {
        private final T value;
        private final A actionableItem;

        public Data(T value, A actionableItem) {
            this.value = value;
            this.actionableItem = actionableItem;
        }

        public static <A extends ActionableItem> Data<NoValue, A> toActionableItem(A actionableItem) {
            return new Data<NoValue, A>(NoValueHolder.INSTANCE, actionableItem);
        }

        T getValue() {
            return this.value;
        }
    }
}

