/*
 * Decompiled with CFR 0.152.
 */
package com.uber.sdk.core.auth;

import com.uber.sdk.core.auth.Scope;
import com.uber.sdk.core.auth.internal.OAuthScopes;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class AccessToken {
    private final long expires_in;
    @OAuthScopes
    private final Set<Scope> scope;
    private final String access_token;
    private final String refresh_token;
    private final String token_type;

    public AccessToken(long expiresIn, Collection<Scope> scopes, String token, String refreshToken, String tokenType) {
        this.expires_in = expiresIn;
        this.scope = new HashSet<Scope>(scopes);
        this.access_token = token;
        this.refresh_token = refreshToken;
        this.token_type = tokenType;
    }

    public AccessToken(long expiresIn, String scope, String token, String refreshToken, String tokenType) {
        this.expires_in = expiresIn;
        this.scope = Scope.parseScopes(scope);
        this.access_token = token;
        this.refresh_token = refreshToken;
        this.token_type = tokenType;
    }

    public long getExpiresIn() {
        return this.expires_in;
    }

    public Collection<Scope> getScopes() {
        return Collections.unmodifiableCollection(this.scope);
    }

    public String getToken() {
        return this.access_token;
    }

    public String getRefreshToken() {
        return this.refresh_token;
    }

    public String getTokenType() {
        return this.token_type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessToken that = (AccessToken)o;
        if (this.expires_in != that.expires_in) {
            return false;
        }
        if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) {
            return false;
        }
        if (this.access_token != null ? !this.access_token.equals(that.access_token) : that.access_token != null) {
            return false;
        }
        if (this.refresh_token != null ? !this.refresh_token.equals(that.refresh_token) : that.refresh_token != null) {
            return false;
        }
        return this.token_type != null ? this.token_type.equals(that.token_type) : that.token_type == null;
    }

    public int hashCode() {
        int result = (int)(this.expires_in ^ this.expires_in >>> 32);
        result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
        result = 31 * result + (this.access_token != null ? this.access_token.hashCode() : 0);
        result = 31 * result + (this.refresh_token != null ? this.refresh_token.hashCode() : 0);
        result = 31 * result + (this.token_type != null ? this.token_type.hashCode() : 0);
        return result;
    }
}

