/*
 * Decompiled with CFR 0.152.
 */
package com.uber.sdk.core.auth;

import com.squareup.moshi.Moshi;
import com.uber.sdk.core.auth.AccessToken;
import com.uber.sdk.core.auth.AccessTokenStorage;
import com.uber.sdk.core.auth.Authenticator;
import com.uber.sdk.core.auth.internal.OAuth2Service;
import com.uber.sdk.core.auth.internal.OAuthScopesAdapter;
import com.uber.sdk.rides.client.SessionConfiguration;
import com.uber.sdk.rides.client.internal.ApiInterceptor;
import java.io.IOException;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiConverterFactory;

public class AccessTokenAuthenticator
implements Authenticator {
    private static final String HEADER_BEARER_ACCESS_VALUE = "Bearer %s";
    private static final String TOKEN_URL = "%s/oauth/v2/mobile/";
    private final SessionConfiguration sessionConfiguration;
    private final AccessTokenStorage tokenStorage;
    private final OAuth2Service auth2Service;

    public AccessTokenAuthenticator(SessionConfiguration sessionConfiguration, AccessTokenStorage tokenStorage) {
        this(sessionConfiguration, tokenStorage, AccessTokenAuthenticator.createOAuthService(String.format(TOKEN_URL, sessionConfiguration.getLoginHost())));
    }

    AccessTokenAuthenticator(SessionConfiguration sessionConfiguration, AccessTokenStorage tokenStorage, OAuth2Service auth2Service) {
        this.sessionConfiguration = sessionConfiguration;
        this.tokenStorage = tokenStorage;
        this.auth2Service = auth2Service;
    }

    @Override
    public void signRequest(Request.Builder builder) {
        this.setBearerToken(builder, this.tokenStorage.getAccessToken());
    }

    @Override
    public boolean isRefreshable() {
        return this.tokenStorage.getAccessToken() != null && this.tokenStorage.getAccessToken().getRefreshToken() != null;
    }

    @Override
    public Request refresh(Response response) throws IOException {
        return this.doRefresh(response);
    }

    @Override
    public SessionConfiguration getSessionConfiguration() {
        return this.sessionConfiguration;
    }

    public AccessTokenStorage getTokenStorage() {
        return this.tokenStorage;
    }

    synchronized Request doRefresh(Response response) throws IOException {
        if (this.signedByOldToken(response, this.tokenStorage.getAccessToken())) {
            return this.resign(response, this.tokenStorage.getAccessToken());
        }
        return this.refreshAndSign(response, this.tokenStorage.getAccessToken());
    }

    Request resign(Response response, AccessToken auth2Token) {
        Request.Builder builder = response.request().newBuilder();
        this.setBearerToken(builder, auth2Token);
        return builder.build();
    }

    Request refreshAndSign(Response response, AccessToken auth2Token) throws IOException {
        AccessToken token = this.refreshToken(auth2Token);
        return this.resign(response, token);
    }

    AccessToken refreshToken(AccessToken auth2Token) throws IOException {
        AccessToken newToken = (AccessToken)this.auth2Service.refresh(auth2Token.getRefreshToken(), this.sessionConfiguration.getClientId()).execute().body();
        this.tokenStorage.setAccessToken(newToken);
        return newToken;
    }

    boolean signedByOldToken(Response response, AccessToken oAuth2Token) {
        String value = ApiInterceptor.getAuthorizationHeader(response.request());
        String accessToken = this.createBearerToken(oAuth2Token);
        return value != null && !value.equals(accessToken);
    }

    void setBearerToken(Request.Builder builder, AccessToken OAuth2Token) {
        ApiInterceptor.setAuthorizationHeader(builder, this.createBearerToken(OAuth2Token));
    }

    String createBearerToken(AccessToken oAuth2Token) {
        return String.format(HEADER_BEARER_ACCESS_VALUE, oAuth2Token.getToken());
    }

    static OAuth2Service createOAuthService(String baseUrl) {
        Moshi moshi = new Moshi.Builder().add((Object)new OAuthScopesAdapter()).build();
        return (OAuth2Service)new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)MoshiConverterFactory.create((Moshi)moshi)).build().create(OAuth2Service.class);
    }
}

