/*
 * Decompiled with CFR 0.152.
 */
package com.uber.sdk.core.auth;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public enum Scope {
    HISTORY(ScopeType.GENERAL, 1),
    HISTORY_LITE(ScopeType.GENERAL, 2),
    PAYMENT_METHODS(ScopeType.GENERAL, 4),
    PLACES(ScopeType.GENERAL, 8),
    PROFILE(ScopeType.GENERAL, 16),
    RIDE_WIDGETS(ScopeType.GENERAL, 32),
    REQUEST(ScopeType.PRIVILEGED, 64),
    REQUEST_RECEIPT(ScopeType.PRIVILEGED, 128),
    ALL_TRIPS(ScopeType.PRIVILEGED, 256);

    private ScopeType mScopeType;
    private int mBitValue;

    private Scope(ScopeType scopeType, int bitValue) {
        this.mScopeType = scopeType;
        this.mBitValue = bitValue;
    }

    public ScopeType getScopeType() {
        return this.mScopeType;
    }

    public int getBitValue() {
        return this.mBitValue;
    }

    public static Set<Scope> parseScopes(String concatenatedScopes) {
        LinkedHashSet<Scope> scopes = new LinkedHashSet<Scope>();
        for (String scopeString : concatenatedScopes.split(" ")) {
            try {
                Scope scope = Scope.valueOf(scopeString.toUpperCase());
                scopes.add(scope);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return scopes;
    }

    public static Set<Scope> parseScopes(int bitValues) {
        LinkedHashSet<Scope> scopes = new LinkedHashSet<Scope>();
        if (bitValues <= 0) {
            return scopes;
        }
        for (Scope scope : Scope.values()) {
            if ((bitValues & scope.mBitValue) != scope.mBitValue) continue;
            scopes.add(scope);
        }
        return scopes;
    }

    public static String toStandardString(@Nonnull Collection<Scope> scopes) {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        for (Scope scope : scopes) {
            stringBuilder.append(scope.toString().toLowerCase());
            if (i < scopes.size() - 1) {
                stringBuilder.append(' ');
            }
            ++i;
        }
        return stringBuilder.toString();
    }

    public static enum ScopeType {
        GENERAL,
        PRIVILEGED;

    }
}

