/*
 * Decompiled with CFR 0.152.
 */
package com.uber.sdk.rides.auth;

import com.google.api.client.auth.oauth2.Credential;
import com.uber.sdk.core.auth.Authenticator;
import com.uber.sdk.rides.client.SessionConfiguration;
import com.uber.sdk.rides.client.internal.ApiInterceptor;
import java.io.IOException;
import okhttp3.Request;
import okhttp3.Response;

public class CredentialsAuthenticator
implements Authenticator {
    static final String HEADER_BEARER_ACCESS_VALUE = "Bearer %s";
    private final Credential credential;
    private final SessionConfiguration sessionConfiguration;

    public CredentialsAuthenticator(SessionConfiguration sessionConfiguration, Credential credential) {
        this.credential = credential;
        this.sessionConfiguration = sessionConfiguration;
    }

    @Override
    public void signRequest(Request.Builder builder) {
        CredentialsAuthenticator.setBearerToken(builder, this.credential);
    }

    @Override
    public boolean isRefreshable() {
        return true;
    }

    @Override
    public Request refresh(Response response) throws IOException {
        return this.reauth(response);
    }

    @Override
    public SessionConfiguration getSessionConfiguration() {
        return this.sessionConfiguration;
    }

    public Credential getCredential() {
        return this.credential;
    }

    private synchronized Request reauth(Response response) throws IOException {
        if (this.signedByOldToken(response, this.credential)) {
            return this.resign(response, this.credential);
        }
        return this.refreshAndSign(response, this.credential);
    }

    private static void setBearerToken(Request.Builder builder, Credential credential) {
        ApiInterceptor.setAuthorizationHeader(builder, CredentialsAuthenticator.createBearerToken(credential));
    }

    private static String createBearerToken(Credential credential) {
        return String.format(HEADER_BEARER_ACCESS_VALUE, credential.getAccessToken());
    }

    private Request resign(Response response, Credential credential) {
        Request.Builder builder = response.request().newBuilder();
        CredentialsAuthenticator.setBearerToken(builder, credential);
        return builder.build();
    }

    private Request refreshAndSign(Response response, Credential credential) throws IOException {
        credential.refreshToken();
        return this.resign(response, credential);
    }

    private boolean signedByOldToken(Response response, Credential credential) {
        String value = ApiInterceptor.getAuthorizationHeader(response.request());
        String accessToken = CredentialsAuthenticator.createBearerToken(credential);
        return value != null && !value.equals(accessToken);
    }
}

