/*
 * Decompiled with CFR 0.152.
 */
package com.uber.sdk.rides.auth;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.AuthorizationCodeTokenRequest;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.store.AbstractDataStoreFactory;
import com.google.api.client.util.store.DataStoreFactory;
import com.google.api.client.util.store.MemoryDataStoreFactory;
import com.uber.sdk.core.auth.Scope;
import com.uber.sdk.rides.auth.AuthException;
import com.uber.sdk.rides.client.SessionConfiguration;
import com.uber.sdk.rides.client.utils.Preconditions;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;

public class OAuth2Credentials {
    public static final String AUTHORIZATION_PATH = "/oauth/v2/authorize";
    public static final String TOKEN_PATH = "/oauth/v2/token";
    private AuthorizationCodeFlow authorizationCodeFlow;
    private Collection<String> scopes;
    private String redirectUri;

    private OAuth2Credentials() {
    }

    @Nullable
    public String getAuthorizationUrl() throws UnsupportedEncodingException {
        String authorizationCodeRequestUrl = this.authorizationCodeFlow.newAuthorizationUrl().setScopes(this.scopes).build();
        if (this.redirectUri != null) {
            authorizationCodeRequestUrl = authorizationCodeRequestUrl + "&redirect_uri=" + URLEncoder.encode(this.redirectUri, "UTF-8");
        }
        return authorizationCodeRequestUrl;
    }

    public AuthorizationCodeFlow getAuthorizationCodeFlow() {
        return this.authorizationCodeFlow;
    }

    public Credential authenticate(String authorizationCode, String userId) throws AuthException {
        TokenResponse tokenResponse;
        Preconditions.checkNotNull(authorizationCode, "Authorization code must not be null");
        AuthorizationCodeTokenRequest tokenRequest = this.authorizationCodeFlow.newTokenRequest(authorizationCode);
        try {
            tokenResponse = tokenRequest.setRedirectUri(this.redirectUri).setScopes(this.scopes).execute();
        }
        catch (IOException e) {
            throw new AuthException("Unable to request token.", e);
        }
        try {
            return this.authorizationCodeFlow.createAndStoreCredential(tokenResponse, userId);
        }
        catch (IOException e) {
            throw new AuthException("Unable to create and store credential.", e);
        }
    }

    public Credential loadCredential(String userId) throws AuthException {
        try {
            return this.authorizationCodeFlow.loadCredential(userId);
        }
        catch (IOException e) {
            throw new AuthException("Unable to load credential.", e);
        }
    }

    public void clearCredential(String userId) throws AuthException {
        try {
            this.authorizationCodeFlow.getCredentialDataStore().delete(userId);
        }
        catch (IOException e) {
            throw new AuthException("Unable to clear credential.", e);
        }
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public static class Builder {
        private Set<Scope> scopes;
        private Set<String> customScopes;
        private String clientId;
        private String clientSecret;
        private String redirectUri;
        private HttpTransport httpTransport;
        private AuthorizationCodeFlow authorizationCodeFlow;
        private AbstractDataStoreFactory credentialDataStoreFactory;
        private String loginHost = "https://login.uber.com";

        public Builder setSessionConfiguration(SessionConfiguration configuration) {
            if (this.scopes != null) {
                this.scopes = new HashSet<Scope>(configuration.getScopes());
            }
            if (this.customScopes != null) {
                this.customScopes = new HashSet<String>(configuration.getCustomScopes());
            }
            this.clientId = configuration.getClientId();
            this.clientSecret = configuration.getClientSecret();
            this.redirectUri = configuration.getRedirectUri();
            this.loginHost = configuration.getLoginHost();
            return this;
        }

        public Builder setScopes(Collection<Scope> scopes) {
            this.scopes = new HashSet<Scope>(scopes);
            return this;
        }

        public Builder setCustomScopes(Collection<String> scopes) {
            this.customScopes = new HashSet<String>(scopes);
            return this;
        }

        public Builder setClientSecrets(String clientId, String clientSecret) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public Builder setHttpTransport(HttpTransport httpTransport) {
            this.httpTransport = httpTransport;
            return this;
        }

        public Builder setCredentialDataStoreFactory(AbstractDataStoreFactory credentialDataStoreFactory) {
            this.credentialDataStoreFactory = credentialDataStoreFactory;
            return this;
        }

        public Builder setAuthorizationCodeFlow(AuthorizationCodeFlow authorizationCodeFlow) {
            this.authorizationCodeFlow = authorizationCodeFlow;
            return this;
        }

        private void validate() {
            Preconditions.checkState(this.clientId != null && !this.clientId.isEmpty() && this.clientSecret != null && !this.clientSecret.isEmpty(), "Client ID and secret must be set.");
        }

        public OAuth2Credentials build() {
            this.validate();
            OAuth2Credentials oAuth2Credentials = new OAuth2Credentials();
            oAuth2Credentials.redirectUri = this.redirectUri;
            TreeSet<String> allScopes = new TreeSet<String>();
            if (this.scopes != null) {
                for (Scope scope : this.scopes) {
                    allScopes.add(scope.name().toLowerCase());
                }
            }
            if (this.customScopes != null) {
                allScopes.addAll(this.customScopes);
            }
            if (!allScopes.isEmpty()) {
                oAuth2Credentials.scopes = allScopes;
            }
            if (this.httpTransport == null) {
                this.httpTransport = new NetHttpTransport();
            }
            if (this.credentialDataStoreFactory == null) {
                this.credentialDataStoreFactory = MemoryDataStoreFactory.getDefaultInstance();
            }
            if (this.authorizationCodeFlow == null) {
                try {
                    AuthorizationCodeFlow.Builder builder = new AuthorizationCodeFlow.Builder(BearerToken.authorizationHeaderAccessMethod(), this.httpTransport, (JsonFactory)new JacksonFactory(), new GenericUrl(this.loginHost + OAuth2Credentials.TOKEN_PATH), (HttpExecuteInterceptor)new ClientParametersAuthentication(this.clientId, this.clientSecret), this.clientId, this.loginHost + OAuth2Credentials.AUTHORIZATION_PATH);
                    if (oAuth2Credentials.scopes != null && !oAuth2Credentials.scopes.isEmpty()) {
                        builder.setScopes(oAuth2Credentials.scopes);
                    }
                    this.authorizationCodeFlow = builder.setDataStoreFactory((DataStoreFactory)this.credentialDataStoreFactory).build();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unexpected exception while building OAuth2Credentials.", e);
                }
            }
            oAuth2Credentials.authorizationCodeFlow = this.authorizationCodeFlow;
            return oAuth2Credentials;
        }
    }
}

