/*
 * Decompiled with CFR 0.152.
 */
package com.uber.sdk.rides.auth;

import com.uber.sdk.core.auth.Authenticator;
import com.uber.sdk.rides.client.SessionConfiguration;
import com.uber.sdk.rides.client.internal.ApiInterceptor;
import okhttp3.Request;
import okhttp3.Response;

public class ServerTokenAuthenticator
implements Authenticator {
    static final String HEADER_TOKEN_ACCESS_VALUE = "Token %s";
    private final SessionConfiguration sessionConfiguration;

    public ServerTokenAuthenticator(SessionConfiguration sessionConfiguration) {
        this.sessionConfiguration = sessionConfiguration;
    }

    @Override
    public void signRequest(Request.Builder builder) {
        ApiInterceptor.setAuthorizationHeader(builder, String.format(HEADER_TOKEN_ACCESS_VALUE, this.sessionConfiguration.getServerToken()));
    }

    @Override
    public Request refresh(Response response) {
        return null;
    }

    @Override
    public boolean isRefreshable() {
        return false;
    }

    @Override
    public SessionConfiguration getSessionConfiguration() {
        return this.sessionConfiguration;
    }
}

