/*
 * Decompiled with CFR 0.152.
 */
package com.uber.sdk.rides.client;

import com.uber.sdk.core.auth.Scope;
import com.uber.sdk.rides.client.utils.Preconditions;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import javax.annotation.Nonnull;

public class SessionConfiguration
implements Serializable {
    private final String clientId;
    private final String clientSecret;
    private final String serverToken;
    private final String redirectUri;
    private final EndpointRegion endpointRegion;
    private final Environment environment;
    private final Collection<Scope> scopes;
    private final Collection<String> customScopes;
    private final Locale locale;

    protected SessionConfiguration(@Nonnull String clientId, @Nonnull String clientSecret, @Nonnull String serverToken, @Nonnull String redirectUri, @Nonnull EndpointRegion endpointRegion, @Nonnull Environment environment, @Nonnull Collection<Scope> scopes, @Nonnull Collection<String> customScopes, @Nonnull Locale locale) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.serverToken = serverToken;
        this.redirectUri = redirectUri;
        this.endpointRegion = endpointRegion;
        this.environment = environment;
        this.scopes = scopes;
        this.customScopes = customScopes;
        this.locale = locale;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getServerToken() {
        return this.serverToken;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public EndpointRegion getEndpointRegion() {
        return this.endpointRegion;
    }

    @Nonnull
    public String getEndpointHost() {
        return String.format("https://%s.%s", this.environment.subDomain, EndpointRegion.DEFAULT.getDomain());
    }

    @Nonnull
    public String getLoginHost() {
        return String.format("https://login.%s", EndpointRegion.DEFAULT.getDomain());
    }

    public Collection<Scope> getScopes() {
        return this.scopes;
    }

    public Collection<String> getCustomScopes() {
        return this.customScopes;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Builder newBuilder() {
        return new Builder().setClientId(this.clientId).setRedirectUri(this.redirectUri).setEnvironment(this.environment).setScopes(this.scopes);
    }

    public static class Builder {
        private String clientId;
        private String clientSecret;
        private String serverToken;
        private String redirectUri;
        private Environment environment;
        private Collection<Scope> scopes;
        private Collection<String> customScopes;
        private Locale locale;

        public Builder setClientId(@Nonnull String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setClientSecret(@Nonnull String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder setServerToken(@Nonnull String serverToken) {
            this.serverToken = serverToken;
            return this;
        }

        public Builder setRedirectUri(@Nonnull String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public Builder setEnvironment(@Nonnull Environment environment) {
            this.environment = environment;
            return this;
        }

        public Builder setScopes(@Nonnull Collection<Scope> scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder setCustomScopes(@Nonnull Collection<String> scopes) {
            this.customScopes = scopes;
            return this;
        }

        public Builder setLocale(@Nonnull Locale locale) {
            this.locale = locale;
            return this;
        }

        public SessionConfiguration build() {
            Preconditions.checkNotNull(this.clientId, "Client must be set");
            if (this.environment == null) {
                this.environment = Environment.PRODUCTION;
            }
            if (this.locale == null) {
                this.locale = Locale.US;
            }
            this.scopes = this.scopes == null ? new HashSet<Scope>() : new HashSet<Scope>(this.scopes);
            this.customScopes = this.customScopes == null ? new HashSet<String>() : new HashSet<String>(this.customScopes);
            return new SessionConfiguration(this.clientId, this.clientSecret, this.serverToken, this.redirectUri, EndpointRegion.DEFAULT, this.environment, this.scopes, this.customScopes, this.locale);
        }
    }

    public static enum EndpointRegion {
        DEFAULT("uber.com");

        private String domain;

        private EndpointRegion(String domain) {
            this.domain = domain;
        }

        public String getDomain() {
            return this.domain;
        }
    }

    public static enum Environment {
        PRODUCTION("api"),
        SANDBOX("sandbox-api");

        public String subDomain;

        private Environment(String subDomain) {
            this.subDomain = subDomain;
        }
    }
}

