/*
 * Decompiled with CFR 0.152.
 */
package com.uber.sdk.rides.client;

import com.squareup.moshi.Moshi;
import com.uber.sdk.rides.client.Session;
import com.uber.sdk.rides.client.internal.ApiInterceptor;
import com.uber.sdk.rides.client.internal.BigDecimalAdapter;
import com.uber.sdk.rides.client.internal.RefreshAuthenticator;
import com.uber.sdk.rides.client.services.RidesService;
import javax.annotation.Nonnull;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiConverterFactory;

public class UberRidesApi {
    private final Retrofit retrofit;

    @Nonnull
    public static Builder with(@Nonnull Session session) {
        return new Builder(session);
    }

    private UberRidesApi(@Nonnull Retrofit retrofit) {
        this.retrofit = retrofit;
    }

    public RidesService createService() {
        return (RidesService)this.retrofit.create(RidesService.class);
    }

    public static class Builder {
        Session session;
        HttpLoggingInterceptor.Level logLevel;
        HttpLoggingInterceptor.Logger logger;
        OkHttpClient client;

        Builder(@Nonnull Session session) {
            this.session = session;
        }

        @Nonnull
        public Builder setLogLevel(@Nonnull HttpLoggingInterceptor.Level logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Nonnull
        public Builder setLogger(@Nonnull HttpLoggingInterceptor.Logger logger) {
            this.logger = logger;
            return this;
        }

        @Nonnull
        public Builder setOkHttpClient(@Nonnull OkHttpClient client) {
            this.client = client;
            return this;
        }

        public UberRidesApi build() {
            if (this.logLevel == null) {
                this.logLevel = HttpLoggingInterceptor.Level.NONE;
            }
            if (this.logger == null) {
                this.logger = HttpLoggingInterceptor.Logger.DEFAULT;
            }
            if (this.client == null) {
                this.client = new OkHttpClient();
            }
            HttpLoggingInterceptor loggingInterceptor = this.createLoggingInterceptor(this.logger, this.logLevel);
            OkHttpClient newClient = this.createClient(this.client, this.session, loggingInterceptor);
            Retrofit retrofit = this.createRetrofit(newClient, this.session);
            return new UberRidesApi(retrofit);
        }

        HttpLoggingInterceptor createLoggingInterceptor(HttpLoggingInterceptor.Logger logger, HttpLoggingInterceptor.Level level) {
            HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(logger);
            loggingInterceptor.setLevel(level);
            return loggingInterceptor;
        }

        OkHttpClient createClient(OkHttpClient client, Session session, HttpLoggingInterceptor loggingInterceptor) {
            return client.newBuilder().authenticator((Authenticator)new RefreshAuthenticator((com.uber.sdk.core.auth.Authenticator)session.getAuthenticator())).addInterceptor((Interceptor)new ApiInterceptor((com.uber.sdk.core.auth.Authenticator)session.getAuthenticator())).addInterceptor((Interceptor)loggingInterceptor).build();
        }

        Retrofit createRetrofit(OkHttpClient client, Session session) {
            Moshi moshi = new Moshi.Builder().add((Object)new BigDecimalAdapter()).build();
            return new Retrofit.Builder().addConverterFactory((Converter.Factory)MoshiConverterFactory.create((Moshi)moshi)).baseUrl(session.getAuthenticator().getSessionConfiguration().getEndpointHost()).client(client).build();
        }
    }
}

