/*
 * Decompiled with CFR 0.152.
 */
package com.uber.sdk.rides.client.error;

import com.uber.sdk.rides.client.error.ClientError;
import com.uber.sdk.rides.client.error.CompatibilityApiError;
import com.uber.sdk.rides.client.error.Meta;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ApiError {
    @Nullable
    private final Meta meta;
    @Nonnull
    private final List<ClientError> errors;

    public ApiError(@Nullable Meta meta, @Nonnull List<ClientError> clientErrors) {
        this.meta = meta;
        this.errors = clientErrors;
    }

    ApiError(@Nonnull CompatibilityApiError oldApiError, int statusCode) {
        this(oldApiError.code, statusCode, oldApiError.message);
    }

    ApiError(@Nullable String code, int statusCode, @Nullable String message) {
        this(null, Collections.singletonList(new ClientError(code, statusCode, message)));
    }

    @Nullable
    public Meta getMeta() {
        return this.meta;
    }

    @Nonnull
    public List<ClientError> getClientErrors() {
        return this.errors;
    }
}

