/*
 * Decompiled with CFR 0.152.
 */
package com.uber.sdk.rides.client.error;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.Moshi;
import com.uber.sdk.rides.client.error.ApiError;
import com.uber.sdk.rides.client.error.CompatibilityApiError;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import retrofit2.Response;

public final class ErrorParser {
    @Nullable
    public static ApiError parseError(@Nonnull Response<?> response) {
        if (response.isSuccessful()) {
            return null;
        }
        try {
            return ErrorParser.parseError(response.errorBody().string(), response.code(), response.message());
        }
        catch (IOException e) {
            return new ApiError(null, response.code(), "Unknown Error");
        }
    }

    @Nonnull
    public static ApiError parseError(@Nullable String errorBody, int statusCode, @Nullable String message) {
        if (errorBody == null) {
            return new ApiError(null, statusCode, message);
        }
        Moshi moshi = new Moshi.Builder().build();
        JsonAdapter oldApiErrorJsonAdapter = moshi.adapter(CompatibilityApiError.class).failOnUnknown();
        try {
            return new ApiError((CompatibilityApiError)oldApiErrorJsonAdapter.fromJson(errorBody), statusCode);
        }
        catch (JsonDataException | IOException throwable) {
            JsonAdapter apiErrorJsonAdapter = moshi.adapter(ApiError.class).failOnUnknown();
            try {
                return (ApiError)apiErrorJsonAdapter.fromJson(errorBody);
            }
            catch (JsonDataException | IOException exception) {
                return new ApiError(null, statusCode, "Unknown Error");
            }
        }
    }
}

