/*
 * Decompiled with CFR 0.152.
 */
package com.uber.sdk.rides.client.internal;

import com.uber.sdk.core.auth.Authenticator;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class ApiInterceptor
implements Interceptor {
    static final String HEADER_ACCESS_TOKEN = "Authorization";
    static final String LIB_VERSION = "0.6.0";
    static final String HEADER_ACCEPT_LANGUAGE = "Accept-Language";
    static final String HEADER_USER_AGENT = "X-Uber-User-Agent";
    public final Authenticator authenticator;

    public ApiInterceptor(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request.Builder requestBuilder = chain.request().newBuilder();
        requestBuilder.addHeader(HEADER_ACCEPT_LANGUAGE, this.authenticator.getSessionConfiguration().getLocale().getLanguage());
        requestBuilder.addHeader(HEADER_USER_AGENT, "Java Rides SDK v0.6.0");
        this.authenticator.signRequest(requestBuilder);
        return chain.proceed(requestBuilder.build());
    }

    public static void setAuthorizationHeader(Request.Builder builder, String authorizationHeader) {
        builder.removeHeader(HEADER_ACCESS_TOKEN);
        builder.addHeader(HEADER_ACCESS_TOKEN, authorizationHeader);
    }

    public static String getAuthorizationHeader(Request request) {
        return request.header(HEADER_ACCESS_TOKEN);
    }
}

