/*
 * Decompiled with CFR 0.152.
 */
package com.uber.sdk.rides.client.internal;

import java.io.IOException;
import okhttp3.Authenticator;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public class RefreshAuthenticator
implements Authenticator {
    static final String HEADER_INVALID_SCOPES = "X-Uber-Missing-Scopes";
    static final int MAX_RETRIES = 3;
    public final com.uber.sdk.core.auth.Authenticator authenticator;

    public RefreshAuthenticator(com.uber.sdk.core.auth.Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public Request authenticate(Route route, Response response) throws IOException {
        if (this.authenticator.isRefreshable() && this.canRefresh(response) && this.canRetry(response)) {
            return this.authenticator.refresh(response);
        }
        return null;
    }

    boolean canRefresh(Response response) {
        return response.header(HEADER_INVALID_SCOPES) == null;
    }

    boolean canRetry(Response response) {
        int responseCount = 1;
        while ((response = response.priorResponse()) != null) {
            ++responseCount;
        }
        return responseCount < 3;
    }
}

