/*
 * Decompiled with CFR 0.152.
 */
package com.uber.sdk.rides.client.model;

import com.uber.sdk.rides.client.model.Place;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RideRequestParameters {
    @Nullable
    private String product_id;
    @Nullable
    private Float start_latitude;
    @Nullable
    private Float start_longitude;
    @Nullable
    private String start_nickname;
    @Nullable
    private String start_address;
    @Nullable
    private String start_place_id;
    @Nullable
    private Float end_latitude;
    @Nullable
    private Float end_longitude;
    @Nullable
    private String end_nickname;
    @Nullable
    private String end_address;
    @Nullable
    private String end_place_id;
    @Nullable
    private String surge_confirmation_id;
    @Nullable
    private String payment_method_id;
    @Nullable
    private Integer seat_count;
    @Nullable
    private String fare_id;

    private RideRequestParameters(@Nullable String productId, @Nullable Float startLatitude, @Nullable Float startLongitude, @Nullable String startNickname, @Nullable String startAddress, @Nullable String startPlaceId, @Nullable Float endLatitude, @Nullable Float endLongitude, @Nullable String endNickname, @Nullable String endAddress, @Nullable String endPlaceId, @Nullable String surgeConfirmationId, @Nullable String paymentMethodId, @Nullable Integer seatCount, @Nullable String fareId) {
        this.product_id = productId;
        this.start_latitude = startLatitude;
        this.start_longitude = startLongitude;
        this.start_nickname = startNickname;
        this.start_address = startAddress;
        this.start_place_id = startPlaceId;
        this.end_latitude = endLatitude;
        this.end_longitude = endLongitude;
        this.end_nickname = endNickname;
        this.end_address = endAddress;
        this.end_place_id = endPlaceId;
        this.surge_confirmation_id = surgeConfirmationId;
        this.payment_method_id = paymentMethodId;
        this.seat_count = seatCount;
        this.fare_id = fareId;
    }

    @Nonnull
    public Builder newBuilder() {
        return new Builder(this.product_id, this.start_latitude, this.start_longitude, this.start_nickname, this.start_address, this.start_place_id, this.end_latitude, this.end_longitude, this.end_nickname, this.end_address, this.end_place_id, this.surge_confirmation_id, this.payment_method_id, this.seat_count, this.fare_id);
    }

    @Nullable
    public String getProductId() {
        return this.product_id;
    }

    @Nullable
    public Float getPickupLatitude() {
        return this.start_latitude;
    }

    @Nullable
    public Float getPickupLongitude() {
        return this.start_longitude;
    }

    @Nullable
    public String getPickupNickname() {
        return this.start_nickname;
    }

    @Nullable
    public String getPickupAddress() {
        return this.start_address;
    }

    @Nullable
    public String getPickupPlaceId() {
        return this.start_place_id;
    }

    @Nullable
    public Float getDropoffLatitude() {
        return this.end_latitude;
    }

    @Nullable
    public Float getDropoffLongitude() {
        return this.end_longitude;
    }

    @Nullable
    public String getDropoffNickname() {
        return this.end_nickname;
    }

    @Nullable
    public String getDropoffAddress() {
        return this.end_address;
    }

    @Nullable
    public String getDropoffPlaceId() {
        return this.end_place_id;
    }

    @Nullable
    public String getSurgeConfirmationId() {
        return this.surge_confirmation_id;
    }

    public void setSurgeConfirmationId(@Nullable String surgeConfirmationId) {
        this.surge_confirmation_id = surgeConfirmationId;
    }

    @Nullable
    public String getPaymentMethodId() {
        return this.payment_method_id;
    }

    @Nullable
    public Integer getSeatCount() {
        return this.seat_count;
    }

    @Nullable
    public String getFareId() {
        return this.fare_id;
    }

    public static class Builder {
        @Nullable
        private String productId;
        @Nullable
        private Float startLatitude;
        @Nullable
        private Float startLongitude;
        @Nullable
        private String startNickname;
        @Nullable
        private String startAddress;
        @Nullable
        private String startPlaceId;
        @Nullable
        private Float endLatitude;
        @Nullable
        private Float endLongitude;
        @Nullable
        private String endNickname;
        @Nullable
        private String endAddress;
        @Nullable
        private String endPlaceId;
        @Nullable
        private String surgeConfirmationId;
        @Nullable
        private String paymentMethodId;
        @Nullable
        private Integer seatCount;
        @Nullable
        private String fareId;

        public Builder() {
        }

        public Builder(@Nullable String productId, @Nullable Float startLatitude, @Nullable Float startLongitude, @Nullable String startNickname, @Nullable String startAddress, @Nullable String startPlaceId, @Nullable Float endLatitude, @Nullable Float endLongitude, @Nullable String endNickname, @Nullable String endAddress, @Nullable String endPlaceId, @Nullable String surgeConfirmationId, @Nullable String paymentMethodId, @Nullable Integer seatCount, @Nullable String fareId) {
            this.productId = productId;
            this.startLatitude = startLatitude;
            this.startLongitude = startLongitude;
            this.startNickname = startNickname;
            this.startAddress = startAddress;
            this.startPlaceId = startPlaceId;
            this.endLatitude = endLatitude;
            this.endLongitude = endLongitude;
            this.endNickname = endNickname;
            this.endAddress = endAddress;
            this.endPlaceId = endPlaceId;
            this.surgeConfirmationId = surgeConfirmationId;
            this.paymentMethodId = paymentMethodId;
            this.seatCount = seatCount;
            this.fareId = fareId;
        }

        public Builder setProductId(@Nonnull String productId) {
            this.productId = productId;
            return this;
        }

        public Builder setPickupCoordinates(@Nullable Float latitude, @Nullable Float longitude) {
            this.startLatitude = latitude;
            this.startLongitude = longitude;
            return this;
        }

        public Builder setPickupNickname(@Nullable String nickname) {
            this.startNickname = nickname;
            return this;
        }

        public Builder setPickupAddress(@Nullable String address) {
            this.startAddress = address;
            return this;
        }

        public Builder setPickupPlaceId(@Nullable String placeId) {
            this.startPlaceId = placeId;
            return this;
        }

        public Builder setPickupPlace(@Nullable Place.Places place) {
            this.startPlaceId = place == null ? null : place.toString();
            return this;
        }

        public Builder setDropoffCoordinates(@Nullable Float latitude, @Nullable Float longitude) {
            this.endLatitude = latitude;
            this.endLongitude = longitude;
            return this;
        }

        public Builder setDropoffNickname(@Nullable String nickname) {
            this.endNickname = nickname;
            return this;
        }

        public Builder setDropoffAddress(@Nullable String address) {
            this.endAddress = address;
            return this;
        }

        public Builder setDropoffPlaceId(@Nullable String placeId) {
            this.endPlaceId = placeId;
            return this;
        }

        public Builder setDropoffPlace(@Nullable Place.Places place) {
            this.endPlaceId = place == null ? null : place.toString();
            return this;
        }

        public Builder setSurgeConfirmationId(@Nullable String surgeConfirmationId) {
            this.surgeConfirmationId = surgeConfirmationId;
            return this;
        }

        public Builder setPaymentMethodId(@Nullable String paymentMethodId) {
            this.paymentMethodId = paymentMethodId;
            return this;
        }

        public Builder setSeatCount(@Nullable Integer seatCount) {
            this.seatCount = seatCount;
            return this;
        }

        public Builder setFareId(@Nullable String fareId) {
            this.fareId = fareId;
            return this;
        }

        private void validate() {
            if (this.startPlaceId != null) {
                if (this.startLatitude != null || this.startLongitude != null) {
                    throw new IllegalArgumentException("Exactly one of pickup place or pickup coordinates must be specified");
                }
            } else {
                if (this.startLatitude == null && this.startLongitude == null) {
                    throw new IllegalArgumentException("Exactly one of pickup place or pickup coordinates must be specified");
                }
                if (this.startLatitude == null || this.startLongitude == null) {
                    throw new IllegalArgumentException("If using coordinates, both pickup latitude and pickup longitude must be present");
                }
            }
            if (this.endPlaceId != null) {
                if (this.endLatitude != null || this.endLongitude != null) {
                    throw new IllegalArgumentException("Exactly one of dropoff place or dropoff coordinates must be specified.");
                }
            } else {
                if (this.endLatitude == null && this.endLongitude == null) {
                    throw new IllegalArgumentException("Exactly one of dropoff place or dropoff coordinates must be specified.");
                }
                if (this.endLatitude == null || this.endLongitude == null) {
                    throw new IllegalArgumentException("If using coordinates, both dropoff latitude and dropoff longitude must be present");
                }
            }
        }

        public RideRequestParameters build() {
            this.validate();
            return new RideRequestParameters(this.productId, this.startLatitude, this.startLongitude, this.startNickname, this.startAddress, this.startPlaceId, this.endLatitude, this.endLongitude, this.endNickname, this.endAddress, this.endPlaceId, this.surgeConfirmationId, this.paymentMethodId, this.seatCount, this.fareId);
        }
    }
}

