/*
 * Decompiled with CFR 0.152.
 */
package com.uber.sdk.rides.client.model;

import com.uber.sdk.rides.client.model.Place;
import javax.annotation.Nullable;

public class RideUpdateParameters {
    @Nullable
    private Float end_latitude;
    @Nullable
    private Float end_longitude;
    @Nullable
    private String end_nickname;
    @Nullable
    private String end_address;
    @Nullable
    private String end_place_id;

    private RideUpdateParameters(@Nullable Float endLatitude, @Nullable Float endLongitude, @Nullable String endNickname, @Nullable String endAddress, @Nullable String endPlaceId) {
        this.end_latitude = endLatitude;
        this.end_longitude = endLongitude;
        this.end_nickname = endNickname;
        this.end_address = endAddress;
        this.end_place_id = endPlaceId;
    }

    @Nullable
    public Float getDropoffatitude() {
        return this.end_latitude;
    }

    @Nullable
    public Float getDropoffLongitude() {
        return this.end_longitude;
    }

    @Nullable
    public String getDropoffNickname() {
        return this.end_nickname;
    }

    @Nullable
    public String getDropoffAddress() {
        return this.end_address;
    }

    @Nullable
    public String getDropoffPlaceId() {
        return this.end_place_id;
    }

    public static class Builder {
        @Nullable
        private Float endLatitude;
        @Nullable
        private Float endLongitude;
        @Nullable
        private String endNickname;
        @Nullable
        private String endAddress;
        @Nullable
        private String endPlaceId;

        public Builder setDropoffCoordinates(@Nullable Float latitude, @Nullable Float longitude) {
            this.endLatitude = latitude;
            this.endLongitude = longitude;
            return this;
        }

        public Builder setDropoffNickname(@Nullable String nickname) {
            this.endNickname = nickname;
            return this;
        }

        public Builder setDropoffAddress(@Nullable String address) {
            this.endAddress = address;
            return this;
        }

        public Builder setDropoffPlaceId(@Nullable String placeId) {
            this.endPlaceId = placeId;
            return this;
        }

        public Builder setDropoffPlace(@Nullable Place.Places place) {
            this.endPlaceId = place == null ? null : place.toString();
            return this;
        }

        private void validate() {
            if (this.endPlaceId != null) {
                if (this.endLatitude != null || this.endLongitude != null) {
                    throw new IllegalArgumentException("Exactly one of dropoff place or dropoff coordinates is required.");
                }
            } else {
                if (this.endLatitude == null && this.endLongitude == null) {
                    throw new IllegalArgumentException("Exactly one of dropoff place or dropoff coordinates is required.");
                }
                if (this.endLatitude == null || this.endLongitude == null) {
                    throw new IllegalArgumentException("Need both dropoff latitude and dropoff longitude");
                }
            }
        }

        public RideUpdateParameters build() {
            this.validate();
            return new RideUpdateParameters(this.endLatitude, this.endLongitude, this.endNickname, this.endAddress, this.endPlaceId);
        }
    }
}

