/*
 * Decompiled with CFR 0.152.
 */
package com.uber.sdk.rides.client.services;

import com.uber.sdk.rides.client.model.PaymentMethodsResponse;
import com.uber.sdk.rides.client.model.Place;
import com.uber.sdk.rides.client.model.PlaceParameters;
import com.uber.sdk.rides.client.model.PriceEstimatesResponse;
import com.uber.sdk.rides.client.model.Product;
import com.uber.sdk.rides.client.model.ProductsResponse;
import com.uber.sdk.rides.client.model.Promotion;
import com.uber.sdk.rides.client.model.Ride;
import com.uber.sdk.rides.client.model.RideEstimate;
import com.uber.sdk.rides.client.model.RideMap;
import com.uber.sdk.rides.client.model.RideRequestParameters;
import com.uber.sdk.rides.client.model.RideUpdateParameters;
import com.uber.sdk.rides.client.model.SandboxProductRequestParameters;
import com.uber.sdk.rides.client.model.SandboxRideRequestParameters;
import com.uber.sdk.rides.client.model.TimeEstimatesResponse;
import com.uber.sdk.rides.client.model.UserActivityPage;
import com.uber.sdk.rides.client.model.UserProfile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface RidesService {
    @GET(value="/v1.2/promotions")
    public Call<Promotion> getPromotions(@Query(value="start_latitude") float var1, @Query(value="start_longitude") float var2, @Query(value="end_latitude") float var3, @Query(value="end_longitude") float var4);

    @GET(value="/v1.2/history")
    public Call<UserActivityPage> getUserActivity(@Nullable @Query(value="offset") Integer var1, @Nullable @Query(value="limit") Integer var2);

    @GET(value="/v1.2/me")
    public Call<UserProfile> getUserProfile();

    @GET(value="/v1.2/estimates/price")
    public Call<PriceEstimatesResponse> getPriceEstimates(@Query(value="start_latitude") float var1, @Query(value="start_longitude") float var2, @Query(value="end_latitude") float var3, @Query(value="end_longitude") float var4);

    @GET(value="/v1.2/estimates/time")
    public Call<TimeEstimatesResponse> getPickupTimeEstimate(@Query(value="start_latitude") float var1, @Query(value="start_longitude") float var2, @Nullable @Query(value="product_id") String var3);

    @GET(value="/v1.2/products")
    public Call<ProductsResponse> getProducts(@Query(value="latitude") float var1, @Query(value="longitude") float var2);

    @GET(value="/v1.2/products/{product_id}")
    public Call<Product> getProduct(@Path(value="product_id") String var1);

    @DELETE(value="/v1.2/requests/{request_id}")
    public Call<Void> cancelRide(@Path(value="request_id") String var1);

    @POST(value="/v1.2/requests")
    public Call<Ride> requestRide(@Body RideRequestParameters var1);

    @GET(value="/v1.2/requests/current")
    public Call<Ride> getCurrentRide();

    @DELETE(value="/v1.2/requests/current")
    public Call<Void> cancelCurrentRide();

    @PATCH(value="/v1.2/requests/{request_id}")
    public Call<Void> updateRide(@Nonnull @Path(value="request_id") String var1, @Body RideUpdateParameters var2);

    @GET(value="/v1.2/places/{place_id}")
    public Call<Place> getPlace(@Nonnull @Path(value="place_id") String var1);

    @PUT(value="/v1.2/places/{place_id}")
    public Call<Place> setPlace(@Nonnull @Path(value="place_id") String var1, @Nonnull @Body PlaceParameters var2);

    @GET(value="/v1.2/requests/{request_id}")
    public Call<Ride> getRideDetails(@Nonnull @Path(value="request_id") String var1);

    @POST(value="/v1.2/requests/estimate")
    public Call<RideEstimate> estimateRide(@Body RideRequestParameters var1);

    @GET(value="/v1.2/requests/{request_id}/map")
    public Call<RideMap> getRideMap(@Nonnull @Path(value="request_id") String var1);

    @GET(value="/v1.2/payment-methods")
    public Call<PaymentMethodsResponse> getPaymentMethods();

    @PUT(value="/v1.2/sandbox/products/{product_id}")
    public Call<Void> updateSandboxProduct(@Path(value="product_id") String var1, @Body SandboxProductRequestParameters var2);

    @PUT(value="/v1.2/sandbox/requests/{request_id}")
    public Call<Void> updateSandboxRide(@Path(value="request_id") String var1, @Body SandboxRideRequestParameters var2);
}

