/*
 * Decompiled with CFR 0.152.
 */
package com.uber.sdk.rides.client.utils;

import java.util.Collection;
import javax.annotation.Nonnull;

public class Preconditions {
    public static void checkState(boolean expression, @Nonnull String errorMessage) {
        if (!expression) {
            throw new IllegalStateException(errorMessage);
        }
    }

    @Nonnull
    public static <T> T checkNotNull(T value, @Nonnull String errorMessage) {
        if (value == null) {
            throw new NullPointerException(errorMessage);
        }
        return value;
    }

    @Nonnull
    public static <T> Collection<T> checkNotEmpty(Collection<T> collection, @Nonnull String errorMessage) {
        Preconditions.checkState(collection != null && !collection.isEmpty(), errorMessage);
        return collection;
    }
}

