/*
 * Decompiled with CFR 0.152.
 */
package com.uchuhimo.konf.source;

import com.uchuhimo.konf.ContainerNode;
import com.uchuhimo.konf.Feature;
import com.uchuhimo.konf.ItemKt;
import com.uchuhimo.konf.MergedMap;
import com.uchuhimo.konf.TreeNode;
import com.uchuhimo.konf.UtilsKt;
import com.uchuhimo.konf.source.BaseSource;
import com.uchuhimo.konf.source.DefaultProviders;
import com.uchuhimo.konf.source.MergedSource;
import com.uchuhimo.konf.source.NoSuchPathException;
import com.uchuhimo.konf.source.SourceInfo;
import com.uchuhimo.konf.source.SourceKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0019\bf\u0018\u0000 /2\u00020\u0001:\u0001/J\u001b\u0010\u0014\u001a\u00020\t2\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u00030\u0016j\u0002`\u0017H\u0096\u0002J\u0011\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0003H\u0096\u0002J\u0010\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u0010\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u001b\u0010\u001c\u001a\u00020\u00002\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u00030\u0016j\u0002`\u0017H\u0096\u0002J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0003H\u0096\u0002J0\u0010\u001d\u001a\u0004\u0018\u00010\u00112\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u00030\u0016j\u0002`\u00172\b\b\u0002\u0010\u001e\u001a\u00020\t2\b\b\u0002\u0010\u001f\u001a\u00020\tH\u0016J\u001c\u0010 \u001a\u0004\u0018\u00010\u00002\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u00030\u0016j\u0002`\u0017H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J$\u0010!\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u00030\u0016j\u0002`\u0017H\u0002J\u0010\u0010\"\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u0012\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u001b\u001a\u00020\tH\u0016J\u0012\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u001b\u001a\u00020\tH\u0016J\u001c\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u001e\u001a\u00020\t2\b\b\u0002\u0010\u001f\u001a\u00020\tH\u0016J\u0010\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003H\u0002J8\u0010&\u001a\f\u0012\u0004\u0012\u00020\u00030\u0016j\u0002`\u00172\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u00030\u0016j\u0002`\u00172\b\b\u0002\u0010\u001e\u001a\u00020\t2\b\b\u0002\u0010\u001f\u001a\u00020\tH\u0002J\u0011\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0000H\u0096\u0002J&\u0010)\u001a\u00020\u00002\b\b\u0002\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u001b\u001a\u00020\t2\b\b\u0002\u0010+\u001a\u00020\tH\u0016J\u0010\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0000H\u0016J\u001a\u0010.\u001a\u00020\u00002\u0010\u0010\u0018\u001a\f\u0012\u0004\u0012\u00020\u00030\u0016j\u0002`\u0017H\u0016J\u0010\u0010.\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00060"}, d2={"Lcom/uchuhimo/konf/source/Source;", "", "description", "", "getDescription", "()Ljava/lang/String;", "features", "", "Lcom/uchuhimo/konf/Feature;", "", "getFeatures", "()Ljava/util/Map;", "info", "Lcom/uchuhimo/konf/source/SourceInfo;", "getInfo", "()Lcom/uchuhimo/konf/source/SourceInfo;", "tree", "Lcom/uchuhimo/konf/TreeNode;", "getTree", "()Lcom/uchuhimo/konf/TreeNode;", "contains", "path", "", "Lcom/uchuhimo/konf/Path;", "prefix", "disabled", "feature", "enabled", "get", "getNodeOrNull", "lowercased", "littleCamelCased", "getOrNull", "getTreeOrNull", "isEnabled", "normalized", "normalizedKey", "key", "normalizedPath", "plus", "facade", "substituted", "root", "errorWhenUndefined", "withFallback", "fallback", "withPrefix", "Companion", "konf-core"})
public interface Source {
    @NotNull
    public static final Companion Companion = com.uchuhimo.konf.source.Source$Companion.$$INSTANCE;

    @NotNull
    public String getDescription();

    @NotNull
    public SourceInfo getInfo();

    @NotNull
    public TreeNode getTree();

    @NotNull
    public Map<Feature, Boolean> getFeatures();

    public boolean contains(@NotNull List<String> var1);

    @Nullable
    public Source getOrNull(@NotNull List<String> var1);

    @Nullable
    public TreeNode getNodeOrNull(@NotNull List<String> var1, boolean var2, boolean var3);

    @NotNull
    public Source get(@NotNull List<String> var1);

    public boolean contains(@NotNull String var1);

    @Nullable
    public Source getOrNull(@NotNull String var1);

    @NotNull
    public Source get(@NotNull String var1);

    @NotNull
    public Source withPrefix(@NotNull List<String> var1);

    @NotNull
    public Source withPrefix(@NotNull String var1);

    @NotNull
    public Source withFallback(@NotNull Source var1);

    @NotNull
    public Source plus(@NotNull Source var1);

    @NotNull
    public Source substituted(@NotNull Source var1, boolean var2, boolean var3);

    @NotNull
    public Source lowercased(boolean var1);

    @NotNull
    public Source littleCamelCased(boolean var1);

    @NotNull
    public Source normalized(boolean var1, boolean var2);

    @NotNull
    public Source enabled(@NotNull Feature var1);

    @NotNull
    public Source disabled(@NotNull Feature var1);

    public boolean isEnabled(@NotNull Feature var1);

    @JvmStatic
    @NotNull
    public static DefaultProviders from() {
        return Companion.from();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public static String getDescription(@NotNull Source $this) {
            void $this$mapTo$iv$iv;
            Map $this$map$iv = $this.getInfo();
            boolean $i$f$map = false;
            Map map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            void var6_6 = $this$mapTo$iv$iv;
            boolean bl = false;
            Iterator iterator = var6_6.entrySet().iterator();
            while (iterator.hasNext()) {
                void name;
                void $dstr$name$value;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                void var12_12 = $dstr$name$value;
                boolean bl3 = false;
                String string = (String)var12_12.getKey();
                var12_12 = $dstr$name$value;
                bl3 = false;
                String value2 = (String)var12_12.getValue();
                String string2 = (String)name + ": " + value2;
                collection.add(string2);
            }
            return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null);
        }

        @NotNull
        public static Map<Feature, Boolean> getFeatures(@NotNull Source $this) {
            return MapsKt.emptyMap();
        }

        public static boolean contains(@NotNull Source $this, @NotNull List<String> path) {
            Intrinsics.checkNotNullParameter(path, (String)"path");
            return $this.getTree().contains(path);
        }

        @Nullable
        public static Source getOrNull(@NotNull Source $this, @NotNull List<String> path) {
            Source source;
            Intrinsics.checkNotNullParameter(path, (String)"path");
            if (path.isEmpty()) {
                source = $this;
            } else {
                TreeNode treeNode = DefaultImpls.getTreeOrNull($this, $this.getTree(), DefaultImpls.normalizedPath$default($this, path, false, false, 6, null));
                if (treeNode != null) {
                    TreeNode treeNode2 = treeNode;
                    boolean bl = false;
                    boolean bl2 = false;
                    TreeNode it = treeNode2;
                    boolean bl3 = false;
                    source = Companion.invoke($this.getInfo(), it, $this.getFeatures());
                } else {
                    source = null;
                }
            }
            return source;
        }

        /*
         * WARNING - void declaration
         */
        private static TreeNode getTreeOrNull(Source $this, TreeNode tree2, List<String> path) {
            TreeNode treeNode;
            if (path.isEmpty()) {
                treeNode = tree2;
            } else {
                Object object;
                String key = DefaultImpls.normalizedKey($this, (String)CollectionsKt.first(path));
                List rest = CollectionsKt.drop((Iterable)path, (int)1);
                TreeNode result = null;
                Object object2 = tree2.getChildren();
                boolean bl = false;
                Iterator<Map.Entry<String, TreeNode>> iterator = object2.entrySet().iterator();
                while (iterator.hasNext()) {
                    void childKey;
                    Object object3 = object = iterator.next();
                    boolean bl2 = false;
                    object2 = (String)object3.getKey();
                    object3 = object;
                    bl2 = false;
                    TreeNode child = (TreeNode)object3.getValue();
                    if (!Intrinsics.areEqual((Object)key, (Object)DefaultImpls.normalizedKey($this, (String)childKey))) continue;
                    result = child;
                    break;
                }
                TreeNode treeNode2 = result;
                if (treeNode2 != null) {
                    object = treeNode2;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Object it = object;
                    boolean bl5 = false;
                    treeNode = DefaultImpls.getTreeOrNull($this, (TreeNode)it, rest);
                } else {
                    treeNode = null;
                }
            }
            return treeNode;
        }

        private static String normalizedKey(Source $this, String key) {
            String currentKey = key;
            if ($this.isEnabled(Feature.LOAD_KEYS_AS_LITTLE_CAMEL_CASE)) {
                currentKey = UtilsKt.toLittleCamelCase(currentKey);
            }
            if ($this.isEnabled(Feature.LOAD_KEYS_CASE_INSENSITIVELY)) {
                String string = currentKey;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                currentKey = string3;
            }
            return currentKey;
        }

        private static List<String> normalizedPath(Source $this, List<String> path, boolean lowercased, boolean littleCamelCased) {
            String string;
            String it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv;
            boolean $i$f$map;
            Iterable $this$map$iv;
            List currentPath = path;
            if (littleCamelCased && $this.isEnabled(Feature.LOAD_KEYS_AS_LITTLE_CAMEL_CASE)) {
                $this$map$iv = currentPath;
                $i$f$map = false;
                Iterable iterable = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string2 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    string = UtilsKt.toLittleCamelCase(it);
                    collection.add(string);
                }
                currentPath = (List)destination$iv$iv;
            }
            if (lowercased || $this.isEnabled(Feature.LOAD_KEYS_CASE_INSENSITIVELY)) {
                $this$map$iv = currentPath;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    String string3 = it;
                    boolean bl2 = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string4.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                    collection.add(string);
                }
                currentPath = (List)destination$iv$iv;
            }
            return currentPath;
        }

        static /* synthetic */ List normalizedPath$default(Source source, List list2, boolean bl, boolean bl2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: normalizedPath");
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                bl2 = true;
            }
            return DefaultImpls.normalizedPath(source, list2, bl, bl2);
        }

        @Nullable
        public static TreeNode getNodeOrNull(@NotNull Source $this, @NotNull List<String> path, boolean lowercased, boolean littleCamelCased) {
            Intrinsics.checkNotNullParameter(path, (String)"path");
            return $this.getTree().getOrNull(DefaultImpls.normalizedPath($this, path, lowercased, littleCamelCased));
        }

        public static /* synthetic */ TreeNode getNodeOrNull$default(Source source, List list2, boolean bl, boolean bl2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getNodeOrNull");
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                bl2 = true;
            }
            return source.getNodeOrNull(list2, bl, bl2);
        }

        @NotNull
        public static Source get(@NotNull Source $this, @NotNull List<String> path) {
            Intrinsics.checkNotNullParameter(path, (String)"path");
            Source source = $this.getOrNull(path);
            if (source == null) {
                throw (Throwable)new NoSuchPathException($this, path);
            }
            return source;
        }

        public static boolean contains(@NotNull Source $this, @NotNull String prefix2) {
            Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
            return $this.contains(ItemKt.toPath(prefix2));
        }

        @Nullable
        public static Source getOrNull(@NotNull Source $this, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return $this.getOrNull(ItemKt.toPath(path));
        }

        @NotNull
        public static Source get(@NotNull Source $this, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return $this.get(ItemKt.toPath(path));
        }

        @NotNull
        public static Source withPrefix(@NotNull Source $this, @NotNull List<String> prefix2) {
            Source source;
            Intrinsics.checkNotNullParameter(prefix2, (String)"prefix");
            if (prefix2.isEmpty()) {
                source = $this;
            } else {
                TreeNode prefixedTree = $this.getTree();
                for (String key : CollectionsKt.asReversed(prefix2)) {
                    prefixedTree = new ContainerNode(MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)key, (Object)prefixedTree)}), false, 2, null);
                }
                source = Companion.invoke($this.getInfo(), prefixedTree, $this.getFeatures());
            }
            return source;
        }

        @NotNull
        public static Source withPrefix(@NotNull Source $this, @NotNull String prefix2) {
            Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
            return $this.withPrefix(ItemKt.toPath(prefix2));
        }

        @NotNull
        public static Source withFallback(@NotNull Source $this, @NotNull Source fallback) {
            Intrinsics.checkNotNullParameter((Object)fallback, (String)"fallback");
            return new MergedSource($this, fallback);
        }

        @NotNull
        public static Source plus(@NotNull Source $this, @NotNull Source facade) {
            Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
            return facade.withFallback($this);
        }

        @NotNull
        public static Source substituted(@NotNull Source $this, @NotNull Source root, boolean enabled2, boolean errorWhenUndefined) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            return !enabled2 || !$this.isEnabled(Feature.SUBSTITUTE_SOURCE_BEFORE_LOADED) ? $this : Companion.invoke($this.getInfo(), SourceKt.substituted$default($this.getTree(), root, errorWhenUndefined, null, 4, null), $this.getFeatures());
        }

        public static /* synthetic */ Source substituted$default(Source source, Source source2, boolean bl, boolean bl2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: substituted");
            }
            if ((n & 1) != 0) {
                source2 = source;
            }
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                bl2 = true;
            }
            return source.substituted(source2, bl, bl2);
        }

        @NotNull
        public static Source lowercased(@NotNull Source $this, boolean enabled2) {
            return enabled2 || $this.isEnabled(Feature.LOAD_KEYS_CASE_INSENSITIVELY) ? Companion.invoke($this.getInfo(), SourceKt.access$lowercased($this.getTree()), $this.getFeatures()) : $this;
        }

        public static /* synthetic */ Source lowercased$default(Source source, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: lowercased");
            }
            if ((n & 1) != 0) {
                bl = false;
            }
            return source.lowercased(bl);
        }

        @NotNull
        public static Source littleCamelCased(@NotNull Source $this, boolean enabled2) {
            return !enabled2 || !$this.isEnabled(Feature.LOAD_KEYS_AS_LITTLE_CAMEL_CASE) ? $this : Companion.invoke($this.getInfo(), SourceKt.access$littleCamelCased($this.getTree()), $this.getFeatures());
        }

        public static /* synthetic */ Source littleCamelCased$default(Source source, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: littleCamelCased");
            }
            if ((n & 1) != 0) {
                bl = true;
            }
            return source.littleCamelCased(bl);
        }

        @NotNull
        public static Source normalized(@NotNull Source $this, boolean lowercased, boolean littleCamelCased) {
            Source currentSource = $this;
            currentSource = currentSource.littleCamelCased(littleCamelCased);
            currentSource = currentSource.lowercased(lowercased);
            return currentSource;
        }

        public static /* synthetic */ Source normalized$default(Source source, boolean bl, boolean bl2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: normalized");
            }
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = true;
            }
            return source.normalized(bl, bl2);
        }

        @NotNull
        public static Source enabled(@NotNull Source $this, @NotNull Feature feature) {
            Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
            SourceInfo sourceInfo = $this.getInfo();
            TreeNode treeNode = $this.getTree();
            Map<Feature, Boolean> map2 = Collections.unmodifiableMap($this.getFeatures());
            Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.unmodifiableMap(features)");
            return Companion.invoke(sourceInfo, treeNode, (Map<Feature, Boolean>)new MergedMap<Feature, Boolean>(map2, MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)feature), (Object)true)})));
        }

        @NotNull
        public static Source disabled(@NotNull Source $this, @NotNull Feature feature) {
            Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
            SourceInfo sourceInfo = $this.getInfo();
            TreeNode treeNode = $this.getTree();
            Map<Feature, Boolean> map2 = Collections.unmodifiableMap($this.getFeatures());
            Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.unmodifiableMap(features)");
            return Companion.invoke(sourceInfo, treeNode, (Map<Feature, Boolean>)new MergedMap<Feature, Boolean>(map2, MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)feature), (Object)false)})));
        }

        public static boolean isEnabled(@NotNull Source $this, @NotNull Feature feature) {
            Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
            Boolean bl = $this.getFeatures().get((Object)feature);
            return bl != null ? bl.booleanValue() : feature.getEnabledByDefault();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J3\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0086\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/uchuhimo/konf/source/Source$Companion;", "", "()V", "from", "Lcom/uchuhimo/konf/source/DefaultProviders;", "getFrom", "()Lcom/uchuhimo/konf/source/DefaultProviders;", "invoke", "Lcom/uchuhimo/konf/source/Source;", "info", "Lcom/uchuhimo/konf/source/SourceInfo;", "tree", "Lcom/uchuhimo/konf/TreeNode;", "features", "", "Lcom/uchuhimo/konf/Feature;", "", "konf-core"})
    public static final class Companion {
        @NotNull
        private static final DefaultProviders from;
        static final /* synthetic */ Companion $$INSTANCE;

        @NotNull
        public final Source invoke(@NotNull SourceInfo info2, @NotNull TreeNode tree2, @NotNull Map<Feature, Boolean> features2) {
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
            Intrinsics.checkNotNullParameter(features2, (String)"features");
            return new BaseSource(info2, tree2, features2);
        }

        public static /* synthetic */ Source invoke$default(Companion companion, SourceInfo sourceInfo, TreeNode treeNode, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                sourceInfo = new SourceInfo(null, 1, null);
            }
            if ((n & 2) != 0) {
                treeNode = ContainerNode.Companion.empty();
            }
            if ((n & 4) != 0) {
                map2 = MapsKt.emptyMap();
            }
            return companion.invoke(sourceInfo, treeNode, map2);
        }

        @NotNull
        public final DefaultProviders getFrom() {
            return from;
        }

        @JvmStatic
        @NotNull
        public final DefaultProviders from() {
            return from;
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
            from = DefaultProviders.INSTANCE;
        }
    }
}

