/*
 * Decompiled with CFR 0.152.
 */
package com.uchuhimo.konf.source;

import com.uchuhimo.konf.source.ParseException;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0003\u00a8\u0006\u0006"}, d2={"parseDuration", "", "input", "", "toDuration", "Ljava/time/Duration;", "konf-core"})
public final class UtilsKt {
    @NotNull
    public static final Duration toDuration(@NotNull String $this$toDuration) {
        Duration duration;
        Intrinsics.checkNotNullParameter((Object)$this$toDuration, (String)"$this$toDuration");
        try {
            Duration duration2 = Duration.parse($this$toDuration);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"Duration.parse(this)");
            duration = duration2;
        }
        catch (DateTimeParseException e) {
            Duration duration3 = Duration.ofNanos(UtilsKt.parseDuration($this$toDuration));
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"Duration.ofNanos(parseDuration(this))");
            duration = duration3;
        }
        return duration;
    }

    public static final long parseDuration(@NotNull String input) {
        long l;
        TimeUnit timeUnit;
        String originalUnitString;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String string = input;
        boolean bl = false;
        String s = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String unitString = originalUnitString = com.uchuhimo.konf.UtilsKt.getUnits(s);
        CharSequence charSequence = s;
        int n = 0;
        int n2 = s.length() - unitString.length();
        boolean bl2 = false;
        String string2 = charSequence;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        charSequence = string3;
        n = 0;
        String string4 = charSequence;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String numberString = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        charSequence = numberString;
        n = 0;
        if (charSequence.length() == 0) {
            throw (Throwable)new ParseException("No number in duration value '" + input + '\'');
        }
        if (unitString.length() > 2 && !StringsKt.endsWith$default((String)unitString, (String)"s", (boolean)false, (int)2, null)) {
            unitString = unitString + "s";
        }
        if (Intrinsics.areEqual((Object)unitString, (Object)"") || Intrinsics.areEqual((Object)unitString, (Object)"ms") || Intrinsics.areEqual((Object)unitString, (Object)"millis") || Intrinsics.areEqual((Object)unitString, (Object)"milliseconds")) {
            timeUnit = TimeUnit.MILLISECONDS;
        } else if (Intrinsics.areEqual((Object)unitString, (Object)"us") || Intrinsics.areEqual((Object)unitString, (Object)"micros") || Intrinsics.areEqual((Object)unitString, (Object)"microseconds")) {
            timeUnit = TimeUnit.MICROSECONDS;
        } else if (Intrinsics.areEqual((Object)unitString, (Object)"ns") || Intrinsics.areEqual((Object)unitString, (Object)"nanos") || Intrinsics.areEqual((Object)unitString, (Object)"nanoseconds")) {
            timeUnit = TimeUnit.NANOSECONDS;
        } else if (Intrinsics.areEqual((Object)unitString, (Object)"d") || Intrinsics.areEqual((Object)unitString, (Object)"days")) {
            timeUnit = TimeUnit.DAYS;
        } else if (Intrinsics.areEqual((Object)unitString, (Object)"h") || Intrinsics.areEqual((Object)unitString, (Object)"hours")) {
            timeUnit = TimeUnit.HOURS;
        } else if (Intrinsics.areEqual((Object)unitString, (Object)"s") || Intrinsics.areEqual((Object)unitString, (Object)"seconds")) {
            timeUnit = TimeUnit.SECONDS;
        } else if (Intrinsics.areEqual((Object)unitString, (Object)"m") || Intrinsics.areEqual((Object)unitString, (Object)"minutes")) {
            timeUnit = TimeUnit.MINUTES;
        } else {
            throw (Throwable)new ParseException("Could not parse time unit '" + originalUnitString + "' (try ns, us, ms, s, m, h, d)");
        }
        TimeUnit units = timeUnit;
        try {
            long l2;
            CharSequence charSequence2 = numberString;
            String string5 = "[+-]?[0-9]+";
            bl2 = false;
            string5 = new Regex(string5);
            bl2 = false;
            if (string5.matches(charSequence2)) {
                l2 = units.toNanos(Long.parseLong(numberString));
            } else {
                long nanosInUnit = units.toNanos(1L);
                l2 = (long)(Double.parseDouble(numberString) * (double)nanosInUnit);
            }
            l = l2;
        }
        catch (NumberFormatException e) {
            throw (Throwable)new ParseException("Could not parse duration number '" + numberString + '\'');
        }
        return l;
    }
}

