/*
 * Decompiled with CFR 0.152.
 */
package com.uchuhimo.konf.source.deserializer;

import com.uchuhimo.konf.source.SourceException;
import com.uchuhimo.konf.source.UtilsKt;
import com.uchuhimo.konf.source.deserializer.JSR310Deserializer;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/uchuhimo/konf/source/deserializer/DurationDeserializer;", "Lcom/uchuhimo/konf/source/deserializer/JSR310Deserializer;", "Ljava/time/Duration;", "()V", "parse", "string", "", "konf-core"})
public final class DurationDeserializer
extends JSR310Deserializer<Duration> {
    @NotNull
    public static final DurationDeserializer INSTANCE;

    @Override
    @NotNull
    public Duration parse(@NotNull String string) {
        Duration duration;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        try {
            Duration duration2 = Duration.parse(string);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"Duration.parse(string)");
            duration = duration2;
        }
        catch (DateTimeParseException exception) {
            Duration duration3;
            try {
                duration3 = UtilsKt.toDuration(string);
            }
            catch (SourceException _) {
                throw (Throwable)exception;
            }
            duration = duration3;
        }
        return duration;
    }

    private DurationDeserializer() {
        super(Duration.class);
    }

    static {
        DurationDeserializer durationDeserializer;
        INSTANCE = durationDeserializer = new DurationDeserializer();
    }
}

