/*
 * Decompiled with CFR 0.152.
 */
package com.uchuhimo.konf.source.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.uchuhimo.konf.source.Provider;
import com.uchuhimo.konf.source.Source;
import com.uchuhimo.konf.source.json.JsonSource;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0000H\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/uchuhimo/konf/source/json/JsonProvider;", "Lcom/uchuhimo/konf/source/Provider;", "()V", "get", "inputStream", "Lcom/uchuhimo/konf/source/Source;", "Ljava/io/InputStream;", "reader", "Ljava/io/Reader;", "konf-core"})
public final class JsonProvider
implements Provider {
    @NotNull
    public static final JsonProvider INSTANCE;

    @Override
    @NotNull
    public Source reader(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        JsonNode jsonNode = new ObjectMapper().readTree(reader);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"ObjectMapper().readTree(reader)");
        return new JsonSource(jsonNode);
    }

    @Override
    @NotNull
    public Source inputStream(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        JsonNode jsonNode = new ObjectMapper().readTree(inputStream);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"ObjectMapper().readTree(inputStream)");
        return new JsonSource(jsonNode);
    }

    @JvmStatic
    @NotNull
    public static final JsonProvider get() {
        return INSTANCE;
    }

    private JsonProvider() {
    }

    static {
        JsonProvider jsonProvider;
        INSTANCE = jsonProvider = new JsonProvider();
    }

    @Override
    @NotNull
    public Source file(@NotNull File file2, boolean optional2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return Provider.DefaultImpls.file((Provider)this, file2, optional2);
    }

    @Override
    @NotNull
    public Source file(@NotNull String file2, boolean optional2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return Provider.DefaultImpls.file((Provider)this, file2, optional2);
    }

    @Override
    @NotNull
    public Source string(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return Provider.DefaultImpls.string(this, content);
    }

    @Override
    @NotNull
    public Source bytes(@NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return Provider.DefaultImpls.bytes(this, content);
    }

    @Override
    @NotNull
    public Source bytes(@NotNull byte[] content, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return Provider.DefaultImpls.bytes(this, content, offset, length);
    }

    @Override
    @NotNull
    public Source url(@NotNull URL url2, boolean optional2) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        return Provider.DefaultImpls.url((Provider)this, url2, optional2);
    }

    @Override
    @NotNull
    public Source url(@NotNull String url2, boolean optional2) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        return Provider.DefaultImpls.url((Provider)this, url2, optional2);
    }

    @Override
    @NotNull
    public Source resource(@NotNull String resource2, boolean optional2) {
        Intrinsics.checkNotNullParameter((Object)resource2, (String)"resource");
        return Provider.DefaultImpls.resource(this, resource2, optional2);
    }

    @Override
    @NotNull
    public Provider map(@NotNull Function1<? super Source, ? extends Source> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        return Provider.DefaultImpls.map(this, transform);
    }
}

