/*
 * Decompiled with CFR 0.152.
 */
package com.moandjiezana.toml;

import com.moandjiezana.toml.ArrayValueWriter;
import com.moandjiezana.toml.NewMapValueWriter;
import com.moandjiezana.toml.Toml4jValueWriters;
import com.moandjiezana.toml.ValueWriter;
import com.moandjiezana.toml.WriterContext;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/moandjiezana/toml/NewArrayValueWriter;", "Lcom/moandjiezana/toml/ArrayValueWriter;", "()V", "canWrite", "", "value", "", "write", "", "o", "context", "Lcom/moandjiezana/toml/WriterContext;", "konf-toml"})
public final class NewArrayValueWriter
extends ArrayValueWriter {
    @NotNull
    public static final NewArrayValueWriter INSTANCE;

    public boolean canWrite(@Nullable Object value) {
        return ArrayValueWriter.isArrayish((Object)value);
    }

    public void write(@NotNull Object o, @NotNull WriterContext context) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Collection values = this.normalize(o);
        context.write('[');
        context.writeArrayDelimiterPadding();
        boolean first = true;
        ValueWriter firstWriter = null;
        for (Object value : values) {
            ValueWriter writer;
            if (first) {
                Object e = value;
                Intrinsics.checkNotNull(e);
                firstWriter = Toml4jValueWriters.INSTANCE.findWriterFor(e);
                first = false;
            } else {
                Object e = value;
                Intrinsics.checkNotNull(e);
                writer = Toml4jValueWriters.INSTANCE.findWriterFor(e);
                if (writer != firstWriter) {
                    throw (Throwable)new IllegalStateException(context.getContextPath() + ": cannot write a heterogeneous array; first element was of type " + firstWriter + " but found " + writer);
                }
                context.write(", ");
            }
            writer = Toml4jValueWriters.INSTANCE.findWriterFor(value);
            boolean isNestedOldValue = NewMapValueWriter.INSTANCE.isNested();
            if (Intrinsics.areEqual((Object)writer, (Object)NewMapValueWriter.INSTANCE)) {
                NewMapValueWriter.INSTANCE.setNested(true);
            }
            writer.write(value, context);
            if (!Intrinsics.areEqual((Object)writer, (Object)NewMapValueWriter.INSTANCE)) continue;
            NewMapValueWriter.INSTANCE.setNested(isNestedOldValue);
        }
        context.writeArrayDelimiterPadding();
        context.write(']');
    }

    private NewArrayValueWriter() {
    }

    static {
        NewArrayValueWriter newArrayValueWriter;
        INSTANCE = newArrayValueWriter = new NewArrayValueWriter();
    }
}

