/*
 * Decompiled with CFR 0.152.
 */
package com.uchuhimo.konf.source.xml;

import com.uchuhimo.konf.source.Provider;
import com.uchuhimo.konf.source.RegisterExtension;
import com.uchuhimo.konf.source.Source;
import com.uchuhimo.konf.source.base.FlatSource;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.jetbrains.annotations.NotNull;

@RegisterExtension(value={"xml"})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0000H\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/uchuhimo/konf/source/xml/XmlProvider;", "Lcom/uchuhimo/konf/source/Provider;", "()V", "get", "inputStream", "Lcom/uchuhimo/konf/source/Source;", "Ljava/io/InputStream;", "reader", "Ljava/io/Reader;", "toMap", "", "", "Lorg/dom4j/Document;", "konf-xml"})
public final class XmlProvider
implements Provider {
    @NotNull
    public static final XmlProvider INSTANCE;

    private final Map<String, String> toMap(Document $this$toMap) {
        Element rootElement = $this$toMap.getRootElement();
        List propertyNodes = rootElement.selectNodes("/configuration/property");
        boolean bl = false;
        Map map = new LinkedHashMap();
        boolean bl2 = false;
        boolean bl3 = false;
        Map $this$apply = map;
        boolean bl4 = false;
        for (Node property : propertyNodes) {
            Node node = property.selectSingleNode("name");
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"property.selectSingleNode(\"name\")");
            String string = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"property.selectSingleNode(\"name\").text");
            Node node2 = property.selectSingleNode("value");
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"property.selectSingleNode(\"value\")");
            String string2 = node2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"property.selectSingleNode(\"value\").text");
            $this$apply.put(string, string2);
        }
        return map;
    }

    @NotNull
    public Source reader(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Document document = new SAXReader().read(reader);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"SAXReader().read(reader)");
        return (Source)new FlatSource(this.toMap(document), "XML", null, false, 12, null);
    }

    @NotNull
    public Source inputStream(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Document document = new SAXReader().read(inputStream);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"SAXReader().read(inputStream)");
        return (Source)new FlatSource(this.toMap(document), "XML", null, false, 12, null);
    }

    @JvmStatic
    @NotNull
    public static final XmlProvider get() {
        return INSTANCE;
    }

    private XmlProvider() {
    }

    static {
        XmlProvider xmlProvider;
        INSTANCE = xmlProvider = new XmlProvider();
    }

    @NotNull
    public Source bytes(@NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return Provider.DefaultImpls.bytes((Provider)this, (byte[])content);
    }

    @NotNull
    public Source bytes(@NotNull byte[] content, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return Provider.DefaultImpls.bytes((Provider)this, (byte[])content, (int)offset, (int)length);
    }

    @NotNull
    public Source file(@NotNull File file, boolean optional) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Provider.DefaultImpls.file((Provider)this, (File)file, (boolean)optional);
    }

    @NotNull
    public Source file(@NotNull String file, boolean optional) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Provider.DefaultImpls.file((Provider)this, (String)file, (boolean)optional);
    }

    @NotNull
    public Provider map(@NotNull Function1<? super Source, ? extends Source> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        return Provider.DefaultImpls.map((Provider)this, transform);
    }

    @NotNull
    public Source resource(@NotNull String resource, boolean optional) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        return Provider.DefaultImpls.resource((Provider)this, (String)resource, (boolean)optional);
    }

    @NotNull
    public Source string(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return Provider.DefaultImpls.string((Provider)this, (String)content);
    }

    @NotNull
    public Source url(@NotNull URL url, boolean optional) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return Provider.DefaultImpls.url((Provider)this, (URL)url, (boolean)optional);
    }

    @NotNull
    public Source url(@NotNull String url, boolean optional) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return Provider.DefaultImpls.url((Provider)this, (String)url, (boolean)optional);
    }
}

