/*
 * Decompiled with CFR 0.152.
 */
package com.udojava.evalex;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Expression {
    public static final BigDecimal PI = new BigDecimal("3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679");
    public static final BigDecimal e = new BigDecimal("2.71828182845904523536028747135266249775724709369995957496696762772407663");
    private MathContext mc = null;
    private String firstVarChars = "_";
    private String varChars = "_";
    private final String originalExpression;
    private String expression = null;
    private List<Token> rpn = null;
    private Map<String, Operator> operators = new TreeMap<String, Operator>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, LazyFunction> functions = new TreeMap<String, LazyFunction>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, BigDecimal> variables = new TreeMap<String, BigDecimal>(String.CASE_INSENSITIVE_ORDER);
    private static final char decimalSeparator = '.';
    private static final char minusSign = '-';
    private static final LazyNumber PARAMS_START = new LazyNumber(){

        public BigDecimal eval() {
            return null;
        }

        public String getString() {
            return null;
        }
    };

    public Expression(String expression) {
        this(expression, MathContext.DECIMAL32);
    }

    public Expression(String expression, MathContext defaultMathContext) {
        this.mc = defaultMathContext;
        this.expression = expression;
        this.originalExpression = expression;
        this.addOperator(new Operator("+", 20, true){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                Expression.this.assertNotNull(v1, v2);
                return v1.add(v2, Expression.this.mc);
            }
        });
        this.addOperator(new Operator("-", 20, true){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                Expression.this.assertNotNull(v1, v2);
                return v1.subtract(v2, Expression.this.mc);
            }
        });
        this.addOperator(new Operator("*", 30, true){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                Expression.this.assertNotNull(v1, v2);
                return v1.multiply(v2, Expression.this.mc);
            }
        });
        this.addOperator(new Operator("/", 30, true){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                Expression.this.assertNotNull(v1, v2);
                return v1.divide(v2, Expression.this.mc);
            }
        });
        this.addOperator(new Operator("%", 30, true){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                Expression.this.assertNotNull(v1, v2);
                return v1.remainder(v2, Expression.this.mc);
            }
        });
        this.addOperator(new Operator("^", 40, false){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                Expression.this.assertNotNull(v1, v2);
                int signOf2 = v2.signum();
                double dn1 = v1.doubleValue();
                v2 = v2.multiply(new BigDecimal(signOf2));
                BigDecimal remainderOf2 = v2.remainder(BigDecimal.ONE);
                BigDecimal n2IntPart = v2.subtract(remainderOf2);
                BigDecimal intPow = v1.pow(n2IntPart.intValueExact(), Expression.this.mc);
                BigDecimal doublePow = new BigDecimal(Math.pow(dn1, remainderOf2.doubleValue()));
                BigDecimal result = intPow.multiply(doublePow, Expression.this.mc);
                if (signOf2 == -1) {
                    result = BigDecimal.ONE.divide(result, Expression.this.mc.getPrecision(), RoundingMode.HALF_UP);
                }
                return result;
            }
        });
        this.addOperator(new Operator("&&", 4, false){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                Expression.this.assertNotNull(v1, v2);
                boolean b1 = !v1.equals(BigDecimal.ZERO);
                boolean b2 = !v2.equals(BigDecimal.ZERO);
                return b1 && b2 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator("||", 2, false){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                Expression.this.assertNotNull(v1, v2);
                boolean b1 = !v1.equals(BigDecimal.ZERO);
                boolean b2 = !v2.equals(BigDecimal.ZERO);
                return b1 || b2 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator(">", 10, false){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                Expression.this.assertNotNull(v1, v2);
                return v1.compareTo(v2) == 1 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator(">=", 10, false){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                Expression.this.assertNotNull(v1, v2);
                return v1.compareTo(v2) >= 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator("<", 10, false){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                Expression.this.assertNotNull(v1, v2);
                return v1.compareTo(v2) == -1 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator("<=", 10, false){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                Expression.this.assertNotNull(v1, v2);
                return v1.compareTo(v2) <= 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator("=", 7, false){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                if (v1 == v2) {
                    return BigDecimal.ONE;
                }
                if (v1 == null || v2 == null) {
                    return BigDecimal.ZERO;
                }
                return v1.compareTo(v2) == 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator("==", 7, false){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return ((Operator)Expression.this.operators.get("=")).eval(v1, v2);
            }
        });
        this.addOperator(new Operator("!=", 7, false){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                if (v1 == v2) {
                    return BigDecimal.ZERO;
                }
                if (v1 == null || v2 == null) {
                    return BigDecimal.ONE;
                }
                return v1.compareTo(v2) != 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator("<>", 7, false){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                Expression.this.assertNotNull(v1, v2);
                return ((Operator)Expression.this.operators.get("!=")).eval(v1, v2);
            }
        });
        this.addOperator(new UnaryOperator("-", 60, false){

            public BigDecimal evalUnary(BigDecimal v1) {
                return v1.multiply(new BigDecimal(-1));
            }
        });
        this.addOperator(new UnaryOperator("+", 60, false){

            public BigDecimal evalUnary(BigDecimal v1) {
                return v1.multiply(BigDecimal.ONE);
            }
        });
        this.addFunction(new Function("NOT", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                boolean zero = parameters.get(0).compareTo(BigDecimal.ZERO) == 0;
                return zero ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addLazyFunction(new LazyFunction("IF", 3){

            @Override
            public LazyNumber lazyEval(List<LazyNumber> lazyParams) {
                BigDecimal result = lazyParams.get(0).eval();
                Expression.this.assertNotNull(result);
                boolean isTrue = !result.equals(BigDecimal.ZERO);
                return isTrue ? lazyParams.get(1) : lazyParams.get(2);
            }
        });
        this.addFunction(new Function("RANDOM", 0){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.random();
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("SIN", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.sin(Math.toRadians(parameters.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("COS", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.cos(Math.toRadians(parameters.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("TAN", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.tan(Math.toRadians(parameters.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("ASIN", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.toDegrees(Math.asin(parameters.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("ACOS", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.toDegrees(Math.acos(parameters.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("ATAN", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.toDegrees(Math.atan(parameters.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("SINH", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.sinh(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("COSH", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.cosh(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("TANH", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.tanh(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("RAD", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.toRadians(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("DEG", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.toDegrees(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("MAX", -1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                if (parameters.size() == 0) {
                    throw new ExpressionException("MAX requires at least one parameter");
                }
                BigDecimal max = null;
                for (BigDecimal parameter : parameters) {
                    Expression.this.assertNotNull(parameter);
                    if (max != null && parameter.compareTo(max) <= 0) continue;
                    max = parameter;
                }
                return max;
            }
        });
        this.addFunction(new Function("MIN", -1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                if (parameters.size() == 0) {
                    throw new ExpressionException("MIN requires at least one parameter");
                }
                BigDecimal min = null;
                for (BigDecimal parameter : parameters) {
                    Expression.this.assertNotNull(parameter);
                    if (min != null && parameter.compareTo(min) >= 0) continue;
                    min = parameter;
                }
                return min;
            }
        });
        this.addFunction(new Function("ABS", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                return parameters.get(0).abs(Expression.this.mc);
            }
        });
        this.addFunction(new Function("LOG", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.log(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("LOG10", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.log10(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("ROUND", 2){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0), parameters.get(1));
                BigDecimal toRound = parameters.get(0);
                int precision = parameters.get(1).intValue();
                return toRound.setScale(precision, Expression.this.mc.getRoundingMode());
            }
        });
        this.addFunction(new Function("FLOOR", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                BigDecimal toRound = parameters.get(0);
                return toRound.setScale(0, RoundingMode.FLOOR);
            }
        });
        this.addFunction(new Function("CEILING", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                BigDecimal toRound = parameters.get(0);
                return toRound.setScale(0, RoundingMode.CEILING);
            }
        });
        this.addFunction(new Function("SQRT", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                BigInteger ixPrev;
                Expression.this.assertNotNull(parameters.get(0));
                BigDecimal x = parameters.get(0);
                if (x.compareTo(BigDecimal.ZERO) == 0) {
                    return new BigDecimal(0);
                }
                if (x.signum() < 0) {
                    throw new ExpressionException("Argument to SQRT() function must not be negative");
                }
                BigInteger n = x.movePointRight(Expression.this.mc.getPrecision() << 1).toBigInteger();
                int bits = n.bitLength() + 1 >> 1;
                BigInteger ix = n.shiftRight(bits);
                do {
                    ixPrev = ix;
                    ix = ix.add(n.divide(ix)).shiftRight(1);
                    Thread.yield();
                } while (ix.compareTo(ixPrev) != 0);
                return new BigDecimal(ix, Expression.this.mc.getPrecision());
            }
        });
        this.variables.put("e", e);
        this.variables.put("PI", PI);
        this.variables.put("NULL", null);
        this.variables.put("TRUE", BigDecimal.ONE);
        this.variables.put("FALSE", BigDecimal.ZERO);
    }

    private void assertNotNull(BigDecimal v1) {
        if (v1 == null) {
            throw new ArithmeticException("Operand may not be null");
        }
    }

    private void assertNotNull(BigDecimal v1, BigDecimal v2) {
        if (v1 == null) {
            throw new ArithmeticException("First operand may not be null");
        }
        if (v2 == null) {
            throw new ArithmeticException("Second operand may not be null");
        }
    }

    private boolean isNumber(String st) {
        if (st.charAt(0) == '-' && st.length() == 1) {
            return false;
        }
        if (st.charAt(0) == '+' && st.length() == 1) {
            return false;
        }
        if (st.charAt(0) == 'e' || st.charAt(0) == 'E') {
            return false;
        }
        for (char ch : st.toCharArray()) {
            if (Character.isDigit(ch) || ch == '-' || ch == '.' || ch == 'e' || ch == 'E' || ch == '+') continue;
            return false;
        }
        return true;
    }

    private List<Token> shuntingYard(String expression) {
        ArrayList<Token> outputQueue = new ArrayList<Token>();
        Stack<Token> stack = new Stack<Token>();
        Tokenizer tokenizer = new Tokenizer(expression);
        Token lastFunction = null;
        Token previousToken = null;
        while (tokenizer.hasNext()) {
            Token token = tokenizer.next();
            switch (token.type) {
                case STRINGPARAM: {
                    stack.push(token);
                    break;
                }
                case LITERAL: 
                case HEX_LITERAL: {
                    outputQueue.add(token);
                    break;
                }
                case VARIABLE: {
                    outputQueue.add(token);
                    break;
                }
                case FUNCTION: {
                    stack.push(token);
                    lastFunction = token;
                    break;
                }
                case COMMA: {
                    if (previousToken != null && previousToken.type == TokenType.OPERATOR) {
                        throw new ExpressionException("Missing parameter(s) for operator " + previousToken + " at character position " + previousToken.pos);
                    }
                    while (!stack.isEmpty() && ((Token)stack.peek()).type != TokenType.OPEN_PAREN) {
                        outputQueue.add((Token)stack.pop());
                    }
                    if (!stack.isEmpty()) break;
                    throw new ExpressionException("Parse error for function '" + lastFunction + "'");
                }
                case OPERATOR: {
                    if (previousToken != null && (previousToken.type == TokenType.COMMA || previousToken.type == TokenType.OPEN_PAREN)) {
                        throw new ExpressionException("Missing parameter(s) for operator " + token + " at character position " + token.pos);
                    }
                    Operator o1 = this.operators.get(token.surface);
                    if (o1 == null) {
                        throw new ExpressionException("Unknown operator '" + token + "' at position " + (token.pos + 1));
                    }
                    this.shuntOperators(outputQueue, stack, o1);
                    stack.push(token);
                    break;
                }
                case UNARY_OPERATOR: {
                    if (previousToken != null && previousToken.type != TokenType.OPERATOR && previousToken.type != TokenType.COMMA && previousToken.type != TokenType.OPEN_PAREN) {
                        throw new ExpressionException("Invalid position for unary operator " + token + " at character position " + token.pos);
                    }
                    Operator o1 = this.operators.get(token.surface);
                    if (o1 == null) {
                        throw new ExpressionException("Unknown unary operator '" + token.surface.substring(0, token.surface.length() - 1) + "' at position " + (token.pos + 1));
                    }
                    this.shuntOperators(outputQueue, stack, o1);
                    stack.push(token);
                    break;
                }
                case OPEN_PAREN: {
                    if (previousToken != null) {
                        if (previousToken.type == TokenType.LITERAL) {
                            throw new ExpressionException("Missing operator at character position " + (token.pos + 1));
                        }
                        if (previousToken.type == TokenType.FUNCTION) {
                            outputQueue.add(token);
                        }
                    }
                    stack.push(token);
                    break;
                }
                case CLOSE_PAREN: {
                    if (previousToken != null && previousToken.type == TokenType.OPERATOR) {
                        throw new ExpressionException("Missing parameter(s) for operator " + previousToken + " at character position " + previousToken.pos);
                    }
                    while (!stack.isEmpty() && ((Token)stack.peek()).type != TokenType.OPEN_PAREN) {
                        outputQueue.add((Token)stack.pop());
                    }
                    if (stack.isEmpty()) {
                        throw new ExpressionException("Mismatched parentheses");
                    }
                    stack.pop();
                    if (stack.isEmpty() || stack.peek().type != TokenType.FUNCTION) break;
                    outputQueue.add(stack.pop());
                }
            }
            previousToken = token;
        }
        while (!stack.isEmpty()) {
            Token element = (Token)stack.pop();
            if (element.type == TokenType.OPEN_PAREN || element.type == TokenType.CLOSE_PAREN) {
                throw new ExpressionException("Mismatched parentheses");
            }
            outputQueue.add(element);
        }
        return outputQueue;
    }

    private void shuntOperators(List<Token> outputQueue, Stack<Token> stack, Operator o1) {
        Token nextToken;
        Token token = nextToken = stack.isEmpty() ? null : stack.peek();
        while (nextToken != null && (nextToken.type == TokenType.OPERATOR || nextToken.type == TokenType.UNARY_OPERATOR) && (o1.isLeftAssoc() && o1.getPrecedence() <= this.operators.get(nextToken.surface).getPrecedence() || o1.getPrecedence() < this.operators.get(nextToken.surface).getPrecedence())) {
            outputQueue.add(stack.pop());
            nextToken = stack.isEmpty() ? null : stack.peek();
        }
    }

    public BigDecimal eval() {
        Stack<LazyNumber> stack = new Stack<LazyNumber>();
        for (final Token token : this.getRPN()) {
            switch (token.type) {
                case UNARY_OPERATOR: {
                    final LazyNumber value = (LazyNumber)stack.pop();
                    LazyNumber result = new LazyNumber(){

                        public BigDecimal eval() {
                            return ((Operator)Expression.this.operators.get(token.surface)).eval(value.eval(), null);
                        }

                        public String getString() {
                            return String.valueOf(((Operator)Expression.this.operators.get(token.surface)).eval(value.eval(), null));
                        }
                    };
                    stack.push(result);
                    break;
                }
                case OPERATOR: {
                    final LazyNumber v1 = (LazyNumber)stack.pop();
                    final LazyNumber v2 = (LazyNumber)stack.pop();
                    LazyNumber result = new LazyNumber(){

                        public BigDecimal eval() {
                            return ((Operator)Expression.this.operators.get(token.surface)).eval(v2.eval(), v1.eval());
                        }

                        public String getString() {
                            return String.valueOf(((Operator)Expression.this.operators.get(token.surface)).eval(v2.eval(), v1.eval()));
                        }
                    };
                    stack.push(result);
                    break;
                }
                case VARIABLE: {
                    if (!this.variables.containsKey(token.surface)) {
                        throw new ExpressionException("Unknown operator or function: " + token);
                    }
                    stack.push(new LazyNumber(){

                        public BigDecimal eval() {
                            BigDecimal value = (BigDecimal)Expression.this.variables.get(token.surface);
                            return value == null ? null : value.round(Expression.this.mc);
                        }

                        public String getString() {
                            return token.surface;
                        }
                    });
                    break;
                }
                case FUNCTION: {
                    LazyFunction f = this.functions.get(token.surface.toUpperCase(Locale.ROOT));
                    ArrayList<LazyNumber> p = new ArrayList<LazyNumber>(!f.numParamsVaries() ? f.getNumParams() : 0);
                    while (!stack.isEmpty() && stack.peek() != PARAMS_START) {
                        p.add(0, (LazyNumber)stack.pop());
                    }
                    if (stack.peek() == PARAMS_START) {
                        stack.pop();
                    }
                    LazyNumber fResult = f.lazyEval(p);
                    stack.push(fResult);
                    break;
                }
                case OPEN_PAREN: {
                    stack.push(PARAMS_START);
                    break;
                }
                case LITERAL: {
                    stack.push(new LazyNumber(){

                        public BigDecimal eval() {
                            if (token.surface.equalsIgnoreCase("NULL")) {
                                return null;
                            }
                            return new BigDecimal(token.surface, Expression.this.mc);
                        }

                        public String getString() {
                            return String.valueOf(new BigDecimal(token.surface, Expression.this.mc));
                        }
                    });
                    break;
                }
                case STRINGPARAM: {
                    stack.push(new LazyNumber(){

                        public BigDecimal eval() {
                            return null;
                        }

                        public String getString() {
                            return token.surface;
                        }
                    });
                    break;
                }
                case HEX_LITERAL: {
                    stack.push(new LazyNumber(){

                        public BigDecimal eval() {
                            return new BigDecimal(new BigInteger(token.surface.substring(2), 16), Expression.this.mc);
                        }

                        public String getString() {
                            return new BigInteger(token.surface.substring(2), 16).toString();
                        }
                    });
                }
            }
        }
        BigDecimal result = ((LazyNumber)stack.pop()).eval();
        return result == null ? null : result.stripTrailingZeros();
    }

    public Expression setPrecision(int precision) {
        this.mc = new MathContext(precision);
        return this;
    }

    public Expression setRoundingMode(RoundingMode roundingMode) {
        this.mc = new MathContext(this.mc.getPrecision(), roundingMode);
        return this;
    }

    public Expression setFirstVariableCharacters(String chars) {
        this.firstVarChars = chars;
        return this;
    }

    public Expression setVariableCharacters(String chars) {
        this.varChars = chars;
        return this;
    }

    public Operator addOperator(Operator operator) {
        String key = operator.getOper();
        if (operator instanceof UnaryOperator) {
            key = key + "u";
        }
        return this.operators.put(key, operator);
    }

    public Function addFunction(Function function) {
        return (Function)this.functions.put(function.getName(), function);
    }

    public LazyFunction addLazyFunction(LazyFunction function) {
        return this.functions.put(function.getName(), function);
    }

    public Expression setVariable(String variable, BigDecimal value) {
        this.variables.put(variable, value);
        return this;
    }

    public Expression setVariable(String variable, String value) {
        if (this.isNumber(value)) {
            this.variables.put(variable, new BigDecimal(value));
        } else if (value.equalsIgnoreCase("null")) {
            this.variables.put(variable, null);
        } else {
            this.expression = this.expression.replaceAll("(?i)\\b" + variable + "\\b", "(" + value + ")");
            this.rpn = null;
        }
        return this;
    }

    public Expression with(String variable, BigDecimal value) {
        return this.setVariable(variable, value);
    }

    public Expression and(String variable, String value) {
        return this.setVariable(variable, value);
    }

    public Expression and(String variable, BigDecimal value) {
        return this.setVariable(variable, value);
    }

    public Expression with(String variable, String value) {
        return this.setVariable(variable, value);
    }

    public Iterator<Token> getExpressionTokenizer() {
        String expression = this.expression;
        return new Tokenizer(expression);
    }

    private List<Token> getRPN() {
        if (this.rpn == null) {
            this.rpn = this.shuntingYard(this.expression);
            this.validate(this.rpn);
        }
        return this.rpn;
    }

    private void validate(List<Token> rpn) {
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(0);
        block6: for (Token token : rpn) {
            switch (token.type) {
                case UNARY_OPERATOR: {
                    if ((Integer)stack.peek() >= 1) continue block6;
                    throw new ExpressionException("Missing parameter(s) for operator " + token);
                }
                case OPERATOR: {
                    if ((Integer)stack.peek() < 2) {
                        throw new ExpressionException("Missing parameter(s) for operator " + token);
                    }
                    stack.set(stack.size() - 1, (Integer)stack.peek() - 2 + 1);
                    continue block6;
                }
                case FUNCTION: {
                    LazyFunction f = this.functions.get(token.surface.toUpperCase(Locale.ROOT));
                    if (f == null) {
                        throw new ExpressionException("Unknown function '" + token + "' at position " + (token.pos + 1));
                    }
                    int numParams = (Integer)stack.pop();
                    if (!f.numParamsVaries() && numParams != f.getNumParams()) {
                        throw new ExpressionException("Function " + token + " expected " + f.getNumParams() + " parameters, got " + numParams);
                    }
                    if (stack.size() <= 0) {
                        throw new ExpressionException("Too many function calls, maximum scope exceeded");
                    }
                    stack.set(stack.size() - 1, (Integer)stack.peek() + 1);
                    continue block6;
                }
                case OPEN_PAREN: {
                    stack.push(0);
                    continue block6;
                }
            }
            stack.set(stack.size() - 1, (Integer)stack.peek() + 1);
        }
        if (stack.size() > 1) {
            throw new ExpressionException("Too many unhandled function parameter lists");
        }
        if ((Integer)stack.peek() > 1) {
            throw new ExpressionException("Too many numbers or variables");
        }
        if ((Integer)stack.peek() < 1) {
            throw new ExpressionException("Empty expression");
        }
    }

    public String toRPN() {
        StringBuilder result = new StringBuilder();
        for (Token t : this.getRPN()) {
            if (result.length() != 0) {
                result.append(" ");
            }
            result.append(t.toString());
        }
        return result.toString();
    }

    public Set<String> getDeclaredVariables() {
        return Collections.unmodifiableSet(this.variables.keySet());
    }

    public Set<String> getDeclaredOperators() {
        return Collections.unmodifiableSet(this.operators.keySet());
    }

    public Set<String> getDeclaredFunctions() {
        return Collections.unmodifiableSet(this.functions.keySet());
    }

    public String getExpression() {
        return this.expression;
    }

    public List<String> getUsedVariables() {
        ArrayList<String> result = new ArrayList<String>();
        Tokenizer tokenizer = new Tokenizer(this.expression);
        while (tokenizer.hasNext()) {
            Token nextToken = tokenizer.next();
            String token = nextToken.toString();
            if (nextToken.type != TokenType.VARIABLE || token.equals("PI") || token.equals("e") || token.equals("TRUE") || token.equals("FALSE")) continue;
            result.add(token);
        }
        return result;
    }

    public String getOriginalExpression() {
        return this.originalExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Expression that = (Expression)o;
        if (this.expression == null) {
            return that.expression == null;
        }
        return this.expression.equals(that.expression);
    }

    public int hashCode() {
        return this.expression == null ? 0 : this.expression.hashCode();
    }

    public String toString() {
        return this.expression;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Tokenizer
    implements Iterator<Token> {
        private int pos = 0;
        private String input;
        private Token previousToken;

        public Tokenizer(String input) {
            this.input = input.trim();
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.input.length();
        }

        private char peekNextChar() {
            if (this.pos < this.input.length() - 1) {
                return this.input.charAt(this.pos + 1);
            }
            return '\u0000';
        }

        private boolean isHexDigit(char ch) {
            return ch == 'x' || ch == 'X' || ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F';
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Token next() {
            Token token = new Token();
            if (this.pos >= this.input.length()) {
                this.previousToken = null;
                return null;
            }
            char ch = this.input.charAt(this.pos);
            while (Character.isWhitespace(ch) && this.pos < this.input.length()) {
                ch = this.input.charAt(++this.pos);
            }
            token.pos = this.pos++;
            boolean isHex = false;
            if (Character.isDigit(ch)) {
                if (ch == '0' && (this.peekNextChar() == 'x' || this.peekNextChar() == 'X')) {
                    isHex = true;
                }
                while (isHex && this.isHexDigit(ch) || (Character.isDigit(ch) || ch == '.' || ch == 'e' || ch == 'E' || ch == '-' && token.length() > 0 && ('e' == token.charAt(token.length() - 1) || 'E' == token.charAt(token.length() - 1)) || ch == '+' && token.length() > 0 && ('e' == token.charAt(token.length() - 1) || 'E' == token.charAt(token.length() - 1))) && this.pos < this.input.length()) {
                    token.append(this.input.charAt(this.pos++));
                    ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
                }
                token.type = isHex ? TokenType.HEX_LITERAL : TokenType.LITERAL;
            } else if (ch == '\"') {
                if (this.previousToken.type == TokenType.STRINGPARAM) return this.next();
                ch = this.input.charAt(this.pos);
                while (ch != '\"') {
                    token.append(this.input.charAt(this.pos++));
                    ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
                }
                token.type = TokenType.STRINGPARAM;
            } else if (Character.isLetter(ch) || Expression.this.firstVarChars.indexOf(ch) >= 0) {
                while ((Character.isLetter(ch) || Character.isDigit(ch) || Expression.this.varChars.indexOf(ch) >= 0 || token.length() == 0 && Expression.this.firstVarChars.indexOf(ch) >= 0) && this.pos < this.input.length()) {
                    token.append(this.input.charAt(this.pos++));
                    ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
                }
                token.type = ch == '(' ? TokenType.FUNCTION : TokenType.VARIABLE;
            } else if (ch == '(' || ch == ')' || ch == ',') {
                token.type = ch == '(' ? TokenType.OPEN_PAREN : (ch == ')' ? TokenType.CLOSE_PAREN : TokenType.COMMA);
                token.append(ch);
                ++this.pos;
            } else {
                String greedyMatch = "";
                int initialPos = this.pos;
                ch = this.input.charAt(this.pos);
                int validOperatorSeenUntil = -1;
                while (!(Character.isLetter(ch) || Character.isDigit(ch) || Expression.this.firstVarChars.indexOf(ch) >= 0 || Character.isWhitespace(ch) || ch == '(' || ch == ')' || ch == ',' || this.pos >= this.input.length())) {
                    greedyMatch = greedyMatch + ch;
                    ++this.pos;
                    if (Expression.this.operators.containsKey(greedyMatch)) {
                        validOperatorSeenUntil = this.pos;
                    }
                    ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
                }
                if (validOperatorSeenUntil != -1) {
                    token.append(this.input.substring(initialPos, validOperatorSeenUntil));
                    this.pos = validOperatorSeenUntil;
                } else {
                    token.append(greedyMatch);
                }
                if (this.previousToken == null || this.previousToken.type == TokenType.OPERATOR || this.previousToken.type == TokenType.OPEN_PAREN || this.previousToken.type == TokenType.COMMA) {
                    token.surface = token.surface + "u";
                    token.type = TokenType.UNARY_OPERATOR;
                } else {
                    token.type = TokenType.OPERATOR;
                }
            }
            this.previousToken = token;
            return this.previousToken;
        }

        @Override
        public void remove() {
            throw new ExpressionException("remove() not supported");
        }
    }

    class Token {
        public String surface = "";
        public TokenType type;
        public int pos;

        Token() {
        }

        public void append(char c) {
            this.surface = this.surface + c;
        }

        public void append(String s) {
            this.surface = this.surface + s;
        }

        public char charAt(int pos) {
            return this.surface.charAt(pos);
        }

        public int length() {
            return this.surface.length();
        }

        public String toString() {
            return this.surface;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TokenType {
        VARIABLE,
        FUNCTION,
        LITERAL,
        OPERATOR,
        UNARY_OPERATOR,
        OPEN_PAREN,
        COMMA,
        CLOSE_PAREN,
        HEX_LITERAL,
        STRINGPARAM;

    }

    public abstract class UnaryOperator
    extends Operator {
        public UnaryOperator(String oper, int precedence, boolean leftAssoc) {
            super(oper, precedence, leftAssoc);
        }

        public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
            if (v2 != null) {
                throw new ExpressionException("Did not expect a second parameter for unary operator");
            }
            return this.evalUnary(v1);
        }

        public abstract BigDecimal evalUnary(BigDecimal var1);
    }

    public abstract class Operator {
        private String oper;
        private int precedence;
        private boolean leftAssoc;

        public Operator(String oper, int precedence, boolean leftAssoc) {
            this.oper = oper;
            this.precedence = precedence;
            this.leftAssoc = leftAssoc;
        }

        public String getOper() {
            return this.oper;
        }

        public int getPrecedence() {
            return this.precedence;
        }

        public boolean isLeftAssoc() {
            return this.leftAssoc;
        }

        public abstract BigDecimal eval(BigDecimal var1, BigDecimal var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Function
    extends LazyFunction {
        public Function(String name, int numParams) {
            super(name, numParams);
        }

        @Override
        public LazyNumber lazyEval(List<LazyNumber> lazyParams) {
            final ArrayList<BigDecimal> params = new ArrayList<BigDecimal>();
            for (LazyNumber lazyParam : lazyParams) {
                params.add(lazyParam.eval());
            }
            return new LazyNumber(){

                public BigDecimal eval() {
                    return Function.this.eval(params);
                }

                public String getString() {
                    return String.valueOf(Function.this.eval(params));
                }
            };
        }

        public abstract BigDecimal eval(List<BigDecimal> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class LazyFunction {
        private String name;
        private int numParams;

        public LazyFunction(String name, int numParams) {
            this.name = name.toUpperCase(Locale.ROOT);
            this.numParams = numParams;
        }

        public String getName() {
            return this.name;
        }

        public int getNumParams() {
            return this.numParams;
        }

        public boolean numParamsVaries() {
            return this.numParams < 0;
        }

        public abstract LazyNumber lazyEval(List<LazyNumber> var1);
    }

    public static interface LazyNumber {
        public BigDecimal eval();

        public String getString();
    }

    public static class ExpressionException
    extends RuntimeException {
        private static final long serialVersionUID = 1118142866870779047L;

        public ExpressionException(String message) {
            super(message);
        }
    }
}

