/*
 * Decompiled with CFR 0.152.
 */
package com.udojava.evalex;

import com.udojava.evalex.AbstractFunction;
import com.udojava.evalex.AbstractLazyFunction;
import com.udojava.evalex.AbstractOperator;
import com.udojava.evalex.AbstractUnaryOperator;
import com.udojava.evalex.LazyIfNumber;
import com.udojava.evalex.LazyOperator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;

public class Expression {
    public static final int OPERATOR_PRECEDENCE_UNARY = 60;
    public static final int OPERATOR_PRECEDENCE_EQUALITY = 7;
    public static final int OPERATOR_PRECEDENCE_COMPARISON = 10;
    public static final int OPERATOR_PRECEDENCE_OR = 2;
    public static final int OPERATOR_PRECEDENCE_AND = 4;
    public static final int OPERATOR_PRECEDENCE_POWER = 40;
    public static final int OPERATOR_PRECEDENCE_MULTIPLICATIVE = 30;
    public static final int OPERATOR_PRECEDENCE_ADDITIVE = 20;
    public static final BigDecimal PI = new BigDecimal("3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679");
    public static final BigDecimal e = new BigDecimal("2.71828182845904523536028747135266249775724709369995957496696762772407663");
    public static final String MISSING_PARAMETERS_FOR_OPERATOR = "Missing parameter(s) for operator ";
    private MathContext mc = null;
    private String firstVarChars = "_";
    private String varChars = "_";
    private final String originalExpression;
    private String expressionString = null;
    private List<Token> rpn = null;
    private Map<String, LazyOperator> operators = new TreeMap<String, LazyOperator>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, com.udojava.evalex.LazyFunction> functions = new TreeMap<String, com.udojava.evalex.LazyFunction>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, LazyNumber> variables = new TreeMap<String, LazyNumber>(String.CASE_INSENSITIVE_ORDER);
    private static final char DECIMAL_SEPARATOR = '.';
    private static final char MINUS_SIGN = '-';
    private static final LazyNumber PARAMS_START = new LazyNumber(){

        @Override
        public BigDecimal eval() {
            return null;
        }

        @Override
        public String getString() {
            return null;
        }
    };

    private LazyNumber createLazyNumber(final BigDecimal bigDecimal) {
        return new LazyNumber(){

            @Override
            public String getString() {
                return bigDecimal.toPlainString();
            }

            @Override
            public BigDecimal eval() {
                return bigDecimal;
            }
        };
    }

    public Expression(String expression) {
        this(expression, MathContext.DECIMAL32);
    }

    public Expression(String expression, MathContext defaultMathContext) {
        this.mc = defaultMathContext;
        this.expressionString = expression;
        this.originalExpression = expression;
        this.addOperator(new Operator("+", 20, true){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                Expression.this.assertNotNull(v1, v2);
                return v1.add(v2, Expression.this.mc);
            }
        });
        this.addOperator(new Operator("-", 20, true){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                Expression.this.assertNotNull(v1, v2);
                return v1.subtract(v2, Expression.this.mc);
            }
        });
        this.addOperator(new Operator("*", 30, true){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                Expression.this.assertNotNull(v1, v2);
                return v1.multiply(v2, Expression.this.mc);
            }
        });
        this.addOperator(new Operator("/", 30, true){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                Expression.this.assertNotNull(v1, v2);
                return v1.divide(v2, Expression.this.mc);
            }
        });
        this.addOperator(new Operator("%", 30, true){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                Expression.this.assertNotNull(v1, v2);
                return v1.remainder(v2, Expression.this.mc);
            }
        });
        this.addOperator(new Operator("^", 40, false){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                Expression.this.assertNotNull(v1, v2);
                int signOf2 = v2.signum();
                double dn1 = v1.doubleValue();
                v2 = v2.multiply(new BigDecimal(signOf2));
                BigDecimal remainderOf2 = v2.remainder(BigDecimal.ONE);
                BigDecimal n2IntPart = v2.subtract(remainderOf2);
                BigDecimal intPow = v1.pow(n2IntPart.intValueExact(), Expression.this.mc);
                BigDecimal doublePow = BigDecimal.valueOf(Math.pow(dn1, remainderOf2.doubleValue()));
                BigDecimal result = intPow.multiply(doublePow, Expression.this.mc);
                if (signOf2 == -1) {
                    result = BigDecimal.ONE.divide(result, Expression.this.mc.getPrecision(), RoundingMode.HALF_UP);
                }
                return result;
            }
        });
        this.addOperator(new Operator("&&", 4, false, true){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                boolean b1;
                Expression.this.assertNotNull(v1, v2);
                boolean bl = b1 = v1.compareTo(BigDecimal.ZERO) != 0;
                if (!b1) {
                    return BigDecimal.ZERO;
                }
                boolean b2 = v2.compareTo(BigDecimal.ZERO) != 0;
                return b2 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator("||", 2, false, true){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                boolean b1;
                Expression.this.assertNotNull(v1, v2);
                boolean bl = b1 = v1.compareTo(BigDecimal.ZERO) != 0;
                if (b1) {
                    return BigDecimal.ONE;
                }
                boolean b2 = v2.compareTo(BigDecimal.ZERO) != 0;
                return b2 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator(">", 10, false, true){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                Expression.this.assertNotNull(v1, v2);
                return v1.compareTo(v2) == 1 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator(">=", 10, false, true){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                Expression.this.assertNotNull(v1, v2);
                return v1.compareTo(v2) >= 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator("<", 10, false, true){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                Expression.this.assertNotNull(v1, v2);
                return v1.compareTo(v2) == -1 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator("<=", 10, false, true){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                Expression.this.assertNotNull(v1, v2);
                return v1.compareTo(v2) <= 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator("=", 7, false, true){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                if (v1 == v2) {
                    return BigDecimal.ONE;
                }
                if (v1 == null || v2 == null) {
                    return BigDecimal.ZERO;
                }
                return v1.compareTo(v2) == 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator("==", 7, false, true){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return ((Operator)Expression.this.operators.get("=")).eval(v1, v2);
            }
        });
        this.addOperator(new Operator("!=", 7, false, true){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                if (v1 == v2) {
                    return BigDecimal.ZERO;
                }
                if (v1 == null || v2 == null) {
                    return BigDecimal.ONE;
                }
                return v1.compareTo(v2) != 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator("<>", 7, false, true){

            @Override
            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                Expression.this.assertNotNull(v1, v2);
                return ((Operator)Expression.this.operators.get("!=")).eval(v1, v2);
            }
        });
        this.addOperator(new UnaryOperator("-", 60, false){

            @Override
            public BigDecimal evalUnary(BigDecimal v1) {
                return v1.multiply(new BigDecimal(-1));
            }
        });
        this.addOperator(new UnaryOperator("+", 60, false){

            @Override
            public BigDecimal evalUnary(BigDecimal v1) {
                return v1.multiply(BigDecimal.ONE);
            }
        });
        this.addFunction(new Function("FACT", 1, false){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                int number = parameters.get(0).intValue();
                BigDecimal factorial = BigDecimal.ONE;
                for (int i = 1; i <= number; ++i) {
                    factorial = factorial.multiply(new BigDecimal(i));
                }
                return factorial;
            }
        });
        this.addFunction(new Function("NOT", 1, true){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                boolean zero = parameters.get(0).compareTo(BigDecimal.ZERO) == 0;
                return zero ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addLazyFunction(new LazyFunction("IF", 3){

            @Override
            public LazyNumber lazyEval(List<LazyNumber> lazyParams) {
                return new LazyIfNumber(lazyParams);
            }
        });
        this.addFunction(new Function("RANDOM", 0){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.random();
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("SIN", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.sin(Math.toRadians(parameters.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("COS", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.cos(Math.toRadians(parameters.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("TAN", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.tan(Math.toRadians(parameters.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("ASIN", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.toDegrees(Math.asin(parameters.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("ACOS", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.toDegrees(Math.acos(parameters.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("ATAN", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.toDegrees(Math.atan(parameters.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("ATAN2", 2){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0), parameters.get(1));
                double d = Math.toDegrees(Math.atan2(parameters.get(0).doubleValue(), parameters.get(1).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("SINH", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.sinh(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("COSH", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.cosh(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("TANH", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.tanh(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("SEC", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double one = 1.0;
                double d = Math.cos(Math.toRadians(parameters.get(0).doubleValue()));
                return new BigDecimal(one / d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("CSC", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double one = 1.0;
                double d = Math.sin(Math.toRadians(parameters.get(0).doubleValue()));
                return new BigDecimal(one / d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("SECH", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double one = 1.0;
                double d = Math.cosh(parameters.get(0).doubleValue());
                return new BigDecimal(one / d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("CSCH", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double one = 1.0;
                double d = Math.sinh(parameters.get(0).doubleValue());
                return new BigDecimal(one / d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("COT", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double one = 1.0;
                double d = Math.tan(Math.toRadians(parameters.get(0).doubleValue()));
                return new BigDecimal(one / d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("ACOT", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                if (parameters.get(0).doubleValue() == 0.0) {
                    throw new ExpressionException("Number must not be 0");
                }
                double d = Math.toDegrees(Math.atan(1.0 / parameters.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("COTH", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double one = 1.0;
                double d = Math.tanh(parameters.get(0).doubleValue());
                return new BigDecimal(one / d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("ASINH", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.log(parameters.get(0).doubleValue() + Math.sqrt(Math.pow(parameters.get(0).doubleValue(), 2.0) + 1.0));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("ACOSH", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                if (Double.compare(parameters.get(0).doubleValue(), 1.0) < 0) {
                    throw new ExpressionException("Number must be x >= 1");
                }
                double d = Math.log(parameters.get(0).doubleValue() + Math.sqrt(Math.pow(parameters.get(0).doubleValue(), 2.0) - 1.0));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("ATANH", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                if (Math.abs(parameters.get(0).doubleValue()) > 1.0 || Math.abs(parameters.get(0).doubleValue()) == 1.0) {
                    throw new ExpressionException("Number must be |x| < 1");
                }
                double d = 0.5 * Math.log((1.0 + parameters.get(0).doubleValue()) / (1.0 - parameters.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("RAD", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.toRadians(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("DEG", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.toDegrees(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("MAX", -1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                if (parameters.isEmpty()) {
                    throw new ExpressionException("MAX requires at least one parameter");
                }
                BigDecimal max = null;
                for (BigDecimal parameter : parameters) {
                    Expression.this.assertNotNull(parameter);
                    if (max != null && parameter.compareTo(max) <= 0) continue;
                    max = parameter;
                }
                return max;
            }
        });
        this.addFunction(new Function("MIN", -1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                if (parameters.isEmpty()) {
                    throw new ExpressionException("MIN requires at least one parameter");
                }
                BigDecimal min = null;
                for (BigDecimal parameter : parameters) {
                    Expression.this.assertNotNull(parameter);
                    if (min != null && parameter.compareTo(min) >= 0) continue;
                    min = parameter;
                }
                return min;
            }
        });
        this.addFunction(new Function("ABS", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                return parameters.get(0).abs(Expression.this.mc);
            }
        });
        this.addFunction(new Function("LOG", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.log(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("LOG10", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                double d = Math.log10(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("ROUND", 2){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0), parameters.get(1));
                BigDecimal toRound = parameters.get(0);
                int precision = parameters.get(1).intValue();
                return toRound.setScale(precision, Expression.this.mc.getRoundingMode());
            }
        });
        this.addFunction(new Function("FLOOR", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                BigDecimal toRound = parameters.get(0);
                return toRound.setScale(0, RoundingMode.FLOOR);
            }
        });
        this.addFunction(new Function("CEILING", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                Expression.this.assertNotNull(parameters.get(0));
                BigDecimal toRound = parameters.get(0);
                return toRound.setScale(0, RoundingMode.CEILING);
            }
        });
        this.addFunction(new Function("SQRT", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                BigInteger ixPrev;
                BigInteger test;
                Expression.this.assertNotNull(parameters.get(0));
                BigDecimal x = parameters.get(0);
                if (x.compareTo(BigDecimal.ZERO) == 0) {
                    return new BigDecimal(0);
                }
                if (x.signum() < 0) {
                    throw new ExpressionException("Argument to SQRT() function must not be negative");
                }
                BigInteger n = x.movePointRight(Expression.this.mc.getPrecision() << 1).toBigInteger();
                int bits = n.bitLength() + 1 >> 1;
                BigInteger ix = n.shiftRight(bits);
                do {
                    ixPrev = ix;
                    ix = ix.add(n.divide(ix)).shiftRight(1);
                    Thread.yield();
                } while ((test = ix.subtract(ixPrev).abs()).compareTo(BigInteger.ZERO) != 0 && test.compareTo(BigInteger.ONE) != 0);
                return new BigDecimal(ix, Expression.this.mc.getPrecision());
            }
        });
        this.variables.put("e", this.createLazyNumber(e));
        this.variables.put("PI", this.createLazyNumber(PI));
        this.variables.put("NULL", null);
        this.variables.put("TRUE", this.createLazyNumber(BigDecimal.ONE));
        this.variables.put("FALSE", this.createLazyNumber(BigDecimal.ZERO));
    }

    private void assertNotNull(BigDecimal v1) {
        if (v1 == null) {
            throw new ArithmeticException("Operand may not be null");
        }
    }

    private void assertNotNull(BigDecimal v1, BigDecimal v2) {
        if (v1 == null) {
            throw new ArithmeticException("First operand may not be null");
        }
        if (v2 == null) {
            throw new ArithmeticException("Second operand may not be null");
        }
    }

    private boolean isNumber(String st) {
        if (st.charAt(0) == '-' && st.length() == 1) {
            return false;
        }
        if (st.charAt(0) == '+' && st.length() == 1) {
            return false;
        }
        if (!(st.charAt(0) != '.' || st.length() != 1 && Character.isDigit(st.charAt(1)))) {
            return false;
        }
        if (st.charAt(0) == 'e' || st.charAt(0) == 'E') {
            return false;
        }
        for (char ch : st.toCharArray()) {
            if (Character.isDigit(ch) || ch == '-' || ch == '.' || ch == 'e' || ch == 'E' || ch == '+') continue;
            return false;
        }
        return true;
    }

    private List<Token> shuntingYard(String expression) {
        ArrayList<Token> outputQueue = new ArrayList<Token>();
        Stack<Token> stack = new Stack<Token>();
        Tokenizer tokenizer = new Tokenizer(expression);
        Token lastFunction = null;
        Token previousToken = null;
        while (tokenizer.hasNext()) {
            Token token = tokenizer.next();
            switch (token.type) {
                case STRINGPARAM: {
                    stack.push(token);
                    break;
                }
                case LITERAL: 
                case HEX_LITERAL: {
                    if (previousToken != null && (previousToken.type == TokenType.LITERAL || previousToken.type == TokenType.HEX_LITERAL)) {
                        throw new ExpressionException("Missing operator", token.pos);
                    }
                    outputQueue.add(token);
                    break;
                }
                case VARIABLE: {
                    outputQueue.add(token);
                    break;
                }
                case FUNCTION: {
                    stack.push(token);
                    lastFunction = token;
                    break;
                }
                case COMMA: {
                    if (previousToken != null && previousToken.type == TokenType.OPERATOR) {
                        throw new ExpressionException(MISSING_PARAMETERS_FOR_OPERATOR + previousToken, previousToken.pos);
                    }
                    while (!stack.isEmpty() && ((Token)stack.peek()).type != TokenType.OPEN_PAREN) {
                        outputQueue.add((Token)stack.pop());
                    }
                    if (!stack.isEmpty()) break;
                    if (lastFunction == null) {
                        throw new ExpressionException("Unexpected comma", token.pos);
                    }
                    throw new ExpressionException("Parse error for function " + lastFunction, token.pos);
                }
                case OPERATOR: {
                    if (previousToken != null && (previousToken.type == TokenType.COMMA || previousToken.type == TokenType.OPEN_PAREN)) {
                        throw new ExpressionException(MISSING_PARAMETERS_FOR_OPERATOR + token, token.pos);
                    }
                    LazyOperator o1 = this.operators.get(token.surface);
                    if (o1 == null) {
                        throw new ExpressionException("Unknown operator " + token, token.pos + 1);
                    }
                    this.shuntOperators(outputQueue, stack, o1);
                    stack.push(token);
                    break;
                }
                case UNARY_OPERATOR: {
                    if (previousToken != null && previousToken.type != TokenType.OPERATOR && previousToken.type != TokenType.COMMA && previousToken.type != TokenType.OPEN_PAREN && previousToken.type != TokenType.UNARY_OPERATOR) {
                        throw new ExpressionException("Invalid position for unary operator " + token, token.pos);
                    }
                    LazyOperator o1 = this.operators.get(token.surface);
                    if (o1 == null) {
                        throw new ExpressionException("Unknown unary operator " + token.surface.substring(0, token.surface.length() - 1), token.pos + 1);
                    }
                    this.shuntOperators(outputQueue, stack, o1);
                    stack.push(token);
                    break;
                }
                case OPEN_PAREN: {
                    if (previousToken != null) {
                        if (previousToken.type == TokenType.LITERAL || previousToken.type == TokenType.CLOSE_PAREN || previousToken.type == TokenType.VARIABLE || previousToken.type == TokenType.HEX_LITERAL) {
                            Token multiplication = new Token();
                            multiplication.append("*");
                            multiplication.type = TokenType.OPERATOR;
                            stack.push(multiplication);
                        }
                        if (previousToken.type == TokenType.FUNCTION) {
                            outputQueue.add(token);
                        }
                    }
                    stack.push(token);
                    break;
                }
                case CLOSE_PAREN: {
                    if (previousToken != null && previousToken.type == TokenType.OPERATOR) {
                        throw new ExpressionException(MISSING_PARAMETERS_FOR_OPERATOR + previousToken, previousToken.pos);
                    }
                    while (!stack.isEmpty() && ((Token)stack.peek()).type != TokenType.OPEN_PAREN) {
                        outputQueue.add((Token)stack.pop());
                    }
                    if (stack.isEmpty()) {
                        throw new ExpressionException("Mismatched parentheses");
                    }
                    stack.pop();
                    if (stack.isEmpty() || stack.peek().type != TokenType.FUNCTION) break;
                    outputQueue.add(stack.pop());
                }
            }
            previousToken = token;
        }
        while (!stack.isEmpty()) {
            Token element = (Token)stack.pop();
            if (element.type == TokenType.OPEN_PAREN || element.type == TokenType.CLOSE_PAREN) {
                throw new ExpressionException("Mismatched parentheses");
            }
            outputQueue.add(element);
        }
        return outputQueue;
    }

    private void shuntOperators(List<Token> outputQueue, Stack<Token> stack, LazyOperator o1) {
        Token nextToken;
        Token token = nextToken = stack.isEmpty() ? null : stack.peek();
        while (nextToken != null && (nextToken.type == TokenType.OPERATOR || nextToken.type == TokenType.UNARY_OPERATOR) && (o1.isLeftAssoc() && o1.getPrecedence() <= this.operators.get(nextToken.surface).getPrecedence() || o1.getPrecedence() < this.operators.get(nextToken.surface).getPrecedence())) {
            outputQueue.add(stack.pop());
            nextToken = stack.isEmpty() ? null : stack.peek();
        }
    }

    public BigDecimal eval() {
        return this.eval(true);
    }

    public BigDecimal eval(boolean stripTrailingZeros) {
        ArrayDeque<LazyNumber> stack = new ArrayDeque<LazyNumber>();
        block10: for (final Token token : this.getRPN()) {
            switch (token.type) {
                case UNARY_OPERATOR: {
                    final LazyNumber value = (LazyNumber)stack.pop();
                    LazyNumber result = new LazyNumber(){

                        @Override
                        public BigDecimal eval() {
                            return ((LazyOperator)Expression.this.operators.get(token.surface)).eval(value, null).eval();
                        }

                        @Override
                        public String getString() {
                            return String.valueOf(((LazyOperator)Expression.this.operators.get(token.surface)).eval(value, null).eval());
                        }
                    };
                    stack.push(result);
                    continue block10;
                }
                case OPERATOR: {
                    final LazyNumber v1 = (LazyNumber)stack.pop();
                    final LazyNumber v2 = (LazyNumber)stack.pop();
                    LazyNumber result = new LazyNumber(){

                        @Override
                        public BigDecimal eval() {
                            return ((LazyOperator)Expression.this.operators.get(token.surface)).eval(v2, v1).eval();
                        }

                        @Override
                        public String getString() {
                            return String.valueOf(((LazyOperator)Expression.this.operators.get(token.surface)).eval(v2, v1).eval());
                        }
                    };
                    stack.push(result);
                    continue block10;
                }
                case VARIABLE: {
                    if (!this.variables.containsKey(token.surface)) {
                        throw new ExpressionException("Unknown operator or function: " + token);
                    }
                    stack.push(new LazyNumber(){

                        @Override
                        public BigDecimal eval() {
                            LazyNumber lazyVariable = (LazyNumber)Expression.this.variables.get(token.surface);
                            BigDecimal value = lazyVariable == null ? null : lazyVariable.eval();
                            return value == null ? null : value.round(Expression.this.mc);
                        }

                        @Override
                        public String getString() {
                            return token.surface;
                        }
                    });
                    continue block10;
                }
                case FUNCTION: {
                    com.udojava.evalex.LazyFunction f = this.functions.get(token.surface.toUpperCase(Locale.ROOT));
                    ArrayList<LazyNumber> p = new ArrayList<LazyNumber>(!f.numParamsVaries() ? f.getNumParams() : 0);
                    while (!stack.isEmpty() && stack.peek() != PARAMS_START) {
                        p.add(0, (LazyNumber)stack.pop());
                    }
                    if (stack.peek() == PARAMS_START) {
                        stack.pop();
                    }
                    LazyNumber fResult = f.lazyEval(p);
                    stack.push(fResult);
                    continue block10;
                }
                case OPEN_PAREN: {
                    stack.push(PARAMS_START);
                    continue block10;
                }
                case LITERAL: {
                    stack.push(new LazyNumber(){

                        @Override
                        public BigDecimal eval() {
                            if (token.surface.equalsIgnoreCase("NULL")) {
                                return null;
                            }
                            return new BigDecimal(token.surface, Expression.this.mc);
                        }

                        @Override
                        public String getString() {
                            return String.valueOf(new BigDecimal(token.surface, Expression.this.mc));
                        }
                    });
                    continue block10;
                }
                case STRINGPARAM: {
                    stack.push(new LazyNumber(){

                        @Override
                        public BigDecimal eval() {
                            return null;
                        }

                        @Override
                        public String getString() {
                            return token.surface;
                        }
                    });
                    continue block10;
                }
                case HEX_LITERAL: {
                    stack.push(new LazyNumber(){

                        @Override
                        public BigDecimal eval() {
                            return new BigDecimal(new BigInteger(token.surface.substring(2), 16), Expression.this.mc);
                        }

                        @Override
                        public String getString() {
                            return new BigInteger(token.surface.substring(2), 16).toString();
                        }
                    });
                    continue block10;
                }
            }
            throw new ExpressionException("Unexpected token " + token.surface, token.pos);
        }
        BigDecimal result = ((LazyNumber)stack.pop()).eval();
        if (result == null) {
            return null;
        }
        if (stripTrailingZeros) {
            result = result.stripTrailingZeros();
        }
        return result;
    }

    public Expression setPrecision(int precision) {
        this.mc = new MathContext(precision);
        return this;
    }

    public Expression setRoundingMode(RoundingMode roundingMode) {
        this.mc = new MathContext(this.mc.getPrecision(), roundingMode);
        return this;
    }

    public Expression setFirstVariableCharacters(String chars) {
        this.firstVarChars = chars;
        return this;
    }

    public Expression setVariableCharacters(String chars) {
        this.varChars = chars;
        return this;
    }

    public <OPERATOR extends LazyOperator> OPERATOR addOperator(OPERATOR operator) {
        String key = operator.getOper();
        if (operator instanceof AbstractUnaryOperator) {
            key = key + "u";
        }
        return (OPERATOR)this.operators.put(key, operator);
    }

    public com.udojava.evalex.Function addFunction(com.udojava.evalex.Function function) {
        return (com.udojava.evalex.Function)this.functions.put(function.getName(), function);
    }

    public com.udojava.evalex.LazyFunction addLazyFunction(com.udojava.evalex.LazyFunction function) {
        return this.functions.put(function.getName(), function);
    }

    public Expression setVariable(String variable, BigDecimal value) {
        return this.setVariable(variable, this.createLazyNumber(value));
    }

    public Expression setVariable(String variable, LazyNumber value) {
        this.variables.put(variable, value);
        return this;
    }

    public Expression setVariable(String variable, String value) {
        if (this.isNumber(value)) {
            this.variables.put(variable, this.createLazyNumber(new BigDecimal(value, this.mc)));
        } else if (value.equalsIgnoreCase("null")) {
            this.variables.put(variable, null);
        } else {
            final String expStr = value;
            this.variables.put(variable, new LazyNumber(){
                private final Map<String, LazyNumber> outerVariables;
                private final Map<String, com.udojava.evalex.LazyFunction> outerFunctions;
                private final Map<String, LazyOperator> outerOperators;
                private final String innerExpressionString;
                private final MathContext inneMc;
                {
                    this.outerVariables = Expression.this.variables;
                    this.outerFunctions = Expression.this.functions;
                    this.outerOperators = Expression.this.operators;
                    this.innerExpressionString = expStr;
                    this.inneMc = Expression.this.mc;
                }

                @Override
                public String getString() {
                    return this.innerExpressionString;
                }

                @Override
                public BigDecimal eval() {
                    Expression innerE = new Expression(this.innerExpressionString, this.inneMc);
                    innerE.variables = this.outerVariables;
                    innerE.functions = this.outerFunctions;
                    innerE.operators = this.outerOperators;
                    BigDecimal val = innerE.eval();
                    return val;
                }
            });
            this.rpn = null;
        }
        return this;
    }

    private Expression createEmbeddedExpression(String expression) {
        Map<String, LazyNumber> outerVariables = this.variables;
        Map<String, com.udojava.evalex.LazyFunction> outerFunctions = this.functions;
        Map<String, LazyOperator> outerOperators = this.operators;
        MathContext inneMc = this.mc;
        Expression exp = new Expression(expression, inneMc);
        exp.variables = outerVariables;
        exp.functions = outerFunctions;
        exp.operators = outerOperators;
        return exp;
    }

    public Expression with(String variable, BigDecimal value) {
        return this.setVariable(variable, value);
    }

    public Expression with(String variable, LazyNumber value) {
        return this.setVariable(variable, value);
    }

    public Expression and(String variable, String value) {
        return this.setVariable(variable, value);
    }

    public Expression and(String variable, BigDecimal value) {
        return this.setVariable(variable, value);
    }

    public Expression and(String variable, LazyNumber value) {
        return this.setVariable(variable, value);
    }

    public Expression with(String variable, String value) {
        return this.setVariable(variable, value);
    }

    public Iterator<Token> getExpressionTokenizer() {
        String expression = this.expressionString;
        return new Tokenizer(expression);
    }

    private List<Token> getRPN() {
        if (this.rpn == null) {
            this.rpn = this.shuntingYard(this.expressionString);
            this.validate(this.rpn);
        }
        return this.rpn;
    }

    private void validate(List<Token> rpn) {
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(0);
        block6: for (Token token : rpn) {
            switch (token.type) {
                case UNARY_OPERATOR: {
                    if ((Integer)stack.peek() >= 1) continue block6;
                    throw new ExpressionException(MISSING_PARAMETERS_FOR_OPERATOR + token);
                }
                case OPERATOR: {
                    if ((Integer)stack.peek() < 2) {
                        throw new ExpressionException(MISSING_PARAMETERS_FOR_OPERATOR + token);
                    }
                    stack.set(stack.size() - 1, (Integer)stack.peek() - 2 + 1);
                    continue block6;
                }
                case FUNCTION: {
                    com.udojava.evalex.LazyFunction f = this.functions.get(token.surface.toUpperCase(Locale.ROOT));
                    if (f == null) {
                        throw new ExpressionException("Unknown function " + token, token.pos + 1);
                    }
                    int numParams = (Integer)stack.pop();
                    if (!f.numParamsVaries() && numParams != f.getNumParams()) {
                        throw new ExpressionException("Function " + token + " expected " + f.getNumParams() + " parameters, got " + numParams);
                    }
                    if (stack.isEmpty()) {
                        throw new ExpressionException("Too many function calls, maximum scope exceeded");
                    }
                    stack.set(stack.size() - 1, (Integer)stack.peek() + 1);
                    continue block6;
                }
                case OPEN_PAREN: {
                    stack.push(0);
                    continue block6;
                }
            }
            stack.set(stack.size() - 1, (Integer)stack.peek() + 1);
        }
        if (stack.size() > 1) {
            throw new ExpressionException("Too many unhandled function parameter lists");
        }
        if ((Integer)stack.peek() > 1) {
            throw new ExpressionException("Too many numbers or variables");
        }
        if ((Integer)stack.peek() < 1) {
            throw new ExpressionException("Empty expression");
        }
    }

    public String toRPN() {
        StringBuilder result = new StringBuilder();
        for (Token t : this.getRPN()) {
            if (result.length() != 0) {
                result.append(" ");
            }
            if (t.type == TokenType.VARIABLE && this.variables.containsKey(t.surface)) {
                LazyNumber innerVariable = this.variables.get(t.surface);
                String innerExp = innerVariable.getString();
                if (this.isNumber(innerExp)) {
                    result.append(t.toString());
                    continue;
                }
                Expression exp = this.createEmbeddedExpression(innerExp);
                String nestedExpRpn = exp.toRPN();
                result.append(nestedExpRpn);
                continue;
            }
            result.append(t.toString());
        }
        return result.toString();
    }

    public Set<String> getDeclaredVariables() {
        return Collections.unmodifiableSet(this.variables.keySet());
    }

    public Set<String> getDeclaredOperators() {
        return Collections.unmodifiableSet(this.operators.keySet());
    }

    public Set<String> getDeclaredFunctions() {
        return Collections.unmodifiableSet(this.functions.keySet());
    }

    public String getExpression() {
        return this.expressionString;
    }

    public List<String> getUsedVariables() {
        ArrayList<String> result = new ArrayList<String>();
        Tokenizer tokenizer = new Tokenizer(this.expressionString);
        while (tokenizer.hasNext()) {
            Token nextToken = tokenizer.next();
            String token = nextToken.toString();
            if (nextToken.type != TokenType.VARIABLE || token.equals("PI") || token.equals("e") || token.equals("TRUE") || token.equals("FALSE")) continue;
            result.add(token);
        }
        return result;
    }

    public String getOriginalExpression() {
        return this.originalExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Expression that = (Expression)o;
        if (this.expressionString == null) {
            return that.expressionString == null;
        }
        return this.expressionString.equals(that.expressionString);
    }

    public int hashCode() {
        return this.expressionString == null ? 0 : this.expressionString.hashCode();
    }

    public String toString() {
        return this.expressionString;
    }

    public boolean isBoolean() {
        List<Token> rpnList = this.getRPN();
        if (!rpnList.isEmpty()) {
            for (int i = rpnList.size() - 1; i >= 0; --i) {
                Token t = rpnList.get(i);
                if (t.surface.equals("IF")) continue;
                if (t.type == TokenType.FUNCTION) {
                    return this.functions.get(t.surface).isBooleanFunction();
                }
                if (t.type != TokenType.OPERATOR) continue;
                return this.operators.get(t.surface).isBooleanOperator();
            }
        }
        return false;
    }

    public List<String> infixNotation() {
        ArrayList<String> infix = new ArrayList<String>();
        Tokenizer tokenizer = new Tokenizer(this.expressionString);
        while (tokenizer.hasNext()) {
            Token token = tokenizer.next();
            String infixNotation = "{" + (Object)((Object)token.type) + ":" + token.surface + "}";
            infix.add(infixNotation);
        }
        return infix;
    }

    private class Tokenizer
    implements Iterator<Token> {
        private int pos = 0;
        private String input;
        private Token previousToken;

        public Tokenizer(String input) {
            this.input = input.trim();
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.input.length();
        }

        private char peekNextChar() {
            if (this.pos < this.input.length() - 1) {
                return this.input.charAt(this.pos + 1);
            }
            return '\u0000';
        }

        private boolean isHexDigit(char ch) {
            return ch == 'x' || ch == 'X' || ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F';
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Token next() {
            Token token = new Token();
            if (this.pos >= this.input.length()) {
                this.previousToken = null;
                return null;
            }
            char ch = this.input.charAt(this.pos);
            while (Character.isWhitespace(ch) && this.pos < this.input.length()) {
                ch = this.input.charAt(++this.pos);
            }
            token.pos = this.pos;
            boolean isHex = false;
            if (Character.isDigit(ch) || ch == '.' && Character.isDigit(this.peekNextChar())) {
                if (ch == '0' && (this.peekNextChar() == 'x' || this.peekNextChar() == 'X')) {
                    isHex = true;
                }
                while (isHex && this.isHexDigit(ch) || (Character.isDigit(ch) || ch == '.' || ch == 'e' || ch == 'E' || ch == '-' && token.length() > 0 && ('e' == token.charAt(token.length() - 1) || 'E' == token.charAt(token.length() - 1)) || ch == '+' && token.length() > 0 && ('e' == token.charAt(token.length() - 1) || 'E' == token.charAt(token.length() - 1))) && this.pos < this.input.length()) {
                    token.append(this.input.charAt(this.pos++));
                    ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
                }
                token.type = isHex ? TokenType.HEX_LITERAL : TokenType.LITERAL;
            } else if (ch == '\"') {
                ++this.pos;
                if (this.previousToken.type == TokenType.STRINGPARAM) return this.next();
                ch = this.input.charAt(this.pos);
                while (ch != '\"') {
                    token.append(this.input.charAt(this.pos++));
                    ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
                }
                token.type = TokenType.STRINGPARAM;
            } else if (Character.isLetter(ch) || Expression.this.firstVarChars.indexOf(ch) >= 0) {
                while ((Character.isLetter(ch) || Character.isDigit(ch) || Expression.this.varChars.indexOf(ch) >= 0 || token.length() == 0 && Expression.this.firstVarChars.indexOf(ch) >= 0) && this.pos < this.input.length()) {
                    token.append(this.input.charAt(this.pos++));
                    ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
                }
                if (Character.isWhitespace(ch)) {
                    while (Character.isWhitespace(ch) && this.pos < this.input.length()) {
                        ch = this.input.charAt(this.pos++);
                    }
                    --this.pos;
                }
                token.type = Expression.this.operators.containsKey(token.surface) ? TokenType.OPERATOR : (ch == '(' ? TokenType.FUNCTION : TokenType.VARIABLE);
            } else if (ch == '(' || ch == ')' || ch == ',') {
                token.type = ch == '(' ? TokenType.OPEN_PAREN : (ch == ')' ? TokenType.CLOSE_PAREN : TokenType.COMMA);
                token.append(ch);
                ++this.pos;
            } else {
                String greedyMatch = "";
                int initialPos = this.pos;
                ch = this.input.charAt(this.pos);
                int validOperatorSeenUntil = -1;
                while (!(Character.isLetter(ch) || Character.isDigit(ch) || Expression.this.firstVarChars.indexOf(ch) >= 0 || Character.isWhitespace(ch) || ch == '(' || ch == ')' || ch == ',' || this.pos >= this.input.length())) {
                    greedyMatch = greedyMatch + ch;
                    ++this.pos;
                    if (Expression.this.operators.containsKey(greedyMatch)) {
                        validOperatorSeenUntil = this.pos;
                    }
                    ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
                }
                if (validOperatorSeenUntil != -1) {
                    token.append(this.input.substring(initialPos, validOperatorSeenUntil));
                    this.pos = validOperatorSeenUntil;
                } else {
                    token.append(greedyMatch);
                }
                if (this.previousToken == null || this.previousToken.type == TokenType.OPERATOR || this.previousToken.type == TokenType.OPEN_PAREN || this.previousToken.type == TokenType.COMMA || this.previousToken.type == TokenType.UNARY_OPERATOR) {
                    token.surface = token.surface + "u";
                    token.type = TokenType.UNARY_OPERATOR;
                } else {
                    token.type = TokenType.OPERATOR;
                }
            }
            this.previousToken = token;
            return token;
        }

        @Override
        public void remove() {
            throw new ExpressionException("remove() not supported");
        }
    }

    class Token {
        public String surface = "";
        public TokenType type;
        public int pos;

        Token() {
        }

        public void append(char c) {
            this.surface = this.surface + c;
        }

        public void append(String s) {
            this.surface = this.surface + s;
        }

        public char charAt(int pos) {
            return this.surface.charAt(pos);
        }

        public int length() {
            return this.surface.length();
        }

        public String toString() {
            return this.surface;
        }
    }

    static enum TokenType {
        VARIABLE,
        FUNCTION,
        LITERAL,
        OPERATOR,
        UNARY_OPERATOR,
        OPEN_PAREN,
        COMMA,
        CLOSE_PAREN,
        HEX_LITERAL,
        STRINGPARAM;

    }

    public abstract class UnaryOperator
    extends AbstractUnaryOperator {
        public UnaryOperator(String oper, int precedence, boolean leftAssoc) {
            super(oper, precedence, leftAssoc);
        }
    }

    public abstract class Operator
    extends AbstractOperator {
        public Operator(String oper, int precedence, boolean leftAssoc, boolean booleanOperator) {
            super(oper, precedence, leftAssoc, booleanOperator);
        }

        public Operator(String oper, int precedence, boolean leftAssoc) {
            super(oper, precedence, leftAssoc);
        }
    }

    public abstract class Function
    extends AbstractFunction {
        public Function(String name, int numParams) {
            super(name, numParams);
        }

        public Function(String name, int numParams, boolean booleanFunction) {
            super(name, numParams, booleanFunction);
        }
    }

    public abstract class LazyFunction
    extends AbstractLazyFunction {
        public LazyFunction(String name, int numParams, boolean booleanFunction) {
            super(name, numParams, booleanFunction);
        }

        public LazyFunction(String name, int numParams) {
            super(name, numParams);
        }
    }

    public static interface LazyNumber {
        public BigDecimal eval();

        public String getString();
    }

    public static class ExpressionException
    extends RuntimeException {
        private static final long serialVersionUID = 1118142866870779047L;

        public ExpressionException(String message) {
            super(message);
        }

        public ExpressionException(String message, int characterPosition) {
            super(message + " at character position " + characterPosition);
        }
    }
}

