/*
 * Decompiled with CFR 0.152.
 */
package com.ufoscout.properlty.reader;

import com.ufoscout.properlty.reader.PropertyValue;
import com.ufoscout.properlty.reader.Reader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class EnvironmentVariablesReader
implements Reader {
    private final Map<String, String> replaceMap = new ConcurrentHashMap<String, String>();
    private final Supplier<Map<String, String>> envSupplier;

    public EnvironmentVariablesReader() {
        this(() -> System.getenv());
    }

    public EnvironmentVariablesReader(Supplier<Map<String, String>> envSupplier) {
        this.envSupplier = envSupplier;
    }

    @Override
    public Map<String, PropertyValue> read() {
        return this.envSupplier.get().entrySet().stream().collect(Collectors.toMap(e -> this.getKey((String)e.getKey()), e -> PropertyValue.of((String)e.getValue()).resolvable(false)));
    }

    public EnvironmentVariablesReader replace(String from, String to) {
        this.replaceMap.put(from, to);
        return this;
    }

    private String getKey(String key) {
        for (Map.Entry<String, String> entry : this.replaceMap.entrySet()) {
            key = key.replace(entry.getKey(), entry.getValue());
        }
        return key;
    }
}

