/*
 * Decompiled with CFR 0.152.
 */
package com.ufoscout.properlty.reader;

import com.ufoscout.properlty.exception.ResourceNotFoundException;
import com.ufoscout.properlty.reader.PropertyValue;
import com.ufoscout.properlty.reader.Reader;
import com.ufoscout.properlty.util.FileUtils;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertiesResourceReader
implements Reader {
    private final String resourcePath;
    private boolean ignoreNotFound = false;
    private Charset charset = StandardCharsets.UTF_8;

    public static PropertiesResourceReader build(String resourcePath) {
        return new PropertiesResourceReader(resourcePath);
    }

    private PropertiesResourceReader(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, PropertyValue> read() {
        try (InputStream inputStream = FileUtils.getStream(this.resourcePath);){
            Properties prop = new Properties();
            HashMap<String, PropertyValue> map = new HashMap<String, PropertyValue>();
            prop.load(new InputStreamReader(inputStream, this.charset));
            for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                map.put((String)entry.getKey(), PropertyValue.of((String)entry.getValue()));
            }
            HashMap<String, PropertyValue> hashMap = map;
            return hashMap;
        }
        catch (FileNotFoundException e) {
            if (!this.ignoreNotFound) throw new ResourceNotFoundException(e);
            return new HashMap<String, PropertyValue>();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isIgnoreNotFound() {
        return this.ignoreNotFound;
    }

    public PropertiesResourceReader ignoreNotFound(boolean ignoreNotFound) {
        this.ignoreNotFound = ignoreNotFound;
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public PropertiesResourceReader charset(Charset charset) {
        this.charset = charset;
        return this;
    }
}

