/*
 * Decompiled with CFR 0.152.
 */
package com.ufoscout.properlty.reader.decorator;

import com.ufoscout.properlty.exception.UnresolvablePlaceholdersException;
import com.ufoscout.properlty.reader.PropertyValue;
import com.ufoscout.properlty.reader.Reader;
import com.ufoscout.properlty.reader.decorator.DecoratorReader;
import com.ufoscout.properlty.util.StringUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ReplacerDecoratorReader
extends DecoratorReader {
    private final String startDelimiter;
    private final String endDelimiter;
    private final String defaultValueSeparator;
    private final boolean ignoreUnresolvablePlaceholders;
    private final boolean caseSensitiveKeys;

    public ReplacerDecoratorReader(Reader reader, String startDelimiter, String endDelimiter, String defaultValueSeparator, boolean ignoreUnresolvablePlaceholders, boolean caseSensitive) {
        super(reader);
        this.startDelimiter = startDelimiter;
        this.endDelimiter = endDelimiter;
        this.defaultValueSeparator = defaultValueSeparator;
        this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
        this.caseSensitiveKeys = caseSensitive;
    }

    @Override
    protected Map<String, PropertyValue> apply(Map<String, PropertyValue> input) {
        LinkedHashMap<String, PropertyValue> output = new LinkedHashMap<String, PropertyValue>();
        input.forEach((key, value) -> output.put(this.getKey((String)key), (PropertyValue)value));
        LinkedHashMap<String, PropertyValue> valuesToBeReplacedMap = new LinkedHashMap<String, PropertyValue>();
        boolean valuesToBeReplaced = true;
        boolean valuesReplacedOnLastLoop = true;
        while (valuesReplacedOnLastLoop && valuesToBeReplaced) {
            valuesToBeReplaced = false;
            valuesToBeReplacedMap.clear();
            valuesReplacedOnLastLoop = false;
            for (Map.Entry entry : output.entrySet()) {
                String key2 = (String)entry.getKey();
                PropertyValue value2 = (PropertyValue)entry.getValue();
                if (!value2.isResolvable()) continue;
                List<String> tokens = StringUtils.allTokens(value2.getValue(), this.startDelimiter, this.endDelimiter, true);
                if (!tokens.isEmpty()) {
                    valuesToBeReplaced = true;
                    valuesToBeReplacedMap.put(key2, value2);
                }
                for (String token : tokens) {
                    PropertyValue tokenValue = (PropertyValue)output.get(this.getBaseValue(token, this.defaultValueSeparator));
                    if (tokenValue != null) {
                        if (StringUtils.hasTokens(tokenValue.getValue(), this.startDelimiter, this.endDelimiter)) continue;
                        value2.value(value2.getValue().replace(this.startDelimiter + token + this.endDelimiter, tokenValue.getValue()));
                        valuesReplacedOnLastLoop = true;
                        continue;
                    }
                    if (!this.hasDefaultValue(token, this.defaultValueSeparator)) continue;
                    value2.value(this.getDefaultValue(token, this.defaultValueSeparator));
                    output.put(key2, value2);
                    valuesReplacedOnLastLoop = true;
                }
            }
        }
        if (!valuesToBeReplacedMap.isEmpty() && !this.ignoreUnresolvablePlaceholders) {
            StringBuilder message = new StringBuilder("Unresolvable placeholders: \n");
            valuesToBeReplacedMap.forEach((key, value) -> {
                message.append("key: [");
                message.append((String)key);
                message.append("] value: [");
                message.append(value.getValue());
                message.append("]\n");
            });
            throw new UnresolvablePlaceholdersException(message.toString());
        }
        return output;
    }

    private boolean hasDefaultValue(String token, String defaultValueSeparator) {
        return token.indexOf(defaultValueSeparator) >= 0;
    }

    private String getBaseValue(String token, String defaultValueSeparator) {
        int index = token.indexOf(defaultValueSeparator);
        if (index >= 0) {
            token = token.substring(0, index);
        }
        return this.getKey(token);
    }

    private String getDefaultValue(String token, String defaultValueSeparator) {
        int index = token.indexOf(defaultValueSeparator);
        if (index >= 0) {
            return token.substring(index + 1);
        }
        return "";
    }

    private String getKey(String key) {
        if (this.caseSensitiveKeys) {
            return key;
        }
        return key.toLowerCase();
    }
}

