/*
 * Decompiled with CFR 0.152.
 */
package com.ufoscout.properlty.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public final class FileUtils {
    public static final String FILE_PATH_PREFIX = "file:";
    public static final String CLASSPATH_PREFIX = "classpath:";

    private FileUtils() {
    }

    public static InputStream getStream(String resourcePath) throws FileNotFoundException {
        if (resourcePath.startsWith(CLASSPATH_PREFIX)) {
            String resourceName = resourcePath.substring(CLASSPATH_PREFIX.length());
            InputStream is = FileUtils.class.getClassLoader().getResourceAsStream(resourceName);
            if (is == null) {
                throw new FileNotFoundException("Cannot retrieve classpath resource [" + resourceName + "]");
            }
            return is;
        }
        if (resourcePath.startsWith(FILE_PATH_PREFIX)) {
            return new FileInputStream(resourcePath.substring(FILE_PATH_PREFIX.length()));
        }
        return new FileInputStream(resourcePath);
    }
}

