/*
 * Decompiled with CFR 0.152.
 */
package com.ufoscout.properlty.util;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean hasTokens(String input, String startDelimiter, String endDelimiter) {
        int start = input.indexOf(startDelimiter);
        int end = input.lastIndexOf(endDelimiter);
        return start >= 0 && end >= start;
    }

    public static Optional<String> firstToken(String input, String startDelimiter, String endDelimiter) {
        String result = null;
        if (StringUtils.hasTokens(input, startDelimiter, endDelimiter)) {
            while (input.contains(startDelimiter)) {
                int start = input.indexOf(startDelimiter);
                input = input.substring(start + startDelimiter.length());
                while (input.contains(endDelimiter)) {
                    int end = input.indexOf(endDelimiter);
                    input = input.substring(0, end);
                }
            }
            result = input;
        }
        return Optional.ofNullable(result);
    }

    public static List<String> allTokens(String input, String startDelimiter, String endDelimiter) {
        ArrayList<String> tokens = new ArrayList<String>();
        Optional<String> token = StringUtils.firstToken(input, startDelimiter, endDelimiter);
        while (token.isPresent()) {
            String tokenValue = token.get();
            tokens.add(tokenValue);
            input = input.substring(input.indexOf(tokenValue) + tokenValue.length() + endDelimiter.length());
            token = StringUtils.firstToken(input, startDelimiter, endDelimiter);
        }
        return tokens;
    }

    public static List<String> allTokens(String input, String startDelimiter, String endDelimiter, boolean distinct) {
        List<String> tokens = StringUtils.allTokens(input, startDelimiter, endDelimiter);
        if (distinct) {
            return new ArrayList<String>(new LinkedHashSet<String>(tokens));
        }
        return tokens;
    }
}

