/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi.impl;

import com.ullink.slack.simpleslackapi.ChannelHistoryModule;
import com.ullink.slack.simpleslackapi.SlackMessageHandle;
import com.ullink.slack.simpleslackapi.SlackSession;
import com.ullink.slack.simpleslackapi.events.ReactionAdded;
import com.ullink.slack.simpleslackapi.events.ReactionRemoved;
import com.ullink.slack.simpleslackapi.events.SlackMessagePosted;
import com.ullink.slack.simpleslackapi.impl.SlackJSONMessageParser;
import com.ullink.slack.simpleslackapi.listeners.ReactionAddedListener;
import com.ullink.slack.simpleslackapi.listeners.ReactionRemovedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackMessagePostedListener;
import com.ullink.slack.simpleslackapi.replies.GenericSlackReply;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.TemporalUnit;

public class ChannelHistoryModuleImpl
implements ChannelHistoryModule {
    private final SlackSession session;
    private static final String FETCH_CHANNEL_HISTORY_COMMAND = "channels.history";

    public ChannelHistoryModuleImpl(SlackSession session) {
        this.session = session;
    }

    @Override
    public List<SlackMessagePosted> fetchHistoryOfChannel(String channelId) {
        return this.fetchHistoryOfChannel(channelId, null, -1);
    }

    @Override
    public List<SlackMessagePosted> fetchHistoryOfChannel(String channelId, LocalDate day) {
        return this.fetchHistoryOfChannel(channelId, day, -1);
    }

    @Override
    public List<SlackMessagePosted> fetchHistoryOfChannel(String channelId, int numberOfMessages) {
        return this.fetchHistoryOfChannel(channelId, null, numberOfMessages);
    }

    @Override
    public List<SlackMessagePosted> fetchHistoryOfChannel(String channelId, LocalDate day, int numberOfMessages) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("channel", channelId);
        if (day != null) {
            ZonedDateTime start = ZonedDateTime.of((LocalDateTime)day.atStartOfDay(), (ZoneId)ZoneId.of((String)"UTC"));
            ZonedDateTime end = ZonedDateTime.of((LocalDateTime)day.atStartOfDay().plusDays(1L).minus(1L, (TemporalUnit)ChronoUnit.MILLIS), (ZoneId)ZoneId.of((String)"UTC"));
            params.put("oldest", this.convertDateToSlackTimestamp(start));
            params.put("latest", this.convertDateToSlackTimestamp(end));
        }
        if (numberOfMessages > -1) {
            params.put("count", String.valueOf(numberOfMessages));
        } else {
            params.put("count", String.valueOf(1000));
        }
        return this.fetchHistoryOfChannel(params);
    }

    private List<SlackMessagePosted> fetchHistoryOfChannel(Map<String, String> params) {
        SlackMessageHandle<GenericSlackReply> handle = this.session.postGenericSlackCommand(params, FETCH_CHANNEL_HISTORY_COMMAND);
        GenericSlackReply replyEv = handle.getReply();
        JSONObject answer = replyEv.getPlainAnswer();
        JSONArray events = (JSONArray)answer.get((Object)"messages");
        ArrayList<SlackMessagePosted> messages = new ArrayList<SlackMessagePosted>();
        if (events != null) {
            for (Object event : events) {
                if (((JSONObject)event).get((Object)"subtype") != null) continue;
                messages.add((SlackMessagePosted)SlackJSONMessageParser.decode(this.session, (JSONObject)event));
            }
        }
        return messages;
    }

    @Override
    public List<SlackMessagePosted> fetchUpdatingHistoryOfChannel(String channelId) {
        return this.fetchUpdatingHistoryOfChannel(channelId, null, -1);
    }

    @Override
    public List<SlackMessagePosted> fetchUpdatingHistoryOfChannel(String channelId, LocalDate day) {
        return this.fetchUpdatingHistoryOfChannel(channelId, day, -1);
    }

    @Override
    public List<SlackMessagePosted> fetchUpdatingHistoryOfChannel(String channelId, int numberOfMessages) {
        return this.fetchUpdatingHistoryOfChannel(channelId, null, numberOfMessages);
    }

    @Override
    public List<SlackMessagePosted> fetchUpdatingHistoryOfChannel(String channelId, LocalDate day, int numberOfMessages) {
        List<SlackMessagePosted> messages = this.fetchHistoryOfChannel(channelId, day, numberOfMessages);
        this.session.addReactionAddedListener(new ChannelHistoryReactionAddedListener(messages));
        this.session.addReactionRemovedListener(new ChannelHistoryReactionRemovedListener(messages));
        this.session.addMessagePostedListener(new ChannelHistoryMessagePostedListener(messages));
        return messages;
    }

    private String convertDateToSlackTimestamp(ZonedDateTime date) {
        return date.toInstant().toEpochMilli() / 1000L + ".123456";
    }

    public class ChannelHistoryMessagePostedListener
    implements SlackMessagePostedListener {
        List<SlackMessagePosted> messages = new ArrayList<SlackMessagePosted>();

        public ChannelHistoryMessagePostedListener(List<SlackMessagePosted> initialMessages) {
            this.messages = initialMessages;
        }

        @Override
        public void onEvent(SlackMessagePosted event, SlackSession session) {
            this.messages.add(event);
        }
    }

    public class ChannelHistoryReactionRemovedListener
    implements ReactionRemovedListener {
        List<SlackMessagePosted> messages = new ArrayList<SlackMessagePosted>();

        public ChannelHistoryReactionRemovedListener(List<SlackMessagePosted> initialMessages) {
            this.messages = initialMessages;
        }

        @Override
        public void onEvent(ReactionRemoved event, SlackSession session) {
            String emojiName = event.getEmojiName();
            for (SlackMessagePosted message : this.messages) {
                for (String reaction : message.getReactions().keySet()) {
                    if (!emojiName.equals(reaction)) continue;
                    int count = message.getReactions().get(emojiName);
                    if (count == 1) {
                        message.getReactions().remove(emojiName);
                    } else {
                        message.getReactions().put(emojiName, --count);
                    }
                    return;
                }
            }
        }
    }

    public class ChannelHistoryReactionAddedListener
    implements ReactionAddedListener {
        List<SlackMessagePosted> messages = new ArrayList<SlackMessagePosted>();

        public ChannelHistoryReactionAddedListener(List<SlackMessagePosted> initialMessages) {
            this.messages = initialMessages;
        }

        @Override
        public void onEvent(ReactionAdded event, SlackSession session) {
            String emojiName = event.getEmojiName();
            for (SlackMessagePosted message : this.messages) {
                for (String reaction : message.getReactions().keySet()) {
                    if (!emojiName.equals(reaction)) continue;
                    int count = message.getReactions().get(emojiName);
                    message.getReactions().put(emojiName, count++);
                    return;
                }
                message.getReactions().put(emojiName, 1);
            }
        }
    }
}

