/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi.impl;

import com.ullink.slack.simpleslackapi.SlackSession;
import com.ullink.slack.simpleslackapi.impl.GenericSlackReplyImpl;
import com.ullink.slack.simpleslackapi.impl.SlackChannelReplyImpl;
import com.ullink.slack.simpleslackapi.impl.SlackMessageReplyImpl;
import com.ullink.slack.simpleslackapi.impl.SlackUserPresenceReplyImpl;
import com.ullink.slack.simpleslackapi.replies.SlackChannelReply;
import com.ullink.slack.simpleslackapi.replies.SlackReply;
import org.json.simple.JSONObject;

class SlackJSONReplyParser {
    SlackJSONReplyParser() {
    }

    static SlackReply decode(JSONObject obj, SlackSession session) {
        Boolean ok = (Boolean)obj.get((Object)"ok");
        String presence = (String)obj.get((Object)"presence");
        if (presence != null) {
            return new SlackUserPresenceReplyImpl(ok, "active".equals(presence));
        }
        if (SlackJSONReplyParser.isMpim(obj) || SlackJSONReplyParser.isIm(obj) || SlackJSONReplyParser.isChannel(obj) || SlackJSONReplyParser.isGroup(obj)) {
            return SlackJSONReplyParser.buildSlackChannelReply(ok, obj, session);
        }
        if (SlackJSONReplyParser.isMessageReply(obj)) {
            Long replyTo = (Long)obj.get((Object)"reply_to");
            String timestamp = (String)obj.get((Object)"ts");
            return new SlackMessageReplyImpl(ok, obj, replyTo != null ? replyTo : -1L, timestamp);
        }
        return new GenericSlackReplyImpl(obj);
    }

    private static SlackChannelReply buildSlackChannelReply(Boolean ok, JSONObject obj, SlackSession session) {
        String id = (String)obj.get((Object)"id");
        if (id != null) {
            return new SlackChannelReplyImpl(ok, obj, session.findChannelById(id));
        }
        JSONObject channelObj = (JSONObject)obj.get((Object)"channel");
        id = (String)channelObj.get((Object)"id");
        return new SlackChannelReplyImpl(ok, obj, session.findChannelById(id));
    }

    private static boolean isMessageReply(JSONObject obj) {
        return obj.get((Object)"reply_to") != null;
    }

    private static boolean isMpim(JSONObject obj) {
        Boolean isMpim = (Boolean)obj.get((Object)"is_mpim");
        return isMpim != null && isMpim.equals(Boolean.TRUE);
    }

    private static boolean isIm(JSONObject obj) {
        Boolean isIm = (Boolean)obj.get((Object)"is_im");
        return isIm != null && isIm.equals(Boolean.TRUE);
    }

    private static boolean isChannel(JSONObject obj) {
        Object channel = obj.get((Object)"channel");
        return channel != null && channel instanceof JSONObject;
    }

    private static boolean isGroup(JSONObject obj) {
        Boolean isGroup = (Boolean)obj.get((Object)"is_group");
        return isGroup != null && isGroup.equals(Boolean.TRUE);
    }
}

