/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi;

import com.ullink.slack.simpleslackapi.SlackAction;
import com.ullink.slack.simpleslackapi.SlackField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SlackAttachment {
    private String title;
    private String titleLink;
    private String fallback;
    private String callback_id;
    private String text;
    private String pretext;
    private String thumb_url;
    private String author_name;
    private String author_link;
    private String author_icon;
    private String footer;
    private String footer_icon;
    private String image_url;
    private String color;
    private Map<String, String> miscRootFields;
    private List<SlackField> fields = new ArrayList<SlackField>();
    private List<SlackAction> actions = new ArrayList<SlackAction>();
    private List<String> markdown_in;

    public SlackAttachment() {
    }

    public SlackAttachment(String title, String fallback, String text, String pretext) {
        this.title = title;
        this.fallback = fallback;
        this.text = text;
        this.pretext = pretext;
    }

    public String toString() {
        return "SlackAttachment [title=" + this.title + ", fallback=" + this.fallback + ", text=" + this.text + ", pretext=" + this.pretext + ", fields=" + this.fields + "]";
    }

    public void addField(String title, String value, boolean isShort) {
        this.fields.add(new SlackField(title, value, isShort));
    }

    public void addAction(String name, String value, String text, String type) {
        this.actions.add(new SlackAction(name, text, type, value));
    }

    public void addAction(SlackAction action) {
        this.actions.add(action);
    }

    public void addMarkdownIn(String value) {
        if (this.markdown_in == null) {
            this.markdown_in = new ArrayList<String>();
        }
        this.markdown_in.add(value);
    }

    public void addMiscField(String key, String value) {
        if (this.miscRootFields == null) {
            this.miscRootFields = new HashMap<String, String>();
        }
        this.miscRootFields.put(key, value);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTitleLink(String titleLink) {
        this.titleLink = titleLink;
    }

    public void setFallback(String fallback) {
        this.fallback = fallback;
    }

    public void setCallbackId(String callback_id) {
        this.callback_id = callback_id;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setPretext(String pretext) {
        this.pretext = pretext;
    }

    public void setThumbUrl(String thumb_url) {
        this.thumb_url = thumb_url;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setImageUrl(String image_url) {
        this.image_url = image_url;
    }

    public void setAuthorName(String author_name) {
        this.author_name = author_name;
    }

    public void setAuthorLink(String author_link) {
        this.author_link = author_link;
    }

    public void setAuthorIcon(String author_icon) {
        this.author_icon = author_icon;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public void setFooterIcon(String footer_icon) {
        this.footer_icon = footer_icon;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTitleLink() {
        return this.titleLink;
    }

    public String getFallback() {
        return this.fallback;
    }

    public String getCallbackId() {
        return this.callback_id;
    }

    public String getText() {
        return this.text;
    }

    public String getPretext() {
        return this.pretext;
    }

    public String getThumbUrl() {
        return this.thumb_url;
    }

    public String getColor() {
        return this.color;
    }

    public Map<String, String> getMiscRootFields() {
        return this.miscRootFields;
    }

    public List<SlackField> getFields() {
        return this.fields;
    }

    public List<SlackAction> getActions() {
        return this.actions;
    }

    public List<String> getMarkdown_in() {
        return this.markdown_in;
    }

    public String getImageUrl() {
        return this.image_url;
    }

    public String getAuthorName() {
        return this.author_name;
    }

    public String getAuthorLink() {
        return this.author_link;
    }

    public String getAuthorIcon() {
        return this.author_icon;
    }

    public String getFooter() {
        return this.footer;
    }

    public String getFooterIcon() {
        return this.footer_icon;
    }
}

