/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi;

import com.ullink.slack.simpleslackapi.SlackAttachment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SlackPreparedMessage {
    private final String message;
    private final boolean unfurl;
    private final boolean linkNames;
    private final SlackAttachment[] attachments;
    private final String threadTimestamp;
    private final boolean replyBroadcast;

    private SlackPreparedMessage(String message, boolean unfurl, boolean linkNames, SlackAttachment[] attachments, String threadTimestamp, boolean replyBroadcast) {
        this.message = message;
        this.unfurl = unfurl;
        this.linkNames = linkNames;
        this.attachments = attachments;
        this.threadTimestamp = threadTimestamp;
        this.replyBroadcast = replyBroadcast;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isUnfurl() {
        return this.unfurl;
    }

    public boolean isLinkNames() {
        return this.linkNames;
    }

    public SlackAttachment[] getAttachments() {
        return this.attachments;
    }

    public String getThreadTimestamp() {
        return this.threadTimestamp;
    }

    public boolean isReplyBroadcast() {
        return this.replyBroadcast;
    }

    public String toString() {
        return "SlackPreparedMessage{message='" + this.message + '\'' + ", unfurl=" + this.unfurl + ", attachments=" + Arrays.toString(this.attachments) + '}';
    }

    public static class Builder {
        String message;
        boolean unfurl;
        boolean linkNames;
        List<SlackAttachment> attachments = new ArrayList<SlackAttachment>();
        String threadTimestamp;
        boolean replyBroadcast;

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withUnfurl(boolean unfurl) {
            this.unfurl = unfurl;
            return this;
        }

        public Builder withLinkNames(boolean linkNames) {
            this.linkNames = linkNames;
            return this;
        }

        public Builder addAttachment(SlackAttachment attachment) {
            if (attachment != null) {
                this.attachments.add(attachment);
            }
            return this;
        }

        public Builder addAttachments(List<SlackAttachment> attachments) {
            if (attachments != null) {
                this.attachments.addAll(attachments);
            }
            return this;
        }

        public Builder withAttachments(List<SlackAttachment> attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder withThreadTimestamp(String threadTimestamp) {
            this.threadTimestamp = threadTimestamp;
            return this;
        }

        public Builder withReplyBroadcast(boolean replyBroadcast) {
            this.replyBroadcast = replyBroadcast;
            return this;
        }

        public SlackPreparedMessage build() {
            return new SlackPreparedMessage(this.message, this.unfurl, this.linkNames, this.attachments.toArray(new SlackAttachment[0]), this.threadTimestamp, this.replyBroadcast);
        }
    }
}

