/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi;

public class SlackChatConfiguration {
    private boolean asUser;
    private Avatar avatar = Avatar.DEFAULT;
    private String userName;
    private String avatarDescription;

    private SlackChatConfiguration() {
    }

    public boolean isAsUser() {
        return this.asUser;
    }

    public Avatar getAvatar() {
        return this.avatar;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getAvatarDescription() {
        return this.avatarDescription;
    }

    public SlackChatConfiguration asUser() {
        this.asUser = true;
        this.avatar = Avatar.DEFAULT;
        this.avatarDescription = null;
        return this;
    }

    public SlackChatConfiguration withIcon(String iconURL) {
        this.asUser = false;
        this.avatar = Avatar.ICON_URL;
        this.avatarDescription = iconURL;
        return this;
    }

    public SlackChatConfiguration withName(String name) {
        this.asUser = false;
        this.userName = name;
        return this;
    }

    public SlackChatConfiguration withEmoji(String emoji) {
        this.asUser = false;
        this.avatar = Avatar.EMOJI;
        this.avatarDescription = emoji;
        return this;
    }

    public static SlackChatConfiguration getConfiguration() {
        return new SlackChatConfiguration();
    }

    public static enum Avatar {
        DEFAULT,
        EMOJI,
        ICON_URL;

    }
}

