/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi.events;

import com.ullink.slack.simpleslackapi.SlackAttachment;
import com.ullink.slack.simpleslackapi.SlackBot;
import com.ullink.slack.simpleslackapi.SlackChannel;
import com.ullink.slack.simpleslackapi.SlackFile;
import com.ullink.slack.simpleslackapi.SlackUser;
import com.ullink.slack.simpleslackapi.events.SlackEvent;
import com.ullink.slack.simpleslackapi.events.SlackEventType;
import java.util.ArrayList;
import java.util.Map;
import lombok.NonNull;

public class SlackMessagePosted
implements SlackEvent {
    @NonNull
    private String messageContent;
    @NonNull
    private SlackBot bot;
    @NonNull
    private SlackUser user;
    @NonNull
    private SlackChannel channel;
    @NonNull
    private String timestamp;
    @NonNull
    private MessageSubType msgSubType;
    private String threadTimestamp;
    private SlackFile slackFile;
    private String jsonSource;
    private Map<String, Integer> reactions;
    private ArrayList<SlackAttachment> attachments;

    public SlackMessagePosted(String messageContent, SlackBot bot, SlackUser user, SlackChannel channel, String timestamp, MessageSubType msgSubType) {
        this.channel = channel;
        this.messageContent = messageContent;
        this.user = user;
        this.bot = bot;
        this.timestamp = timestamp;
        this.msgSubType = msgSubType;
    }

    public SlackMessagePosted(String messageContent, SlackBot bot, SlackUser user, SlackChannel channel, String timestamp, SlackFile slackFile, String jsonSource, MessageSubType msgSubType, String threadTimestamp) {
        this.channel = channel;
        this.messageContent = messageContent;
        this.user = user;
        this.bot = bot;
        this.timestamp = timestamp;
        this.jsonSource = jsonSource;
        this.slackFile = slackFile;
        this.msgSubType = msgSubType;
        this.threadTimestamp = threadTimestamp;
    }

    public String toString() {
        return "SlackMessagePosted{messageContent=" + this.messageContent + ", user=" + this.user + ", bot=" + this.bot + ", channel=" + this.channel + ", timestamp=" + this.timestamp + ", reactions=" + this.reactions + '}';
    }

    public String getJsonSource() {
        return this.jsonSource;
    }

    public SlackFile getSlackFile() {
        return this.slackFile;
    }

    public String getMessageContent() {
        return this.messageContent;
    }

    public SlackUser getSender() {
        return this.user;
    }

    public SlackBot getBot() {
        return this.bot;
    }

    public SlackChannel getChannel() {
        return this.channel;
    }

    public String getTimeStamp() {
        return this.timestamp;
    }

    @Override
    public SlackEventType getEventType() {
        return SlackEventType.SLACK_MESSAGE_POSTED;
    }

    public Map<String, Integer> getReactions() {
        return this.reactions;
    }

    public void setReactions(Map<String, Integer> reactions) {
        this.reactions = reactions;
    }

    public void setAttachments(ArrayList<SlackAttachment> attachments) {
        this.attachments = attachments;
    }

    public int getTotalCountOfReactions() {
        return this.reactions == null ? 0 : this.reactions.size();
    }

    public MessageSubType getMessageSubType() {
        return this.msgSubType;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public ArrayList<SlackAttachment> getAttachments() {
        return this.attachments;
    }

    public String getThreadTimestamp() {
        return this.threadTimestamp;
    }

    @NonNull
    public SlackUser getUser() {
        return this.user;
    }

    @NonNull
    public MessageSubType getMsgSubType() {
        return this.msgSubType;
    }

    public void setMessageContent(@NonNull String messageContent) {
        if (messageContent == null) {
            throw new NullPointerException("messageContent");
        }
        this.messageContent = messageContent;
    }

    public void setBot(@NonNull SlackBot bot) {
        if (bot == null) {
            throw new NullPointerException("bot");
        }
        this.bot = bot;
    }

    public void setUser(@NonNull SlackUser user) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        this.user = user;
    }

    public void setChannel(@NonNull SlackChannel channel) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        this.channel = channel;
    }

    public void setTimestamp(@NonNull String timestamp) {
        if (timestamp == null) {
            throw new NullPointerException("timestamp");
        }
        this.timestamp = timestamp;
    }

    public void setMsgSubType(@NonNull MessageSubType msgSubType) {
        if (msgSubType == null) {
            throw new NullPointerException("msgSubType");
        }
        this.msgSubType = msgSubType;
    }

    public void setThreadTimestamp(String threadTimestamp) {
        this.threadTimestamp = threadTimestamp;
    }

    public void setSlackFile(SlackFile slackFile) {
        this.slackFile = slackFile;
    }

    public void setJsonSource(String jsonSource) {
        this.jsonSource = jsonSource;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SlackMessagePosted)) {
            return false;
        }
        SlackMessagePosted other = (SlackMessagePosted)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$messageContent = this.getMessageContent();
        String other$messageContent = other.getMessageContent();
        if (this$messageContent == null ? other$messageContent != null : !this$messageContent.equals(other$messageContent)) {
            return false;
        }
        SlackBot this$bot = this.getBot();
        SlackBot other$bot = other.getBot();
        if (this$bot == null ? other$bot != null : !this$bot.equals(other$bot)) {
            return false;
        }
        SlackUser this$user = this.getUser();
        SlackUser other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        SlackChannel this$channel = this.getChannel();
        SlackChannel other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        String this$timestamp = this.getTimeStamp();
        String other$timestamp = other.getTimeStamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
            return false;
        }
        MessageSubType this$msgSubType = this.getMsgSubType();
        MessageSubType other$msgSubType = other.getMsgSubType();
        if (this$msgSubType == null ? other$msgSubType != null : !((Object)((Object)this$msgSubType)).equals((Object)other$msgSubType)) {
            return false;
        }
        String this$threadTimestamp = this.getThreadTimestamp();
        String other$threadTimestamp = other.getThreadTimestamp();
        if (this$threadTimestamp == null ? other$threadTimestamp != null : !this$threadTimestamp.equals(other$threadTimestamp)) {
            return false;
        }
        SlackFile this$slackFile = this.getSlackFile();
        SlackFile other$slackFile = other.getSlackFile();
        if (this$slackFile == null ? other$slackFile != null : !this$slackFile.equals(other$slackFile)) {
            return false;
        }
        String this$jsonSource = this.getJsonSource();
        String other$jsonSource = other.getJsonSource();
        if (this$jsonSource == null ? other$jsonSource != null : !this$jsonSource.equals(other$jsonSource)) {
            return false;
        }
        Map<String, Integer> this$reactions = this.getReactions();
        Map<String, Integer> other$reactions = other.getReactions();
        if (this$reactions == null ? other$reactions != null : !((Object)this$reactions).equals(other$reactions)) {
            return false;
        }
        ArrayList<SlackAttachment> this$attachments = this.getAttachments();
        ArrayList<SlackAttachment> other$attachments = other.getAttachments();
        return !(this$attachments == null ? other$attachments != null : !((Object)this$attachments).equals(other$attachments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SlackMessagePosted;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $messageContent = this.getMessageContent();
        result = result * 59 + ($messageContent == null ? 43 : $messageContent.hashCode());
        SlackBot $bot = this.getBot();
        result = result * 59 + ($bot == null ? 43 : $bot.hashCode());
        SlackUser $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        SlackChannel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        String $timestamp = this.getTimeStamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        MessageSubType $msgSubType = this.getMsgSubType();
        result = result * 59 + ($msgSubType == null ? 43 : ((Object)((Object)$msgSubType)).hashCode());
        String $threadTimestamp = this.getThreadTimestamp();
        result = result * 59 + ($threadTimestamp == null ? 43 : $threadTimestamp.hashCode());
        SlackFile $slackFile = this.getSlackFile();
        result = result * 59 + ($slackFile == null ? 43 : $slackFile.hashCode());
        String $jsonSource = this.getJsonSource();
        result = result * 59 + ($jsonSource == null ? 43 : $jsonSource.hashCode());
        Map<String, Integer> $reactions = this.getReactions();
        result = result * 59 + ($reactions == null ? 43 : ((Object)$reactions).hashCode());
        ArrayList<SlackAttachment> $attachments = this.getAttachments();
        result = result * 59 + ($attachments == null ? 43 : ((Object)$attachments).hashCode());
        return result;
    }

    public static enum MessageSubType {
        BOT_MESSAGE("bot_message"),
        CHANNEL_ARCHIVE("channel_archive"),
        CHANNEL_JOIN("channel_join"),
        CHANNEL_LEAVE("channel_leave"),
        CHANNEL_LEFT("channel_left"),
        CHANNEL_NAME("channel_name"),
        CHANNEL_PURPOSE("channel_purpose"),
        CHANNEL_TOPIC("channel_topic"),
        CHANNEL_UNARCHIVE("channel_unarchive"),
        FILE_COMMENT("file_comment"),
        FILE_MENTION("file_mention"),
        FILE_SHARE("file_share"),
        GROUP_JOIN("group_join"),
        GROUP_LEAVE("group_leave"),
        GROUP_NAME("group_name"),
        GROUP_PURPOSE("group_purpose"),
        GROUP_TOPIC("group_topic"),
        GROUP_UNARCHIVE("group_unarchive"),
        ME_MESSAGE("me_message"),
        MESSAGE_CHANGED("message_changed"),
        MESSAGE_DELETED("message_deleted"),
        PINNED_ITEM("pinned_item"),
        UNPINNED_ITEM("unpinned_item"),
        MESSAGE_REPLIED("message_replied"),
        UNKNOWN("");

        String code;

        private MessageSubType(String code) {
            this.code = code;
        }

        public static final MessageSubType fromCode(String code) {
            for (MessageSubType subType : MessageSubType.values()) {
                if (!subType.code.equals(code)) continue;
                return subType;
            }
            return UNKNOWN;
        }

        public String getCode() {
            return this.code;
        }
    }
}

