/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi.impl;

import com.ullink.slack.simpleslackapi.SlackAttachment;
import com.ullink.slack.simpleslackapi.SlackBot;
import com.ullink.slack.simpleslackapi.SlackChannel;
import com.ullink.slack.simpleslackapi.SlackChatConfiguration;
import com.ullink.slack.simpleslackapi.SlackIntegration;
import com.ullink.slack.simpleslackapi.SlackMessageHandle;
import com.ullink.slack.simpleslackapi.SlackPersona;
import com.ullink.slack.simpleslackapi.SlackPreparedMessage;
import com.ullink.slack.simpleslackapi.SlackSession;
import com.ullink.slack.simpleslackapi.SlackTeam;
import com.ullink.slack.simpleslackapi.SlackUser;
import com.ullink.slack.simpleslackapi.listeners.PinAddedListener;
import com.ullink.slack.simpleslackapi.listeners.PinRemovedListener;
import com.ullink.slack.simpleslackapi.listeners.PresenceChangeListener;
import com.ullink.slack.simpleslackapi.listeners.ReactionAddedListener;
import com.ullink.slack.simpleslackapi.listeners.ReactionRemovedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackChannelArchivedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackChannelCreatedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackChannelDeletedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackChannelJoinedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackChannelLeftListener;
import com.ullink.slack.simpleslackapi.listeners.SlackChannelRenamedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackChannelUnarchivedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackConnectedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackDisconnectedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackGroupJoinedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackMessageDeletedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackMessagePostedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackMessageUpdatedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackTeamJoinListener;
import com.ullink.slack.simpleslackapi.listeners.SlackUserChangeListener;
import com.ullink.slack.simpleslackapi.listeners.UserTypingListener;
import com.ullink.slack.simpleslackapi.replies.SlackMessageReply;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

abstract class AbstractSlackSessionImpl
implements SlackSession {
    protected Map<String, SlackChannel> channels = new ConcurrentHashMap<String, SlackChannel>();
    protected Map<String, SlackUser> users = new ConcurrentHashMap<String, SlackUser>();
    protected Map<String, SlackIntegration> integrations = new ConcurrentHashMap<String, SlackIntegration>();
    protected SlackPersona sessionPersona;
    protected SlackTeam team;
    protected List<SlackChannelArchivedListener> channelArchiveListener = new CopyOnWriteArrayList<SlackChannelArchivedListener>();
    protected List<SlackChannelCreatedListener> channelCreateListener = new CopyOnWriteArrayList<SlackChannelCreatedListener>();
    protected List<SlackChannelDeletedListener> channelDeleteListener = new CopyOnWriteArrayList<SlackChannelDeletedListener>();
    protected List<SlackChannelRenamedListener> channelRenamedListener = new CopyOnWriteArrayList<SlackChannelRenamedListener>();
    protected List<SlackChannelUnarchivedListener> channelUnarchiveListener = new CopyOnWriteArrayList<SlackChannelUnarchivedListener>();
    protected List<SlackChannelJoinedListener> channelJoinedListener = new CopyOnWriteArrayList<SlackChannelJoinedListener>();
    protected List<SlackChannelLeftListener> channelLeftListener = new CopyOnWriteArrayList<SlackChannelLeftListener>();
    protected List<SlackGroupJoinedListener> groupJoinedListener = new CopyOnWriteArrayList<SlackGroupJoinedListener>();
    protected List<SlackMessageDeletedListener> messageDeletedListener = new CopyOnWriteArrayList<SlackMessageDeletedListener>();
    protected List<SlackMessagePostedListener> messagePostedListener = new CopyOnWriteArrayList<SlackMessagePostedListener>();
    protected List<SlackMessageUpdatedListener> messageUpdatedListener = new CopyOnWriteArrayList<SlackMessageUpdatedListener>();
    protected List<SlackConnectedListener> slackConnectedListener = new CopyOnWriteArrayList<SlackConnectedListener>();
    protected List<ReactionAddedListener> reactionAddedListener = new CopyOnWriteArrayList<ReactionAddedListener>();
    protected List<ReactionRemovedListener> reactionRemovedListener = new CopyOnWriteArrayList<ReactionRemovedListener>();
    protected List<SlackUserChangeListener> slackUserChangeListener = new CopyOnWriteArrayList<SlackUserChangeListener>();
    protected List<SlackTeamJoinListener> slackTeamJoinListener = new CopyOnWriteArrayList<SlackTeamJoinListener>();
    protected List<PinAddedListener> pinAddedListener = new CopyOnWriteArrayList<PinAddedListener>();
    protected List<PinRemovedListener> pinRemovedListener = new CopyOnWriteArrayList<PinRemovedListener>();
    protected List<PresenceChangeListener> presenceChangeListener = new CopyOnWriteArrayList<PresenceChangeListener>();
    protected List<SlackDisconnectedListener> slackDisconnectedListener = new CopyOnWriteArrayList<SlackDisconnectedListener>();
    protected List<UserTypingListener> userTypingListener = new CopyOnWriteArrayList<UserTypingListener>();
    static final SlackChatConfiguration DEFAULT_CONFIGURATION = SlackChatConfiguration.getConfiguration().asUser();
    static final boolean DEFAULT_UNFURL = true;

    AbstractSlackSessionImpl() {
    }

    @Override
    public SlackTeam getTeam() {
        return this.team;
    }

    @Override
    public Collection<SlackChannel> getChannels() {
        return new ArrayList<SlackChannel>(this.channels.values());
    }

    @Override
    public Collection<SlackUser> getUsers() {
        return new ArrayList<SlackUser>(this.users.values());
    }

    @Override
    public Collection<SlackIntegration> getIntegrations() {
        return new ArrayList<SlackIntegration>(this.integrations.values());
    }

    @Override
    @Deprecated
    public Collection<SlackBot> getBots() {
        ArrayList<SlackBot> toReturn = new ArrayList<SlackBot>();
        for (SlackUser user : this.users.values()) {
            if (!user.isBot()) continue;
            toReturn.add(user);
        }
        return toReturn;
    }

    @Override
    public SlackChannel findChannelByName(String channelName) {
        for (SlackChannel channel : this.channels.values()) {
            if (!channelName.equals(channel.getName())) continue;
            return channel;
        }
        return null;
    }

    @Override
    public SlackChannel findChannelById(String channelId) {
        SlackChannel toReturn = this.channels.get(channelId);
        if (toReturn == null && channelId != null && channelId.startsWith("D")) {
            toReturn = new SlackChannel(channelId, "", "", "", true, false, false);
        }
        return toReturn;
    }

    @Override
    public SlackUser findUserById(String userId) {
        return this.users.get(userId);
    }

    @Override
    public SlackUser findUserByUserName(String userName) {
        for (SlackUser user : this.users.values()) {
            if (!userName.equals(user.getUserName())) continue;
            return user;
        }
        return null;
    }

    @Override
    public SlackUser findUserByEmail(String userMail) {
        for (SlackUser user : this.users.values()) {
            if (!userMail.equals(user.getUserMail())) continue;
            return user;
        }
        return null;
    }

    @Override
    public SlackIntegration findIntegrationById(String integrationId) {
        return this.integrations.get(integrationId);
    }

    @Override
    public SlackPersona sessionPersona() {
        return this.sessionPersona;
    }

    @Override
    @Deprecated
    public SlackBot findBotById(String botId) {
        return this.users.get(botId);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessage(SlackChannel channel, String message, SlackAttachment attachment) {
        return this.sendMessage(channel, message, attachment, DEFAULT_CONFIGURATION);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessage(SlackChannel channel, String message) {
        return this.sendMessage(channel, message, true);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessage(SlackChannel channel, String message, boolean unfurl) {
        SlackPreparedMessage preparedMessage = new SlackPreparedMessage.Builder().withMessage(message).withUnfurl(unfurl).build();
        return this.sendMessage(channel, preparedMessage, DEFAULT_CONFIGURATION);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessage(SlackChannel channel, String message, SlackAttachment attachment, boolean unfurl) {
        return this.sendMessage(channel, message, attachment, DEFAULT_CONFIGURATION, unfurl);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessage(SlackChannel channel, String message, SlackAttachment attachment, SlackChatConfiguration chatConfiguration) {
        return this.sendMessage(channel, message, attachment, chatConfiguration, true);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessage(SlackChannel channel, SlackPreparedMessage preparedMessage) {
        return this.sendMessage(channel, preparedMessage, DEFAULT_CONFIGURATION);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessage(SlackChannel channel, String message, SlackAttachment attachment, SlackChatConfiguration chatConfiguration, boolean unfurl) {
        SlackPreparedMessage preparedMessage = new SlackPreparedMessage.Builder().withMessage(message).withUnfurl(unfurl).addAttachment(attachment).build();
        return this.sendMessage(channel, preparedMessage, chatConfiguration);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendEphemeralMessage(SlackChannel channel, SlackUser user, SlackPreparedMessage preparedMessage) {
        return this.sendEphemeralMessage(channel, user, preparedMessage, DEFAULT_CONFIGURATION);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendEphemeralMessage(SlackChannel channel, SlackUser user, String message, SlackAttachment attachment, SlackChatConfiguration chatConfiguration, boolean unfurl) {
        SlackPreparedMessage preparedMessage = new SlackPreparedMessage.Builder().withMessage(message).withUnfurl(unfurl).addAttachment(attachment).build();
        return this.sendEphemeralMessage(channel, user, preparedMessage, chatConfiguration);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendEphemeralMessage(SlackChannel channel, SlackUser user, String message, SlackAttachment attachment, SlackChatConfiguration chatConfiguration) {
        return this.sendEphemeralMessage(channel, user, message, attachment, chatConfiguration, true);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendEphemeralMessage(SlackChannel channel, SlackUser user, String message, SlackAttachment attachment, boolean unfurl) {
        return this.sendEphemeralMessage(channel, user, message, attachment, DEFAULT_CONFIGURATION, unfurl);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendEphemeralMessage(SlackChannel channel, SlackUser user, String message, SlackAttachment attachment) {
        return this.sendEphemeralMessage(channel, user, message, attachment, DEFAULT_CONFIGURATION);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendEphemeralMessage(SlackChannel channel, SlackUser user, String message, boolean unfurl) {
        SlackPreparedMessage preparedMessage = new SlackPreparedMessage.Builder().withMessage(message).withUnfurl(unfurl).build();
        return this.sendEphemeralMessage(channel, user, preparedMessage, DEFAULT_CONFIGURATION);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendEphemeralMessage(SlackChannel channel, SlackUser user, String message) {
        return this.sendEphemeralMessage(channel, user, message, true);
    }

    @Override
    public void addChannelArchivedListener(SlackChannelArchivedListener listener) {
        this.channelArchiveListener.add(listener);
    }

    @Override
    public void removeChannelArchivedListener(SlackChannelArchivedListener listener) {
        this.channelArchiveListener.remove(listener);
    }

    @Override
    public void addChannelCreatedListener(SlackChannelCreatedListener listener) {
        this.channelCreateListener.add(listener);
    }

    @Override
    public void removeChannelCreatedListener(SlackChannelCreatedListener listener) {
        this.channelCreateListener.remove(listener);
    }

    @Override
    public void addChannelDeletedListener(SlackChannelDeletedListener listener) {
        this.channelDeleteListener.add(listener);
    }

    @Override
    public void removeChannelDeletedListener(SlackChannelDeletedListener listener) {
        this.channelDeleteListener.remove(listener);
    }

    @Override
    public void addChannelRenamedListener(SlackChannelRenamedListener listener) {
        this.channelRenamedListener.add(listener);
    }

    @Override
    public void removeChannelRenamedListener(SlackChannelRenamedListener listener) {
        this.channelRenamedListener.remove(listener);
    }

    @Override
    public void addChannelUnarchivedListener(SlackChannelUnarchivedListener listener) {
        this.channelUnarchiveListener.add(listener);
    }

    @Override
    public void removeChannelUnarchivedListener(SlackChannelUnarchivedListener listener) {
        this.channelUnarchiveListener.remove(listener);
    }

    @Override
    public void addMessageDeletedListener(SlackMessageDeletedListener listener) {
        this.messageDeletedListener.add(listener);
    }

    @Override
    public void removeMessageDeletedListener(SlackMessageDeletedListener listener) {
        this.messageDeletedListener.remove(listener);
    }

    @Override
    public void addMessagePostedListener(SlackMessagePostedListener listener) {
        this.messagePostedListener.add(listener);
    }

    @Override
    public void removeMessagePostedListener(SlackMessagePostedListener listener) {
        this.messagePostedListener.remove(listener);
    }

    @Override
    public void addMessageUpdatedListener(SlackMessageUpdatedListener listener) {
        this.messageUpdatedListener.add(listener);
    }

    @Override
    public void removeMessageUpdatedListener(SlackMessageUpdatedListener listener) {
        this.messageUpdatedListener.remove(listener);
    }

    @Override
    public void addChannelJoinedListener(SlackChannelJoinedListener listener) {
        this.channelJoinedListener.add(listener);
    }

    @Override
    public void removeChannelJoinedListener(SlackChannelJoinedListener listener) {
        this.channelJoinedListener.remove(listener);
    }

    @Override
    public void addChannelLeftListener(SlackChannelLeftListener listener) {
        this.channelLeftListener.add(listener);
    }

    @Override
    public void removeChannelLeftListener(SlackChannelLeftListener listener) {
        this.channelLeftListener.remove(listener);
    }

    @Override
    public void addGroupJoinedListener(SlackGroupJoinedListener listener) {
        this.groupJoinedListener.add(listener);
    }

    @Override
    public void removeGroupJoinedListener(SlackGroupJoinedListener listener) {
        this.groupJoinedListener.remove(listener);
    }

    @Override
    public void addSlackConnectedListener(SlackConnectedListener listener) {
        this.slackConnectedListener.add(listener);
    }

    @Override
    public void removeSlackConnectedListener(SlackConnectedListener listener) {
        this.slackConnectedListener.remove(listener);
    }

    @Override
    public void addSlackDisconnectedListener(SlackDisconnectedListener listener) {
        this.slackDisconnectedListener.add(listener);
    }

    @Override
    public void removeSlackDisconnectedListener(SlackDisconnectedListener listener) {
        this.slackDisconnectedListener.remove(listener);
    }

    @Override
    public void addReactionAddedListener(ReactionAddedListener listener) {
        this.reactionAddedListener.add(listener);
    }

    @Override
    public void removeReactionAddedListener(ReactionAddedListener listener) {
        this.reactionAddedListener.remove(listener);
    }

    @Override
    public void addReactionRemovedListener(ReactionRemovedListener listener) {
        this.reactionRemovedListener.add(listener);
    }

    @Override
    public void removeReactionRemovedListener(ReactionRemovedListener listener) {
        this.reactionRemovedListener.remove(listener);
    }

    @Override
    public void addSlackUserChangeListener(SlackUserChangeListener listener) {
        this.slackUserChangeListener.add(listener);
    }

    @Override
    public void removeSlackUserChangeListener(SlackUserChangeListener listener) {
        this.slackUserChangeListener.remove(listener);
    }

    @Override
    public void addSlackTeamJoinListener(SlackTeamJoinListener listener) {
        this.slackTeamJoinListener.add(listener);
    }

    @Override
    public void removeSlackTeamJoinListener(SlackTeamJoinListener listener) {
        this.slackTeamJoinListener.remove(listener);
    }

    @Override
    public void addPinAddedListener(PinAddedListener listener) {
        this.pinAddedListener.add(listener);
    }

    @Override
    public void removePinAddedListener(PinAddedListener listener) {
        this.pinAddedListener.remove(listener);
    }

    @Override
    public void addPinRemovedListener(PinRemovedListener listener) {
        this.pinRemovedListener.add(listener);
    }

    @Override
    public void removePinRemovedListener(PinRemovedListener listener) {
        this.pinRemovedListener.remove(listener);
    }

    @Override
    public void addPresenceChangeListener(PresenceChangeListener listener) {
        this.presenceChangeListener.add(listener);
    }

    @Override
    public void removePresenceChangeListener(PresenceChangeListener listener) {
        this.presenceChangeListener.remove(listener);
    }

    @Override
    public void addUserTypingListener(UserTypingListener listener) {
        this.userTypingListener.add(listener);
    }

    @Override
    public void removeUserTypingListener(UserTypingListener listener) {
        this.userTypingListener.remove(listener);
    }
}

