/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ullink.slack.simpleslackapi.SlackAttachment;
import com.ullink.slack.simpleslackapi.SlackChannel;
import com.ullink.slack.simpleslackapi.SlackChatConfiguration;
import com.ullink.slack.simpleslackapi.SlackMessageHandle;
import com.ullink.slack.simpleslackapi.SlackPersona;
import com.ullink.slack.simpleslackapi.SlackPreparedMessage;
import com.ullink.slack.simpleslackapi.SlackSession;
import com.ullink.slack.simpleslackapi.SlackUser;
import com.ullink.slack.simpleslackapi.WebSocketContainerProvider;
import com.ullink.slack.simpleslackapi.events.PinAdded;
import com.ullink.slack.simpleslackapi.events.PinRemoved;
import com.ullink.slack.simpleslackapi.events.PresenceChange;
import com.ullink.slack.simpleslackapi.events.ReactionAdded;
import com.ullink.slack.simpleslackapi.events.ReactionRemoved;
import com.ullink.slack.simpleslackapi.events.SlackChannelArchived;
import com.ullink.slack.simpleslackapi.events.SlackChannelCreated;
import com.ullink.slack.simpleslackapi.events.SlackChannelDeleted;
import com.ullink.slack.simpleslackapi.events.SlackChannelJoined;
import com.ullink.slack.simpleslackapi.events.SlackChannelLeft;
import com.ullink.slack.simpleslackapi.events.SlackChannelRenamed;
import com.ullink.slack.simpleslackapi.events.SlackChannelUnarchived;
import com.ullink.slack.simpleslackapi.events.SlackConnected;
import com.ullink.slack.simpleslackapi.events.SlackDisconnected;
import com.ullink.slack.simpleslackapi.events.SlackEvent;
import com.ullink.slack.simpleslackapi.events.SlackGroupJoined;
import com.ullink.slack.simpleslackapi.events.SlackMessageDeleted;
import com.ullink.slack.simpleslackapi.events.SlackMessagePosted;
import com.ullink.slack.simpleslackapi.events.SlackMessageUpdated;
import com.ullink.slack.simpleslackapi.events.UnknownEvent;
import com.ullink.slack.simpleslackapi.events.UserTyping;
import com.ullink.slack.simpleslackapi.events.userchange.SlackTeamJoin;
import com.ullink.slack.simpleslackapi.events.userchange.SlackUserChange;
import com.ullink.slack.simpleslackapi.events.userchange.SlackUserChangeEvent;
import com.ullink.slack.simpleslackapi.impl.AbstractSlackSessionImpl;
import com.ullink.slack.simpleslackapi.impl.DefaultWebSocketContainerProvider;
import com.ullink.slack.simpleslackapi.impl.SlackJSONAttachmentFormatter;
import com.ullink.slack.simpleslackapi.impl.SlackJSONMessageParser;
import com.ullink.slack.simpleslackapi.impl.SlackJSONParsingUtils;
import com.ullink.slack.simpleslackapi.impl.SlackJSONReplyParser;
import com.ullink.slack.simpleslackapi.impl.SlackJSONSessionStatusParser;
import com.ullink.slack.simpleslackapi.impl.SlackUserImpl;
import com.ullink.slack.simpleslackapi.listeners.PresenceChangeListener;
import com.ullink.slack.simpleslackapi.listeners.SlackChannelArchivedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackChannelCreatedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackChannelDeletedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackChannelRenamedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackChannelUnarchivedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackEventListener;
import com.ullink.slack.simpleslackapi.listeners.SlackTeamJoinListener;
import com.ullink.slack.simpleslackapi.listeners.SlackUserChangeListener;
import com.ullink.slack.simpleslackapi.replies.EmojiSlackReply;
import com.ullink.slack.simpleslackapi.replies.GenericSlackReply;
import com.ullink.slack.simpleslackapi.replies.ParsedSlackReply;
import com.ullink.slack.simpleslackapi.replies.SlackChannelReply;
import com.ullink.slack.simpleslackapi.replies.SlackMessageReply;
import com.ullink.slack.simpleslackapi.replies.SlackUserPresenceReply;
import com.ullink.slack.simpleslackapi.utils.ReaderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.Proxy;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SlackWebSocketSessionImpl
extends AbstractSlackSessionImpl
implements SlackSession,
MessageHandler.Whole<String> {
    private static final String SLACK_API_SCHEME = "https";
    private static final String SLACK_API_HOST = "slack.com";
    private static final String SLACK_API_PATH = "/api";
    private static final String SLACK_API_HTTPS_ROOT = "https://slack.com/api/";
    private static final String DIRECT_MESSAGE_OPEN_CHANNEL_COMMAND = "im.open";
    private static final String MULTIPARTY_DIRECT_MESSAGE_OPEN_CHANNEL_COMMAND = "mpim.open";
    private static final String CHANNELS_LEAVE_COMMAND = "channels.leave";
    private static final String CHANNELS_JOIN_COMMAND = "channels.join";
    private static final String CHANNELS_SET_TOPIC_COMMAND = "channels.setTopic";
    private static final String CHANNELS_INVITE_COMMAND = "channels.invite";
    private static final String CHANNELS_ARCHIVE_COMMAND = "channels.archive";
    private static final String CHANNELS_UNARCHIVE_COMMAND = "channels.unarchive";
    private static final String CHAT_POST_MESSAGE_COMMAND = "chat.postMessage";
    private static final String CHAT_POST_EPHEMERAL_COMMAND = "chat.postEphemeral";
    private static final String FILE_UPLOAD_COMMAND = "files.upload";
    private static final String CHAT_DELETE_COMMAND = "chat.delete";
    private static final String CHAT_UPDATE_COMMAND = "chat.update";
    private static final String REACTIONS_ADD_COMMAND = "reactions.add";
    private static final String REACTIONS_REMOVE_COMMAND = "reactions.remove";
    private static final String INVITE_USER_COMMAND = "users.admin.invite";
    private static final String SET_PERSONA_ACTIVE = "users.setPresence";
    private static final String LIST_EMOJI_COMMAND = "emoji.list";
    private static final String LIST_USERS = "users.list";
    private static final Logger LOGGER = LoggerFactory.getLogger(SlackWebSocketSessionImpl.class);
    private static final String SLACK_HTTPS_AUTH_URL = "https://slack.com/api/rtm.start?token=";
    private static final int DEFAULT_HEARTBEAT_IN_MILLIS = 30000;
    private volatile Session websocketSession;
    private String authToken;
    private String proxyAddress;
    private int proxyPort = -1;
    HttpHost proxyHost;
    private String proxyUser;
    private String proxyPassword;
    private volatile long lastPingSent;
    private volatile long lastPingAck;
    private AtomicLong messageId = new AtomicLong();
    private final boolean reconnectOnDisconnection;
    private volatile boolean wantDisconnect;
    private Thread connectionMonitoringThread;
    private EventDispatcher dispatcher = new EventDispatcher();
    private final long heartbeat;
    private WebSocketContainerProvider webSocketContainerProvider;
    private volatile String webSocketConnectionURL;
    private final PresenceChangeListener INTERNAL_PRESENCE_CHANGE_LISTENER = new PresenceChangeListener(){

        @Override
        public void onEvent(PresenceChange event, SlackSession session) {
            SlackUser user = (SlackUser)SlackWebSocketSessionImpl.this.users.get(event.getUserId());
            SlackUserImpl newUser = new SlackUserImpl(user.getId(), user.getUserName(), user.getRealName(), user.getUserMail(), user.getUserSkype(), user.getUserTitle(), user.getUserPhone(), user.isDeleted(), user.isAdmin(), user.isOwner(), user.isPrimaryOwner(), user.isRestricted(), user.isUltraRestricted(), user.isBot(), user.getTimeZone(), user.getTimeZoneLabel(), user.getTimeZoneOffset(), event.getPresence());
            SlackWebSocketSessionImpl.this.users.put(event.getUserId(), newUser);
        }
    };
    private final SlackChannelArchivedListener INTERNAL_CHANNEL_ARCHIVE_LISTENER = new SlackChannelArchivedListener(){

        @Override
        public void onEvent(SlackChannelArchived event, SlackSession session) {
            SlackChannel channel = (SlackChannel)SlackWebSocketSessionImpl.this.channels.get(event.getSlackChannel().getId());
            SlackChannel newChannel = new SlackChannel(channel.getId(), channel.getName(), channel.getTopic(), channel.getPurpose(), channel.isDirect(), channel.isMember(), true);
            SlackWebSocketSessionImpl.this.channels.put(newChannel.getId(), newChannel);
        }
    };
    private final SlackChannelCreatedListener INTERNAL_CHANNEL_CREATED_LISTENER = new SlackChannelCreatedListener(){

        @Override
        public void onEvent(SlackChannelCreated event, SlackSession session) {
            SlackWebSocketSessionImpl.this.channels.put(event.getSlackChannel().getId(), event.getSlackChannel());
        }
    };
    private final SlackChannelDeletedListener INTERNAL_CHANNEL_DELETED_LISTENER = new SlackChannelDeletedListener(){

        @Override
        public void onEvent(SlackChannelDeleted event, SlackSession session) {
            SlackWebSocketSessionImpl.this.channels.remove(event.getSlackChannel().getId());
        }
    };
    private final SlackChannelRenamedListener INTERNAL_CHANNEL_RENAMED_LISTENER = new SlackChannelRenamedListener(){

        @Override
        public void onEvent(SlackChannelRenamed event, SlackSession session) {
            SlackChannel channel = (SlackChannel)SlackWebSocketSessionImpl.this.channels.get(event.getSlackChannel().getId());
            SlackChannel newChannel = new SlackChannel(channel.getId(), event.getNewName(), channel.getTopic(), channel.getPurpose(), channel.isDirect(), channel.isMember(), channel.isArchived());
            SlackWebSocketSessionImpl.this.channels.put(newChannel.getId(), newChannel);
        }
    };
    private final SlackChannelUnarchivedListener INTERNAL_CHANNEL_UNARCHIVED_LISTENER = new SlackChannelUnarchivedListener(){

        @Override
        public void onEvent(SlackChannelUnarchived event, SlackSession session) {
            SlackChannel channel = (SlackChannel)SlackWebSocketSessionImpl.this.channels.get(event.getSlackChannel().getId());
            SlackChannel newChannel = new SlackChannel(channel.getId(), channel.getName(), channel.getTopic(), channel.getPurpose(), channel.isDirect(), channel.isMember(), false);
            SlackWebSocketSessionImpl.this.channels.put(newChannel.getId(), newChannel);
        }
    };
    private final SlackTeamJoinListener INTERNAL_TEAM_JOIN_LISTENER = new SlackTeamJoinListener(){

        @Override
        public void onEvent(SlackTeamJoin event, SlackSession session) {
            SlackWebSocketSessionImpl.this.users.put(event.getUser().getId(), event.getUser());
        }
    };
    private final SlackUserChangeListener INTERNAL_USER_CHANGE_LISTENER = new SlackUserChangeListener(){

        @Override
        public void onEvent(SlackUserChange event, SlackSession session) {
            SlackWebSocketSessionImpl.this.users.put(event.getUser().getId(), event.getUser());
        }
    };

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessageToUser(SlackUser user, SlackPreparedMessage message) {
        SlackChannel iMChannel = this.getIMChannelForUser(user);
        return this.sendMessage(iMChannel, message);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessageToUser(SlackUser user, String message, SlackAttachment attachment) {
        SlackChannel iMChannel = this.getIMChannelForUser(user);
        return this.sendMessage(iMChannel, message, attachment, DEFAULT_CONFIGURATION);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessageToUser(String userName, String message, SlackAttachment attachment) {
        return this.sendMessageToUser(this.findUserByUserName(userName), message, attachment);
    }

    private List<SlackChannel> getAllIMChannels() {
        Collection<SlackChannel> allChannels = this.getChannels();
        ArrayList<SlackChannel> iMChannels = new ArrayList<SlackChannel>();
        for (SlackChannel channel : allChannels) {
            if (!channel.isDirect()) continue;
            iMChannels.add(channel);
        }
        return iMChannels;
    }

    private SlackChannel getIMChannelForUser(SlackUser user) {
        List<SlackChannel> imcs = this.getAllIMChannels();
        for (SlackChannel channel : imcs) {
            if (!channel.getMembers().contains(user)) continue;
            return channel;
        }
        SlackMessageHandle<SlackChannelReply> reply = this.openDirectMessageChannel(user);
        return reply.getReply().getSlackChannel();
    }

    SlackWebSocketSessionImpl(WebSocketContainerProvider webSocketContainerProvider, String authToken, boolean reconnectOnDisconnection, long heartbeat, TimeUnit unit) {
        this.authToken = authToken;
        this.reconnectOnDisconnection = reconnectOnDisconnection;
        this.heartbeat = heartbeat != 0L ? unit.toMillis(heartbeat) : 30000L;
        this.webSocketContainerProvider = webSocketContainerProvider != null ? webSocketContainerProvider : new DefaultWebSocketContainerProvider(null, -1, null, null);
        this.addInternalListeners();
    }

    SlackWebSocketSessionImpl(WebSocketContainerProvider webSocketContainerProvider, String authToken, Proxy.Type proxyType, String proxyAddress, int proxyPort, String proxyUser, String proxyPassword, boolean reconnectOnDisconnection, long heartbeat, TimeUnit unit) {
        this.authToken = authToken;
        if (proxyType != null && proxyType != Proxy.Type.DIRECT) {
            this.proxyAddress = proxyAddress;
            this.proxyPort = proxyPort;
            this.proxyHost = new HttpHost(proxyAddress, proxyPort);
            this.proxyUser = proxyUser;
            this.proxyPassword = proxyPassword;
        }
        this.reconnectOnDisconnection = reconnectOnDisconnection;
        this.heartbeat = heartbeat != 0L ? unit.toMillis(heartbeat) : 30000L;
        this.webSocketContainerProvider = webSocketContainerProvider != null ? webSocketContainerProvider : new DefaultWebSocketContainerProvider(this.proxyAddress, this.proxyPort, this.proxyUser, this.proxyPassword);
        this.addInternalListeners();
    }

    private void addInternalListeners() {
        this.addPresenceChangeListener(this.INTERNAL_PRESENCE_CHANGE_LISTENER);
        this.addChannelArchivedListener(this.INTERNAL_CHANNEL_ARCHIVE_LISTENER);
        this.addChannelCreatedListener(this.INTERNAL_CHANNEL_CREATED_LISTENER);
        this.addChannelDeletedListener(this.INTERNAL_CHANNEL_DELETED_LISTENER);
        this.addChannelRenamedListener(this.INTERNAL_CHANNEL_RENAMED_LISTENER);
        this.addChannelUnarchivedListener(this.INTERNAL_CHANNEL_UNARCHIVED_LISTENER);
        this.addSlackTeamJoinListener(this.INTERNAL_TEAM_JOIN_LISTENER);
        this.addSlackUserChangeListener(this.INTERNAL_USER_CHANGE_LISTENER);
    }

    @Override
    public void connect() throws IOException {
        this.wantDisconnect = false;
        this.connectImpl();
        LOGGER.debug("starting actions monitoring");
        this.startConnectionMonitoring();
    }

    @Override
    public void disconnect() {
        this.wantDisconnect = true;
        LOGGER.debug("Disconnecting from the Slack server");
        this.disconnectImpl();
        this.stopConnectionMonitoring();
    }

    public void reconnect() throws IOException {
        while (true) {
            if (!this.isConnected()) break;
            this.disconnectImpl();
        }
        this.connectImpl();
    }

    @Override
    public boolean isConnected() {
        return this.websocketSession != null && this.websocketSession.isOpen();
    }

    private void connectImpl() throws IOException {
        LOGGER.info("connecting to slack");
        HttpClient httpClient = this.getHttpClient();
        HttpGet request = new HttpGet(SLACK_HTTPS_AUTH_URL + this.authToken);
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        LOGGER.debug(response.getStatusLine().toString());
        String jsonResponse = this.consumeToString(response.getEntity().getContent());
        SlackJSONSessionStatusParser sessionParser = new SlackJSONSessionStatusParser(jsonResponse);
        sessionParser.parse();
        if (sessionParser.getError() != null) {
            LOGGER.error("Error during authentication : " + sessionParser.getError());
            throw new ConnectException(sessionParser.getError());
        }
        this.users = sessionParser.getUsers();
        this.integrations = sessionParser.getIntegrations();
        this.channels = sessionParser.getChannels();
        this.sessionPersona = sessionParser.getSessionPersona();
        this.team = sessionParser.getTeam();
        LOGGER.info("Team " + this.team.getId() + " : " + this.team.getName());
        LOGGER.info("Self " + this.sessionPersona.getId() + " : " + this.sessionPersona.getUserName());
        LOGGER.info(this.users.size() + " users found on this session");
        LOGGER.info(this.channels.size() + " channels found on this session");
        this.webSocketConnectionURL = sessionParser.getWebSocketURL();
        LOGGER.debug("retrieved websocket URL : " + this.webSocketConnectionURL);
        this.establishWebsocketConnection();
    }

    private void establishWebsocketConnection() throws IOException {
        this.lastPingSent = 0L;
        this.lastPingAck = 0L;
        WebSocketContainer client = this.webSocketContainerProvider.getWebSocketContainer();
        SlackWebSocketSessionImpl handler = this;
        LOGGER.debug("initiating actions to websocket");
        try {
            this.websocketSession = client.connectToServer((Object)new Endpoint((MessageHandler)handler){
                final /* synthetic */ MessageHandler val$handler;
                {
                    this.val$handler = messageHandler;
                }

                public void onOpen(Session session, EndpointConfig config) {
                    session.addMessageHandler(this.val$handler);
                }

                public void onError(Session session, Throwable thr) {
                    LOGGER.error("Endpoint#onError called", thr);
                }
            }, URI.create(this.webSocketConnectionURL));
        }
        catch (DeploymentException e) {
            LOGGER.error(e.toString());
            throw new IOException(e);
        }
        if (this.websocketSession == null) {
            throw new IOException("Unable to establish a connection to this websocket URL " + this.webSocketConnectionURL);
        }
        SlackConnected slackConnected = new SlackConnected(this.sessionPersona);
        this.dispatcher.dispatch(slackConnected);
        LOGGER.debug("websocket actions established");
        LOGGER.info("slack session ready");
    }

    private String consumeToString(InputStream content) throws IOException {
        int numread;
        InputStreamReader reader = new InputStreamReader(content, "UTF-8");
        StringBuffer buf = new StringBuffer();
        char[] data = new char[16384];
        while (0 <= (numread = reader.read(data))) {
            buf.append(data, 0, numread);
        }
        return buf.toString();
    }

    private void disconnectImpl() {
        if (this.websocketSession != null) {
            try {
                this.websocketSession.close();
            }
            catch (IOException slackDisconnected) {
            }
            finally {
                SlackDisconnected slackDisconnected = new SlackDisconnected(this.sessionPersona);
                this.dispatcher.dispatch(slackDisconnected);
                this.websocketSession = null;
            }
        }
    }

    private void startConnectionMonitoring() {
        this.connectionMonitoringThread = new Thread(){

            @Override
            public void run() {
                LOGGER.debug("monitoring thread started");
                block7: while (true) {
                    try {
                        while (true) {
                            Thread.sleep(SlackWebSocketSessionImpl.this.heartbeat);
                            if (SlackWebSocketSessionImpl.this.wantDisconnect) {
                                this.interrupt();
                            }
                            if (SlackWebSocketSessionImpl.this.lastPingSent != SlackWebSocketSessionImpl.this.lastPingAck || SlackWebSocketSessionImpl.this.websocketSession == null) {
                                LOGGER.warn("Connection lost...");
                                try {
                                    if (SlackWebSocketSessionImpl.this.websocketSession != null) {
                                        SlackWebSocketSessionImpl.this.websocketSession.close();
                                    }
                                }
                                catch (IOException e) {
                                    LOGGER.error("exception while trying to close the websocket ", (Throwable)e);
                                }
                                SlackWebSocketSessionImpl.this.websocketSession = null;
                                if (SlackWebSocketSessionImpl.this.reconnectOnDisconnection) {
                                    SlackWebSocketSessionImpl.this.reconnect();
                                    continue;
                                }
                                this.interrupt();
                                continue;
                            }
                            SlackWebSocketSessionImpl.this.lastPingSent = SlackWebSocketSessionImpl.this.getNextMessageId();
                            LOGGER.debug("sending ping " + SlackWebSocketSessionImpl.this.lastPingSent);
                            try {
                                if (SlackWebSocketSessionImpl.this.websocketSession.isOpen()) {
                                    SlackWebSocketSessionImpl.this.websocketSession.getBasicRemote().sendText("{\"type\":\"ping\",\"id\":" + SlackWebSocketSessionImpl.this.lastPingSent + "}");
                                    continue block7;
                                }
                                if (!SlackWebSocketSessionImpl.this.reconnectOnDisconnection) continue block7;
                                SlackWebSocketSessionImpl.this.reconnect();
                                continue block7;
                            }
                            catch (IllegalStateException e) {
                                LOGGER.warn("exception caught while using websocket ", (Throwable)e);
                                if (!SlackWebSocketSessionImpl.this.reconnectOnDisconnection) continue;
                                SlackWebSocketSessionImpl.this.reconnect();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        LOGGER.info("monitoring thread interrupted");
                    }
                    catch (IOException e) {
                        LOGGER.error("unexpected exception on monitoring thread ", (Throwable)e);
                        continue;
                    }
                    break;
                }
                LOGGER.debug("monitoring thread stopped");
            }
        };
        if (!this.wantDisconnect) {
            this.connectionMonitoringThread.start();
        }
    }

    private void stopConnectionMonitoring() {
        if (this.connectionMonitoringThread != null) {
            while (true) {
                try {
                    this.connectionMonitoringThread.interrupt();
                    this.connectionMonitoringThread.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessage(SlackChannel channel, SlackPreparedMessage preparedMessage, SlackChatConfiguration chatConfiguration) {
        if (channel == null) {
            throw new IllegalArgumentException("Channel can't be null");
        }
        SlackMessageHandle<SlackMessageReply> handle = new SlackMessageHandle<SlackMessageReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("channel", channel.getId());
        arguments.put("text", preparedMessage.getMessage());
        if (chatConfiguration.isAsUser()) {
            arguments.put("as_user", "true");
        }
        if (chatConfiguration.getAvatar() == SlackChatConfiguration.Avatar.ICON_URL) {
            arguments.put("icon_url", chatConfiguration.getAvatarDescription());
        }
        if (chatConfiguration.getAvatar() == SlackChatConfiguration.Avatar.EMOJI) {
            arguments.put("icon_emoji", chatConfiguration.getAvatarDescription());
        }
        if (chatConfiguration.getUserName() != null) {
            arguments.put("username", chatConfiguration.getUserName());
        }
        if (preparedMessage.getAttachments() != null && preparedMessage.getAttachments().length > 0) {
            arguments.put("attachments", SlackJSONAttachmentFormatter.encodeAttachments(preparedMessage.getAttachments()).toString());
        }
        if (!preparedMessage.isUnfurl()) {
            arguments.put("unfurl_links", "false");
            arguments.put("unfurl_media", "false");
        }
        if (preparedMessage.isLinkNames()) {
            arguments.put("link_names", "1");
        }
        if (preparedMessage.getThreadTimestamp() != null) {
            arguments.put("thread_ts", preparedMessage.getThreadTimestamp());
            if (preparedMessage.isReplyBroadcast()) {
                arguments.put("reply_broadcast", "true");
            }
        }
        this.postSlackCommand(arguments, CHAT_POST_MESSAGE_COMMAND, handle);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendEphemeralMessage(SlackChannel channel, SlackUser user, SlackPreparedMessage preparedMessage, SlackChatConfiguration chatConfiguration) {
        SlackMessageHandle<SlackMessageReply> handle = new SlackMessageHandle<SlackMessageReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("channel", channel.getId());
        arguments.put("text", preparedMessage.getMessage());
        arguments.put("user", user.getId());
        if (chatConfiguration.isAsUser()) {
            arguments.put("as_user", "true");
        }
        if (chatConfiguration.getAvatar() == SlackChatConfiguration.Avatar.ICON_URL) {
            arguments.put("icon_url", chatConfiguration.getAvatarDescription());
        }
        if (chatConfiguration.getAvatar() == SlackChatConfiguration.Avatar.EMOJI) {
            arguments.put("icon_emoji", chatConfiguration.getAvatarDescription());
        }
        if (chatConfiguration.getUserName() != null) {
            arguments.put("username", chatConfiguration.getUserName());
        }
        if (preparedMessage.getAttachments() != null && preparedMessage.getAttachments().length > 0) {
            arguments.put("attachments", SlackJSONAttachmentFormatter.encodeAttachments(preparedMessage.getAttachments()).toString());
        }
        if (!preparedMessage.isUnfurl()) {
            arguments.put("unfurl_links", "false");
            arguments.put("unfurl_media", "false");
        }
        if (preparedMessage.isLinkNames()) {
            arguments.put("link_names", "1");
        }
        if (preparedMessage.getThreadTimestamp() != null) {
            arguments.put("thread_ts", preparedMessage.getThreadTimestamp());
            if (preparedMessage.isReplyBroadcast()) {
                arguments.put("reply_broadcast", "true");
            }
        }
        this.postSlackCommand(arguments, CHAT_POST_EPHEMERAL_COMMAND, handle);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendFileToUser(String userName, byte[] data, String fileName) {
        return this.sendFileToUser(this.findUserByUserName(userName), data, fileName);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendFileToUser(SlackUser user, byte[] data, String fileName) {
        SlackChannel iMChannel = this.getIMChannelForUser(user);
        return this.sendFile(iMChannel, data, fileName);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendFile(SlackChannel channel, byte[] data, String fileName) {
        SlackMessageHandle<SlackMessageReply> handle = new SlackMessageHandle<SlackMessageReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("channels", channel.getId());
        arguments.put("filename", fileName);
        this.postSlackCommandWithFile(arguments, data, fileName, FILE_UPLOAD_COMMAND, handle);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendFile(SlackChannel channel, byte[] data, String fileName, String title, String initialComment) {
        SlackMessageHandle<SlackMessageReply> handle = new SlackMessageHandle<SlackMessageReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("channels", channel.getId());
        arguments.put("filename", fileName);
        arguments.put("title", title);
        arguments.put("initial_comment", initialComment);
        this.postSlackCommandWithFile(arguments, data, fileName, FILE_UPLOAD_COMMAND, handle);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> deleteMessage(String timeStamp, SlackChannel channel) {
        SlackMessageHandle<SlackMessageReply> handle = new SlackMessageHandle<SlackMessageReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("channel", channel.getId());
        arguments.put("ts", timeStamp);
        this.postSlackCommand(arguments, CHAT_DELETE_COMMAND, handle);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> updateMessage(String timeStamp, SlackChannel channel, String message) {
        SlackMessageHandle<SlackMessageReply> handle = new SlackMessageHandle<SlackMessageReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("ts", timeStamp);
        arguments.put("channel", channel.getId());
        arguments.put("text", message);
        this.postSlackCommand(arguments, CHAT_UPDATE_COMMAND, handle);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> updateMessage(String timeStamp, SlackChannel channel, String message, SlackAttachment[] attachments) {
        SlackMessageHandle<SlackMessageReply> handle = new SlackMessageHandle<SlackMessageReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("ts", timeStamp);
        arguments.put("channel", channel.getId());
        arguments.put("text", message);
        arguments.put("attachments", SlackJSONAttachmentFormatter.encodeAttachments(attachments).toString());
        this.postSlackCommand(arguments, CHAT_UPDATE_COMMAND, handle);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> addReactionToMessage(SlackChannel channel, String messageTimeStamp, String emojiCode) {
        SlackMessageHandle<SlackMessageReply> handle = new SlackMessageHandle<SlackMessageReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("channel", channel.getId());
        arguments.put("timestamp", messageTimeStamp);
        arguments.put("name", emojiCode);
        this.postSlackCommand(arguments, REACTIONS_ADD_COMMAND, handle);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> removeReactionFromMessage(SlackChannel channel, String messageTimeStamp, String emojiCode) {
        SlackMessageHandle<SlackMessageReply> handle = new SlackMessageHandle<SlackMessageReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("channel", channel.getId());
        arguments.put("timestamp", messageTimeStamp);
        arguments.put("name", emojiCode);
        this.postSlackCommand(arguments, REACTIONS_REMOVE_COMMAND, handle);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackChannelReply> joinChannel(String channelName) {
        SlackMessageHandle<SlackChannelReply> handle = new SlackMessageHandle<SlackChannelReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("name", channelName);
        this.postSlackCommand(arguments, CHANNELS_JOIN_COMMAND, handle);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackChannelReply> setChannelTopic(SlackChannel channel, String topic) {
        SlackMessageHandle<SlackChannelReply> handle = new SlackMessageHandle<SlackChannelReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("channel", channel.getId());
        arguments.put("topic", topic);
        this.postSlackCommand(arguments, CHANNELS_SET_TOPIC_COMMAND, handle);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackChannelReply> leaveChannel(SlackChannel channel) {
        SlackMessageHandle<SlackChannelReply> handle = new SlackMessageHandle<SlackChannelReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("channel", channel.getId());
        this.postSlackCommand(arguments, CHANNELS_LEAVE_COMMAND, handle);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackChannelReply> inviteToChannel(SlackChannel channel, SlackUser user) {
        SlackMessageHandle<SlackChannelReply> handle = new SlackMessageHandle<SlackChannelReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("channel", channel.getId());
        arguments.put("user", user.getId());
        this.postSlackCommand(arguments, CHANNELS_INVITE_COMMAND, handle);
        return handle;
    }

    @Override
    public SlackMessageHandle<ParsedSlackReply> archiveChannel(SlackChannel channel) {
        SlackMessageHandle<ParsedSlackReply> handle = new SlackMessageHandle<ParsedSlackReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("channel", channel.getId());
        this.postSlackCommand(arguments, CHANNELS_ARCHIVE_COMMAND, handle);
        return handle;
    }

    @Override
    public SlackMessageHandle<ParsedSlackReply> unarchiveChannel(SlackChannel channel) {
        SlackMessageHandle<ParsedSlackReply> handle = new SlackMessageHandle<ParsedSlackReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("channel", channel.getId());
        this.postSlackCommand(arguments, CHANNELS_UNARCHIVE_COMMAND, handle);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackChannelReply> openDirectMessageChannel(SlackUser user) {
        SlackMessageHandle<SlackChannelReply> handle = new SlackMessageHandle<SlackChannelReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("user", user.getId());
        this.postSlackCommand(arguments, DIRECT_MESSAGE_OPEN_CHANNEL_COMMAND, handle);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackChannelReply> openMultipartyDirectMessageChannel(SlackUser ... users) {
        SlackMessageHandle<SlackChannelReply> handle = new SlackMessageHandle<SlackChannelReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        StringBuilder strBuilder = new StringBuilder();
        for (int i = 0; i < users.length; ++i) {
            if (i != 0) {
                strBuilder.append(',');
            }
            strBuilder.append(users[i].getId());
        }
        arguments.put("users", strBuilder.toString());
        this.postSlackCommand(arguments, MULTIPARTY_DIRECT_MESSAGE_OPEN_CHANNEL_COMMAND, handle);
        if (!((SlackChannelReply)handle.getReply()).isOk()) {
            LOGGER.debug("Error occurred while performing command: '" + handle.getReply().getErrorMessage() + "'");
            return null;
        }
        return handle;
    }

    @Override
    public SlackMessageHandle<EmojiSlackReply> listEmoji() {
        SlackMessageHandle<EmojiSlackReply> handle = new SlackMessageHandle<EmojiSlackReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        this.postSlackCommand(arguments, LIST_EMOJI_COMMAND, handle);
        return handle;
    }

    @Override
    public void refetchUsers() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("presence", "1");
        SlackMessageHandle<GenericSlackReply> handle = this.postGenericSlackCommand(params, LIST_USERS);
        GenericSlackReply replyEv = handle.getReply();
        String answer = replyEv.getPlainAnswer();
        JsonParser parser = new JsonParser();
        JsonObject answerJson = parser.parse(answer).getAsJsonObject();
        JsonArray membersjson = answerJson.get("members").getAsJsonArray();
        HashMap<String, SlackUser> members = new HashMap<String, SlackUser>();
        if (membersjson != null) {
            for (JsonElement member : membersjson) {
                SlackUser user = SlackJSONParsingUtils.buildSlackUser(member.getAsJsonObject());
                members.put(user.getId(), user);
            }
        }
        this.users = members;
    }

    private void postSlackCommand(Map<String, String> params, String command, SlackMessageHandle handle) {
        HttpClient client = this.getHttpClient();
        HttpPost request = new HttpPost(SLACK_API_HTTPS_ROOT + command);
        ArrayList<BasicNameValuePair> nameValuePairList = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> arg : params.entrySet()) {
            nameValuePairList.add(new BasicNameValuePair(arg.getKey(), arg.getValue()));
        }
        try {
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairList, "UTF-8"));
            HttpResponse response = client.execute((HttpUriRequest)request);
            String jsonResponse = this.consumeToString(response.getEntity().getContent());
            LOGGER.debug("PostMessage return: " + jsonResponse);
            ParsedSlackReply reply = SlackJSONReplyParser.decode(this.parseObject(jsonResponse), this);
            handle.setReply(reply);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void postSlackCommandWithFile(Map<String, String> params, byte[] fileContent, String fileName, String command, SlackMessageHandle handle) {
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setScheme(SLACK_API_SCHEME).setHost(SLACK_API_HOST).setPath("/api/" + command);
        for (Map.Entry<String, String> arg : params.entrySet()) {
            uriBuilder.setParameter(arg.getKey(), arg.getValue());
        }
        HttpPost request = new HttpPost(uriBuilder.toString());
        HttpClient client = this.getHttpClient();
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        try {
            builder.addBinaryBody("file", fileContent, ContentType.DEFAULT_BINARY, fileName);
            request.setEntity(builder.build());
            HttpResponse response = client.execute((HttpUriRequest)request);
            String jsonResponse = ReaderUtils.readAll(new InputStreamReader(response.getEntity().getContent()));
            LOGGER.debug("PostMessage return: " + jsonResponse);
            ParsedSlackReply reply = SlackJSONReplyParser.decode(this.parseObject(jsonResponse), this);
            handle.setReply(reply);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public SlackMessageHandle<GenericSlackReply> postGenericSlackCommand(Map<String, String> params, String command) {
        HttpClient client = this.getHttpClient();
        HttpPost request = new HttpPost(SLACK_API_HTTPS_ROOT + command);
        ArrayList<BasicNameValuePair> nameValuePairList = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> arg : params.entrySet()) {
            if ("token".equals(arg.getKey())) continue;
            nameValuePairList.add(new BasicNameValuePair(arg.getKey(), arg.getValue()));
        }
        nameValuePairList.add(new BasicNameValuePair("token", this.authToken));
        try {
            SlackMessageHandle<GenericSlackReply> handle = new SlackMessageHandle<GenericSlackReply>(this.getNextMessageId());
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairList, "UTF-8"));
            HttpResponse response = client.execute((HttpUriRequest)request);
            String jsonResponse = this.consumeToString(response.getEntity().getContent());
            LOGGER.debug("PostMessage return: " + jsonResponse);
            GenericSlackReply reply = new GenericSlackReply(jsonResponse);
            handle.setReply(reply);
            return handle;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private HttpClient getHttpClient() {
        CloseableHttpClient client;
        if (this.proxyHost != null) {
            if (null == this.proxyUser) {
                client = HttpClientBuilder.create().setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(this.proxyHost)).build();
            } else {
                RequestConfig config = RequestConfig.custom().setProxy(this.proxyHost).build();
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(this.proxyHost), (Credentials)new UsernamePasswordCredentials(this.proxyUser, this.proxyPassword));
                client = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setDefaultRequestConfig(config).build();
            }
        } else {
            client = HttpClientBuilder.create().build();
        }
        return client;
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessageOverWebSocket(SlackChannel channel, String message) {
        SlackMessageHandle<SlackMessageReply> handle = new SlackMessageHandle<SlackMessageReply>(this.getNextMessageId());
        try {
            JsonObject messageJSON = new JsonObject();
            messageJSON.addProperty("id", (Number)handle.getMessageId());
            messageJSON.addProperty("type", "message");
            messageJSON.addProperty("channel", channel.getId());
            messageJSON.addProperty("text", message);
            this.websocketSession.getBasicRemote().sendText(messageJSON.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendTyping(SlackChannel channel) {
        SlackMessageHandle<SlackMessageReply> handle = new SlackMessageHandle<SlackMessageReply>(this.getNextMessageId());
        try {
            JsonObject messageJSON = new JsonObject();
            messageJSON.addProperty("id", (Number)handle.getMessageId());
            messageJSON.addProperty("type", "typing");
            messageJSON.addProperty("channel", channel.getId());
            this.websocketSession.getBasicRemote().sendText(messageJSON.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return handle;
    }

    @Override
    public SlackPersona.SlackPresence getPresence(SlackPersona persona) {
        HttpClient client = this.getHttpClient();
        HttpPost request = new HttpPost("https://slack.com/api/users.getPresence");
        ArrayList<BasicNameValuePair> nameValuePairList = new ArrayList<BasicNameValuePair>();
        nameValuePairList.add(new BasicNameValuePair("token", this.authToken));
        nameValuePairList.add(new BasicNameValuePair("user", persona.getId()));
        try {
            String presence;
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairList, "UTF-8"));
            HttpResponse response = client.execute((HttpUriRequest)request);
            String jsonResponse = this.consumeToString(response.getEntity().getContent());
            LOGGER.debug("PostMessage return: " + jsonResponse);
            JsonObject resultObject = this.parseObject(jsonResponse);
            SlackUserPresenceReply reply = (SlackUserPresenceReply)SlackJSONReplyParser.decode(resultObject, this);
            if (!reply.isOk()) {
                return SlackPersona.SlackPresence.UNKNOWN;
            }
            String string = presence = resultObject.get("presence") != null ? resultObject.get("presence").getAsString() : null;
            if ("active".equals(presence)) {
                return SlackPersona.SlackPresence.ACTIVE;
            }
            if ("away".equals(presence)) {
                return SlackPersona.SlackPresence.AWAY;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return SlackPersona.SlackPresence.UNKNOWN;
    }

    @Override
    public void setPresence(SlackPersona.SlackPresence presence) {
        if (presence == SlackPersona.SlackPresence.UNKNOWN || presence == SlackPersona.SlackPresence.ACTIVE) {
            throw new IllegalArgumentException("Presence must be either AWAY or AUTO");
        }
        HttpClient client = this.getHttpClient();
        HttpPost request = new HttpPost("https://slack.com/api/users.setPresence");
        ArrayList<BasicNameValuePair> nameValuePairList = new ArrayList<BasicNameValuePair>();
        nameValuePairList.add(new BasicNameValuePair("token", this.authToken));
        nameValuePairList.add(new BasicNameValuePair("presence", presence.toString().toLowerCase()));
        try {
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairList, "UTF-8"));
            HttpResponse response = client.execute((HttpUriRequest)request);
            String JSONResponse = this.consumeToString(response.getEntity().getContent());
            LOGGER.debug("JSON Response=" + JSONResponse);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private long getNextMessageId() {
        return this.messageId.getAndIncrement();
    }

    public void onMessage(String message) {
        JsonObject object = this.parseObject(message);
        LOGGER.debug("receiving from websocket " + message);
        if (object.get("type") == null) {
            LOGGER.info("unable to parse message, missing 'type' attribute: " + message);
            return;
        }
        if ("pong".equals(object.get("type").getAsString())) {
            this.lastPingAck = object.get("reply_to").getAsInt();
            LOGGER.debug("pong received " + this.lastPingAck);
        } else if ("reconnect_url".equals(object.get("type").getAsString())) {
            String newWebSocketConnectionURL = object.get("url").getAsString();
            LOGGER.debug("new websocket connection received " + newWebSocketConnectionURL);
        } else {
            SlackEvent slackEvent = SlackJSONMessageParser.decode(this, object);
            if (slackEvent instanceof SlackChannelCreated) {
                SlackChannelCreated slackChannelCreated = (SlackChannelCreated)slackEvent;
                this.channels.put(slackChannelCreated.getSlackChannel().getId(), slackChannelCreated.getSlackChannel());
            }
            if (slackEvent instanceof SlackGroupJoined) {
                SlackGroupJoined slackGroupJoined = (SlackGroupJoined)slackEvent;
                this.channels.put(slackGroupJoined.getSlackChannel().getId(), slackGroupJoined.getSlackChannel());
            }
            if (slackEvent instanceof SlackUserChangeEvent) {
                SlackUserChangeEvent slackUserChangeEvent = (SlackUserChangeEvent)slackEvent;
                this.users.put(slackUserChangeEvent.getUser().getId(), slackUserChangeEvent.getUser());
            }
            this.dispatcher.dispatch(slackEvent);
        }
    }

    private JsonObject parseObject(String json) {
        JsonParser parser = new JsonParser();
        return parser.parse(json).getAsJsonObject();
    }

    @Override
    public SlackMessageHandle<ParsedSlackReply> inviteUser(String email, String firstName, boolean setActive) {
        SlackMessageHandle<ParsedSlackReply> handle = new SlackMessageHandle<ParsedSlackReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("email", email);
        arguments.put("first_name", firstName);
        arguments.put("set_active", "" + setActive);
        this.postSlackCommand(arguments, INVITE_USER_COMMAND, handle);
        return handle;
    }

    @Override
    public long getHeartbeat() {
        return TimeUnit.MILLISECONDS.toSeconds(this.heartbeat);
    }

    public class EventDispatcher {
        void dispatch(SlackEvent event) {
            switch (event.getEventType()) {
                case SLACK_CHANNEL_ARCHIVED: {
                    this.dispatchImpl((SlackChannelArchived)event, SlackWebSocketSessionImpl.this.channelArchiveListener);
                    break;
                }
                case SLACK_CHANNEL_CREATED: {
                    this.dispatchImpl((SlackChannelCreated)event, SlackWebSocketSessionImpl.this.channelCreateListener);
                    break;
                }
                case SLACK_CHANNEL_DELETED: {
                    this.dispatchImpl((SlackChannelDeleted)event, SlackWebSocketSessionImpl.this.channelDeleteListener);
                    break;
                }
                case SLACK_CHANNEL_RENAMED: {
                    this.dispatchImpl((SlackChannelRenamed)event, SlackWebSocketSessionImpl.this.channelRenamedListener);
                    break;
                }
                case SLACK_CHANNEL_UNARCHIVED: {
                    this.dispatchImpl((SlackChannelUnarchived)event, SlackWebSocketSessionImpl.this.channelUnarchiveListener);
                    break;
                }
                case SLACK_CHANNEL_JOINED: {
                    this.dispatchImpl((SlackChannelJoined)event, SlackWebSocketSessionImpl.this.channelJoinedListener);
                    break;
                }
                case SLACK_CHANNEL_LEFT: {
                    this.dispatchImpl((SlackChannelLeft)event, SlackWebSocketSessionImpl.this.channelLeftListener);
                    break;
                }
                case SLACK_GROUP_JOINED: {
                    this.dispatchImpl((SlackGroupJoined)event, SlackWebSocketSessionImpl.this.groupJoinedListener);
                    break;
                }
                case SLACK_MESSAGE_DELETED: {
                    this.dispatchImpl((SlackMessageDeleted)event, SlackWebSocketSessionImpl.this.messageDeletedListener);
                    break;
                }
                case SLACK_MESSAGE_POSTED: {
                    this.dispatchImpl((SlackMessagePosted)event, SlackWebSocketSessionImpl.this.messagePostedListener);
                    break;
                }
                case SLACK_MESSAGE_UPDATED: {
                    this.dispatchImpl((SlackMessageUpdated)event, SlackWebSocketSessionImpl.this.messageUpdatedListener);
                    break;
                }
                case SLACK_CONNECTED: {
                    this.dispatchImpl((SlackConnected)event, SlackWebSocketSessionImpl.this.slackConnectedListener);
                    break;
                }
                case REACTION_ADDED: {
                    this.dispatchImpl((ReactionAdded)event, SlackWebSocketSessionImpl.this.reactionAddedListener);
                    break;
                }
                case REACTION_REMOVED: {
                    this.dispatchImpl((ReactionRemoved)event, SlackWebSocketSessionImpl.this.reactionRemovedListener);
                    break;
                }
                case SLACK_USER_CHANGE: {
                    this.dispatchImpl((SlackUserChange)event, SlackWebSocketSessionImpl.this.slackUserChangeListener);
                    break;
                }
                case SLACK_TEAM_JOIN: {
                    this.dispatchImpl((SlackTeamJoin)event, SlackWebSocketSessionImpl.this.slackTeamJoinListener);
                    break;
                }
                case PIN_ADDED: {
                    this.dispatchImpl((PinAdded)event, SlackWebSocketSessionImpl.this.pinAddedListener);
                    break;
                }
                case PIN_REMOVED: {
                    this.dispatchImpl((PinRemoved)event, SlackWebSocketSessionImpl.this.pinRemovedListener);
                    break;
                }
                case PRESENCE_CHANGE: {
                    this.dispatchImpl((PresenceChange)event, SlackWebSocketSessionImpl.this.presenceChangeListener);
                    break;
                }
                case SLACK_DISCONNECTED: {
                    this.dispatchImpl((SlackDisconnected)event, SlackWebSocketSessionImpl.this.slackDisconnectedListener);
                    break;
                }
                case USER_TYPING: {
                    this.dispatchImpl((UserTyping)event, SlackWebSocketSessionImpl.this.userTypingListener);
                    break;
                }
                case UNKNOWN: {
                    LOGGER.warn("event of type " + (Object)((Object)event.getEventType()) + " not handled: " + ((UnknownEvent)event).getJsonPayload());
                }
            }
        }

        private <E extends SlackEvent, L extends SlackEventListener<E>> void dispatchImpl(E event, List<L> listeners) {
            for (SlackEventListener listener : listeners) {
                try {
                    listener.onEvent(event, SlackWebSocketSessionImpl.this);
                }
                catch (Throwable thr) {
                    LOGGER.error("caught exception in dispatchImpl", thr);
                }
            }
        }
    }
}

