/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.commonsdk.statistics.common;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.res.Configuration;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.umeng.commonsdk.framework.UMEnvelopeBuild;
import com.umeng.commonsdk.statistics.AnalyticsConstants;
import com.umeng.commonsdk.statistics.common.HelperUtils;
import com.umeng.commonsdk.statistics.common.MLog;
import com.umeng.commonsdk.utils.UMUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.security.MessageDigest;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import javax.microedition.khronos.opengles.GL10;

public class DeviceConfig {
    protected static final String LOG_TAG = DeviceConfig.class.getName();
    public static final String UNKNOW = "";
    public static final String MOBILE_NETWORK = "2G/3G";
    public static final String WIFI = "Wi-Fi";
    public static final int DEFAULT_TIMEZONE = 8;
    private static final String KEY_MIUI_VERSION_NAME = "ro.miui.ui.version.name";
    private static final String KEY_EMUI_VERSION_CODE = "ro.build.hw_emui_api_level";

    public static String getImei(Context context) {
        String string;
        block3: {
            string = null;
            try {
                TelephonyManager telephonyManager;
                if (context != null && (telephonyManager = (TelephonyManager)context.getSystemService("phone")) != null && DeviceConfig.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
                    string = telephonyManager.getDeviceId();
                }
            }
            catch (Exception exception) {
                if (!AnalyticsConstants.UM_DEBUG) break block3;
                MLog.w("No IMEI.", exception);
            }
        }
        return string;
    }

    public static String getImeiNew(Context context) {
        String string;
        block6: {
            string = null;
            try {
                TelephonyManager telephonyManager;
                if (context == null || (telephonyManager = (TelephonyManager)context.getSystemService("phone")) == null || !DeviceConfig.checkPermission(context, "android.permission.READ_PHONE_STATE")) break block6;
                if (Build.VERSION.SDK_INT >= 26) {
                    try {
                        Method method = telephonyManager.getClass().getMethod("getImei", new Class[0]);
                        method.setAccessible(true);
                        string = (String)method.invoke((Object)telephonyManager, new Object[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        string = telephonyManager.getDeviceId();
                    }
                    break block6;
                }
                string = telephonyManager.getDeviceId();
            }
            catch (Exception exception) {
                if (!AnalyticsConstants.UM_DEBUG) break block6;
                MLog.w("No IMEI.", exception);
            }
        }
        return string;
    }

    public static String getAndroidId(Context context) {
        String string;
        block3: {
            string = null;
            if (context != null) {
                try {
                    string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                }
                catch (Exception exception) {
                    if (!AnalyticsConstants.UM_DEBUG) break block3;
                    MLog.w("can't read android id");
                }
            }
        }
        return string;
    }

    public static String getSerial() {
        if (Build.VERSION.SDK_INT >= 9) {
            String string = null;
            int n2 = Build.VERSION.SDK_INT;
            if (n2 >= 26) {
                try {
                    Class<?> clazz = Class.forName("android.os.Build");
                    Method method = clazz.getMethod("getSerial", new Class[0]);
                    string = (String)method.invoke(clazz, new Object[0]);
                }
                catch (Throwable throwable) {}
            } else {
                string = Build.SERIAL;
            }
            return string;
        }
        return null;
    }

    public static String getAppVersionCode(Context context) {
        return UMUtils.getAppVersionCode(context);
    }

    public static String getAppVersionName(Context context) {
        return UMUtils.getAppVersionName(context);
    }

    public static boolean checkPermission(Context context, String string) {
        boolean bl;
        block7: {
            bl = false;
            if (context == null) {
                return bl;
            }
            if (Build.VERSION.SDK_INT >= 23) {
                try {
                    Class<?> clazz = Class.forName("android.content.Context");
                    Method method = clazz.getMethod("checkSelfPermission", String.class);
                    int n2 = (Integer)method.invoke((Object)context, string);
                    if (n2 == 0) {
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
                catch (Throwable throwable) {
                    bl = false;
                }
            } else {
                PackageManager packageManager = context.getPackageManager();
                if (packageManager.checkPermission(string, context.getPackageName()) == 0) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static String[] getGPU(GL10 gL10) {
        try {
            String[] stringArray = new String[2];
            String string = gL10.glGetString(7936);
            String string2 = gL10.glGetString(7937);
            stringArray[0] = string;
            stringArray[1] = string2;
            return stringArray;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                MLog.e(LOG_TAG, "Could not read gpu infor:", throwable);
            }
            return new String[0];
        }
    }

    private static String getMacByJavaAPI() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (!"wlan0".equals(networkInterface.getName()) && !"eth0".equals(networkInterface.getName())) continue;
                byte[] byArray = networkInterface.getHardwareAddress();
                if (byArray == null || byArray.length == 0) {
                    return null;
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (byte by : byArray) {
                    stringBuilder.append(String.format("%02X:", by));
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                }
                return stringBuilder.toString().toLowerCase(Locale.getDefault());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static String getMacShell() {
        try {
            String[] stringArray = new String[]{"/sys/class/net/wlan0/address", "/sys/class/net/eth0/address", "/sys/devices/virtual/net/wlan0/address"};
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                try {
                    String string = DeviceConfig.reaMac(stringArray[i2]);
                    if (string == null) continue;
                    return string;
                }
                catch (Throwable throwable) {
                    if (!AnalyticsConstants.UM_DEBUG) continue;
                    MLog.e(LOG_TAG, "open file  Failed", throwable);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String reaMac(String string) {
        String string2;
        block15: {
            string2 = null;
            try {
                FileReader fileReader = new FileReader(string);
                BufferedReader bufferedReader = null;
                if (fileReader == null) break block15;
                try {
                    bufferedReader = new BufferedReader(fileReader, 1024);
                    string2 = bufferedReader.readLine();
                }
                finally {
                    if (fileReader != null) {
                        try {
                            fileReader.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return string2;
    }

    public static String getCPU() {
        String string = null;
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileReader = new FileReader("/proc/cpuinfo");
            if (fileReader != null) {
                try {
                    bufferedReader = new BufferedReader(fileReader, 1024);
                    string = bufferedReader.readLine();
                    bufferedReader.close();
                    fileReader.close();
                }
                catch (Throwable throwable) {
                    MLog.e(LOG_TAG, "Could not read from file /proc/cpuinfo", throwable);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            MLog.e(LOG_TAG, "Could not open file /proc/cpuinfo", fileNotFoundException);
        }
        if (string != null) {
            int n2 = string.indexOf(58) + 1;
            string = string.substring(n2);
            return string.trim();
        }
        return UNKNOW;
    }

    public static String getDeviceId(Context context) {
        if (AnalyticsConstants.getDeviceType() == 2) {
            return DeviceConfig.getDeviceIdForBox(context);
        }
        return DeviceConfig.getDeviceIdForGeneral(context);
    }

    public static String getDeviceIdUmengMD5(Context context) {
        return HelperUtils.getUmengMD5(DeviceConfig.getDeviceId(context));
    }

    public static String getMCCMNC(Context context) {
        if (context == null) {
            return null;
        }
        if (DeviceConfig.getImsi(context) == null) {
            return null;
        }
        int n2 = context.getResources().getConfiguration().mcc;
        int n3 = context.getResources().getConfiguration().mnc;
        if (n2 != 0) {
            String string = String.valueOf(n3);
            if (n3 < 10) {
                string = String.format("%02d", n3);
            }
            return new StringBuffer().append(String.valueOf(n2)).append(string).toString();
        }
        return null;
    }

    public static String getImsi(Context context) {
        if (context == null) {
            return null;
        }
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        String string = null;
        if (DeviceConfig.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
            string = telephonyManager.getSubscriberId();
        }
        return string;
    }

    public static String getRegisteredOperator(Context context) {
        if (context == null) {
            return null;
        }
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        String string = null;
        if (DeviceConfig.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
            string = telephonyManager.getNetworkOperator();
        }
        return string;
    }

    public static String getNetworkOperatorName(Context context) {
        if (context == null) {
            return UNKNOW;
        }
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (DeviceConfig.checkPermission(context, "android.permission.READ_PHONE_STATE") && telephonyManager != null) {
                return telephonyManager.getNetworkOperatorName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return UNKNOW;
    }

    public static String getDisplayResolution(Context context) {
        if (context == null) {
            return UNKNOW;
        }
        try {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
            int n2 = displayMetrics.widthPixels;
            int n3 = displayMetrics.heightPixels;
            String string = String.valueOf(n3) + "*" + String.valueOf(n2);
            return string;
        }
        catch (Throwable throwable) {
            return UNKNOW;
        }
    }

    public static String[] getNetworkAccessMode(Context context) {
        String[] stringArray = new String[]{UNKNOW, UNKNOW};
        if (context == null) {
            return stringArray;
        }
        try {
            if (!DeviceConfig.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
                stringArray[0] = UNKNOW;
                return stringArray;
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager == null) {
                stringArray[0] = UNKNOW;
                return stringArray;
            }
            NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
            if (networkInfo != null && networkInfo.getState() == NetworkInfo.State.CONNECTED) {
                stringArray[0] = WIFI;
                return stringArray;
            }
            NetworkInfo networkInfo2 = connectivityManager.getNetworkInfo(0);
            if (networkInfo2 != null && networkInfo2.getState() == NetworkInfo.State.CONNECTED) {
                stringArray[0] = MOBILE_NETWORK;
                stringArray[1] = networkInfo2.getSubtypeName();
                return stringArray;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return stringArray;
    }

    public static boolean isWiFiAvailable(Context context) {
        if (context == null) {
            return false;
        }
        return WIFI.equals(DeviceConfig.getNetworkAccessMode(context)[0]);
    }

    public static boolean isOnline(Context context) {
        if (context == null) {
            return false;
        }
        try {
            NetworkInfo networkInfo;
            ConnectivityManager connectivityManager;
            if (DeviceConfig.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE") && (connectivityManager = (ConnectivityManager)context.getSystemService("connectivity")) != null && (networkInfo = connectivityManager.getActiveNetworkInfo()) != null) {
                return networkInfo.isConnectedOrConnecting();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static int getTimeZone(Context context) {
        if (context == null) {
            return 8;
        }
        try {
            Locale locale = DeviceConfig.getLocale(context);
            Calendar calendar = Calendar.getInstance(locale);
            if (calendar != null) {
                return calendar.getTimeZone().getRawOffset() / 3600000;
            }
        }
        catch (Throwable throwable) {
            MLog.i(LOG_TAG, "error in getTimeZone", throwable);
        }
        return 8;
    }

    public static boolean isChineseAera(Context context) {
        if (context == null) {
            return false;
        }
        String string = UMEnvelopeBuild.imprintProperty(context, "country", UNKNOW);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string.equals("cn");
        }
        if (DeviceConfig.getImsi(context) == null) {
            string = DeviceConfig.getLocaleInfo(context)[0];
            if (!TextUtils.isEmpty((CharSequence)string) && string.equalsIgnoreCase("cn")) {
                return true;
            }
        } else {
            int n2 = context.getResources().getConfiguration().mcc;
            if (n2 == 460 || n2 == 461) {
                return true;
            }
            if (n2 == 0 && !TextUtils.isEmpty((CharSequence)(string = DeviceConfig.getLocaleInfo(context)[0])) && string.equalsIgnoreCase("cn")) {
                return true;
            }
        }
        return false;
    }

    public static String[] getLocaleInfo(Context context) {
        String[] stringArray = new String[]{"Unknown", "Unknown"};
        if (context == null) {
            return stringArray;
        }
        try {
            Locale locale = DeviceConfig.getLocale(context);
            if (locale != null) {
                stringArray[0] = locale.getCountry();
                stringArray[1] = locale.getLanguage();
            }
            if (TextUtils.isEmpty((CharSequence)stringArray[0])) {
                stringArray[0] = "Unknown";
            }
            if (TextUtils.isEmpty((CharSequence)stringArray[1])) {
                stringArray[1] = "Unknown";
            }
            return stringArray;
        }
        catch (Throwable throwable) {
            MLog.e(LOG_TAG, "error in getLocaleInfo", throwable);
            return stringArray;
        }
    }

    private static Locale getLocale(Context context) {
        Locale locale = null;
        if (context == null) {
            locale = Locale.getDefault();
            return locale;
        }
        try {
            Configuration configuration = new Configuration();
            configuration.setToDefaults();
            Settings.System.getConfiguration((ContentResolver)context.getContentResolver(), (Configuration)configuration);
            if (configuration != null) {
                locale = configuration.locale;
            }
        }
        catch (Throwable throwable) {
            MLog.e(LOG_TAG, "fail to read user config locale");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static String getMac(Context context) {
        String string = UNKNOW;
        if (context == null) {
            return string;
        }
        if (Build.VERSION.SDK_INT < 23) {
            string = DeviceConfig.getMacBySystemInterface(context);
        } else if (Build.VERSION.SDK_INT == 23) {
            string = DeviceConfig.getMacByJavaAPI();
            if (TextUtils.isEmpty((CharSequence)string)) {
                string = AnalyticsConstants.CHECK_DEVICE ? DeviceConfig.getMacShell() : DeviceConfig.getMacBySystemInterface(context);
            }
        } else {
            string = DeviceConfig.getMacByJavaAPI();
            if (TextUtils.isEmpty((CharSequence)string)) {
                string = DeviceConfig.getMacBySystemInterface(context);
            }
        }
        return string;
    }

    private static String getMacBySystemInterface(Context context) {
        if (context == null) {
            return UNKNOW;
        }
        try {
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            if (DeviceConfig.checkPermission(context, "android.permission.ACCESS_WIFI_STATE")) {
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                return wifiInfo.getMacAddress();
            }
            if (AnalyticsConstants.UM_DEBUG) {
                MLog.w(LOG_TAG, "Could not get mac address.[no permission android.permission.ACCESS_WIFI_STATE");
            }
            return UNKNOW;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                MLog.w(LOG_TAG, "Could not get mac address." + throwable.toString());
            }
            return UNKNOW;
        }
    }

    public static int[] getResolutionArray(Context context) {
        if (context == null) {
            return null;
        }
        try {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
            int n2 = -1;
            int n3 = -1;
            if ((context.getApplicationInfo().flags & 0x2000) == 0) {
                n2 = DeviceConfig.reflectMetrics(displayMetrics, "noncompatWidthPixels");
                n3 = DeviceConfig.reflectMetrics(displayMetrics, "noncompatHeightPixels");
            }
            if (n2 == -1 || n3 == -1) {
                n2 = displayMetrics.widthPixels;
                n3 = displayMetrics.heightPixels;
            }
            int[] nArray = new int[2];
            if (n2 > n3) {
                nArray[0] = n3;
                nArray[1] = n2;
            } else {
                nArray[0] = n2;
                nArray[1] = n3;
            }
            return nArray;
        }
        catch (Throwable throwable) {
            if (AnalyticsConstants.UM_DEBUG) {
                MLog.e(LOG_TAG, "read resolution fail", throwable);
            }
            return null;
        }
    }

    private static int reflectMetrics(Object object, String string) {
        try {
            Field field = DisplayMetrics.class.getDeclaredField(string);
            field.setAccessible(true);
            return field.getInt(object);
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public static String getPackageName(Context context) {
        if (context == null) {
            return null;
        }
        return context.getPackageName();
    }

    public static String getAppSHA1Key(Context context) {
        X509Certificate x509Certificate = null;
        String string = null;
        try {
            PackageManager packageManager = context.getPackageManager();
            int n2 = 64;
            PackageInfo packageInfo = packageManager.getPackageInfo(DeviceConfig.getPackageName(context), n2);
            Signature[] signatureArray = packageInfo.signatures;
            byte[] byArray = signatureArray[0].toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            CertificateFactory certificateFactory = null;
            certificateFactory = CertificateFactory.getInstance("X509");
            x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            byte[] byArray2 = messageDigest.digest(x509Certificate.getEncoded());
            string = DeviceConfig.byte2HexFormatted(byArray2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static String getAppHashKey(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            int n2 = 64;
            PackageInfo packageInfo = packageManager.getPackageInfo(DeviceConfig.getPackageName(context), n2);
            Signature[] signatureArray = packageInfo.signatures;
            int n3 = signatureArray.length;
            int n4 = 0;
            if (n4 < n3) {
                Signature signature = signatureArray[n4];
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
                messageDigest.update(signature.toByteArray());
                return Base64.encodeToString((byte[])messageDigest.digest(), (int)0).trim();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static String getAppMD5Signature(Context context) {
        String string = null;
        if (context == null) {
            return string;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            int n2 = 64;
            PackageInfo packageInfo = packageManager.getPackageInfo(DeviceConfig.getPackageName(context), n2);
            Signature[] signatureArray = packageInfo.signatures;
            byte[] byArray = signatureArray[0].toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray2 = messageDigest.digest(x509Certificate.getEncoded());
            string = DeviceConfig.byte2HexFormatted(byArray2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    private static String byte2HexFormatted(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            String string = Integer.toHexString(byArray[i2]);
            int n2 = string.length();
            if (n2 == 1) {
                string = "0" + string;
            }
            if (n2 > 2) {
                string = string.substring(n2 - 2, n2);
            }
            stringBuilder.append(string.toUpperCase(Locale.getDefault()));
            if (i2 >= byArray.length - 1) continue;
            stringBuilder.append(':');
        }
        return stringBuilder.toString();
    }

    public static String getApplicationLable(Context context) {
        if (context == null) {
            return UNKNOW;
        }
        return context.getPackageManager().getApplicationLabel(context.getApplicationInfo()).toString();
    }

    public static String getAppName(Context context) {
        String string;
        block3: {
            string = null;
            if (context == null) {
                return string;
            }
            try {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                string = packageInfo.applicationInfo.loadLabel(context.getPackageManager()).toString();
            }
            catch (Throwable throwable) {
                if (!AnalyticsConstants.UM_DEBUG) break block3;
                MLog.i(LOG_TAG, throwable);
            }
        }
        return string;
    }

    public static String getDeviceIdForGeneral(Context context) {
        String string = UNKNOW;
        if (context == null) {
            return string;
        }
        if (Build.VERSION.SDK_INT < 23) {
            string = DeviceConfig.getIMEI(context);
            if (TextUtils.isEmpty((CharSequence)string)) {
                if (AnalyticsConstants.UM_DEBUG) {
                    MLog.w(LOG_TAG, "No IMEI.");
                }
                if (TextUtils.isEmpty((CharSequence)(string = DeviceConfig.getMacBySystemInterface(context)))) {
                    string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                    if (AnalyticsConstants.UM_DEBUG) {
                        MLog.i(LOG_TAG, "getDeviceId, ANDROID_ID: " + string);
                    }
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        string = DeviceConfig.getSerialNo();
                    }
                }
            }
        } else if (Build.VERSION.SDK_INT == 23) {
            string = DeviceConfig.getIMEI(context);
            if (TextUtils.isEmpty((CharSequence)string)) {
                string = DeviceConfig.getMacByJavaAPI();
                if (TextUtils.isEmpty((CharSequence)string)) {
                    string = AnalyticsConstants.CHECK_DEVICE ? DeviceConfig.getMacShell() : DeviceConfig.getMacBySystemInterface(context);
                }
                if (AnalyticsConstants.UM_DEBUG) {
                    MLog.i(LOG_TAG, "getDeviceId, MAC: " + string);
                }
                if (TextUtils.isEmpty((CharSequence)string)) {
                    string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                    if (AnalyticsConstants.UM_DEBUG) {
                        MLog.i(LOG_TAG, "getDeviceId, ANDROID_ID: " + string);
                    }
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        string = DeviceConfig.getSerialNo();
                    }
                }
            }
        } else {
            string = DeviceConfig.getIMEI(context);
            if (TextUtils.isEmpty((CharSequence)string) && TextUtils.isEmpty((CharSequence)(string = DeviceConfig.getSerialNo()))) {
                string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                if (AnalyticsConstants.UM_DEBUG) {
                    MLog.i(LOG_TAG, "getDeviceId, ANDROID_ID: " + string);
                }
                if (TextUtils.isEmpty((CharSequence)string) && TextUtils.isEmpty((CharSequence)(string = DeviceConfig.getMacByJavaAPI()))) {
                    string = DeviceConfig.getMacBySystemInterface(context);
                    if (AnalyticsConstants.UM_DEBUG) {
                        MLog.i(LOG_TAG, "getDeviceId, MAC: " + string);
                    }
                }
            }
        }
        return string;
    }

    public static String getDeviceIdForBox(Context context) {
        String string = UNKNOW;
        if (context == null) {
            return string;
        }
        if (Build.VERSION.SDK_INT < 23) {
            string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            if (AnalyticsConstants.UM_DEBUG) {
                MLog.i(LOG_TAG, "getDeviceId, ANDROID_ID: " + string);
            }
            if (TextUtils.isEmpty((CharSequence)string)) {
                string = DeviceConfig.getMacBySystemInterface(context);
                if (AnalyticsConstants.UM_DEBUG) {
                    MLog.i(LOG_TAG, "getDeviceId, MAC: " + string);
                }
                if (TextUtils.isEmpty((CharSequence)string) && TextUtils.isEmpty((CharSequence)(string = DeviceConfig.getSerialNo()))) {
                    string = DeviceConfig.getIMEI(context);
                }
            }
        } else if (Build.VERSION.SDK_INT == 23) {
            string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            if (AnalyticsConstants.UM_DEBUG) {
                MLog.i(LOG_TAG, "getDeviceId, ANDROID_ID: " + string);
            }
            if (TextUtils.isEmpty((CharSequence)string)) {
                string = DeviceConfig.getMacByJavaAPI();
                if (TextUtils.isEmpty((CharSequence)string)) {
                    string = AnalyticsConstants.CHECK_DEVICE ? DeviceConfig.getMacShell() : DeviceConfig.getMacBySystemInterface(context);
                }
                if (AnalyticsConstants.UM_DEBUG) {
                    MLog.i(LOG_TAG, "getDeviceId, MAC: " + string);
                }
                if (TextUtils.isEmpty((CharSequence)string) && TextUtils.isEmpty((CharSequence)(string = DeviceConfig.getSerialNo()))) {
                    string = DeviceConfig.getIMEI(context);
                }
            }
        } else {
            string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            if (AnalyticsConstants.UM_DEBUG) {
                MLog.i(LOG_TAG, "getDeviceId: ANDROID_ID: " + string);
            }
            if (TextUtils.isEmpty((CharSequence)string) && TextUtils.isEmpty((CharSequence)(string = DeviceConfig.getSerialNo())) && TextUtils.isEmpty((CharSequence)(string = DeviceConfig.getIMEI(context))) && TextUtils.isEmpty((CharSequence)(string = DeviceConfig.getMacByJavaAPI()))) {
                string = DeviceConfig.getMacBySystemInterface(context);
                if (AnalyticsConstants.UM_DEBUG) {
                    MLog.i(LOG_TAG, "getDeviceId, MAC: " + string);
                }
            }
        }
        return string;
    }

    private static String getIMEI(Context context) {
        String string;
        block6: {
            string = UNKNOW;
            if (context == null) {
                return string;
            }
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager != null) {
                try {
                    if (DeviceConfig.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
                        string = telephonyManager.getDeviceId();
                        if (AnalyticsConstants.UM_DEBUG) {
                            MLog.i(LOG_TAG, "getDeviceId, IMEI: " + string);
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (!AnalyticsConstants.UM_DEBUG) break block6;
                    MLog.w(LOG_TAG, "No IMEI.", throwable);
                }
            }
        }
        return string;
    }

    private static String getSerialNo() {
        String string = UNKNOW;
        if (Build.VERSION.SDK_INT >= 9) {
            if (Build.VERSION.SDK_INT >= 26) {
                try {
                    Class<?> clazz = Class.forName("android.os.Build");
                    Method method = clazz.getMethod("getSerial", new Class[0]);
                    string = (String)method.invoke(clazz, new Object[0]);
                }
                catch (Throwable throwable) {}
            } else {
                string = Build.SERIAL;
            }
        }
        if (AnalyticsConstants.UM_DEBUG) {
            MLog.i(LOG_TAG, "getDeviceId, serial no: " + string);
        }
        return string;
    }

    public static String getSubOSName(Context context) {
        String string = null;
        Properties properties = DeviceConfig.getBuildProp();
        try {
            string = properties.getProperty(KEY_MIUI_VERSION_NAME);
            if (TextUtils.isEmpty((CharSequence)string)) {
                if (DeviceConfig.isFlyMe()) {
                    string = "Flyme";
                } else if (DeviceConfig.isEmui(properties)) {
                    string = "Emui";
                } else if (!TextUtils.isEmpty((CharSequence)DeviceConfig.getYunOSVersion(properties))) {
                    string = "YunOS";
                }
            } else {
                string = "MIUI";
            }
        }
        catch (Throwable throwable) {
            string = null;
        }
        return string;
    }

    public static String getSubOSVersion(Context context) {
        String string = null;
        Properties properties = DeviceConfig.getBuildProp();
        try {
            string = properties.getProperty(KEY_MIUI_VERSION_NAME);
            if (TextUtils.isEmpty((CharSequence)string)) {
                if (DeviceConfig.isFlyMe()) {
                    try {
                        string = DeviceConfig.getFlymeVersion(properties);
                    }
                    catch (Throwable throwable) {}
                } else if (DeviceConfig.isEmui(properties)) {
                    try {
                        string = DeviceConfig.getEmuiVersion(properties);
                    }
                    catch (Throwable throwable) {}
                } else {
                    try {
                        string = DeviceConfig.getYunOSVersion(properties);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (Throwable throwable) {
            string = null;
        }
        return string;
    }

    private static String getYunOSVersion(Properties properties) {
        String string = properties.getProperty("ro.yunos.version");
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        return null;
    }

    private static String getFlymeVersion(Properties properties) {
        try {
            String string = properties.getProperty("ro.build.display.id").toLowerCase(Locale.getDefault());
            if (string.contains("flyme os")) {
                return string.split(" ")[2];
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static String getEmuiVersion(Properties properties) {
        String string = null;
        try {
            string = properties.getProperty(KEY_EMUI_VERSION_CODE, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private static Properties getBuildProp() {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(new File(Environment.getRootDirectory(), "build.prop"));
            properties.load(fileInputStream);
        }
        catch (Throwable throwable) {
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return properties;
    }

    private static boolean isFlyMe() {
        try {
            Build.class.getMethod("hasSmartBar", new Class[0]);
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    private static boolean isEmui(Properties properties) {
        try {
            String string = properties.getProperty(KEY_EMUI_VERSION_CODE, null);
            if (string != null) {
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public static String getDeviceType(Context context) {
        String string = "Phone";
        if (context == null) {
            return string;
        }
        boolean bl = (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
        string = bl ? "Tablet" : "Phone";
        return string;
    }

    public static String getDBencryptID(Context context) {
        String string = null;
        try {
            if (context != null) {
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                if (telephonyManager != null && DeviceConfig.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
                    string = telephonyManager.getDeviceId();
                }
                if (TextUtils.isEmpty(string) && TextUtils.isEmpty((CharSequence)(string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id"))) && Build.VERSION.SDK_INT >= 9) {
                    if (Build.VERSION.SDK_INT >= 26) {
                        try {
                            Class<?> clazz = Class.forName("android.os.Build");
                            Method method = clazz.getMethod("getSerial", new Class[0]);
                            string = (String)method.invoke(clazz, new Object[0]);
                        }
                        catch (Throwable throwable) {}
                    } else {
                        string = Build.SERIAL;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }
}

