/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.accs;

import android.content.Context;
import android.text.TextUtils;
import anet.channel.SessionCenter;
import anet.channel.entity.ENV;
import com.taobao.accs.ACCSManager;
import com.taobao.accs.AccsClientConfig;
import com.taobao.accs.AccsException;
import com.taobao.accs.IAppReceiver;
import com.taobao.accs.ILoginInfo;
import com.taobao.accs.b;
import com.taobao.accs.base.AccsAbstractDataListener;
import com.taobao.accs.base.AccsConnectStateListener;
import com.taobao.accs.base.TaoBaseService;
import com.taobao.accs.client.GlobalClientInfo;
import com.taobao.accs.utl.ALog;
import com.taobao.accs.utl.x;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ACCSClient {
    protected b mAccsManager;
    private static String TAG = "ACCSClient";
    private String OTAG = TAG;
    private static Context mContext;
    private AccsClientConfig mConfig;
    public static Map<String, ACCSClient> mACCSClients;

    public ACCSClient(AccsClientConfig accsClientConfig) {
        this.mConfig = accsClientConfig;
        this.OTAG = this.OTAG + accsClientConfig.getTag();
        if (mContext == null) {
            mContext = GlobalClientInfo.a;
        }
        this.mAccsManager = ACCSManager.getAccsInstance(mContext, accsClientConfig.getAppKey(), accsClientConfig.getTag());
    }

    public static synchronized String init(Context context, String string) throws AccsException {
        if (context == null || TextUtils.isEmpty((CharSequence)string)) {
            throw new AccsException("params error");
        }
        AccsClientConfig accsClientConfig = AccsClientConfig.getConfigByTag(string);
        if (!AccsClientConfig.loadedStaticConfig) {
            AccsClientConfig.Builder builder = new AccsClientConfig.Builder();
            accsClientConfig = builder.setAppKey(string).build();
            ALog.i(TAG, "init", "create config, appkey as tag");
        }
        return ACCSClient.init(context, accsClientConfig);
    }

    public static synchronized String init(Context context, AccsClientConfig accsClientConfig) throws AccsException {
        boolean bl;
        if (context == null || accsClientConfig == null) {
            throw new AccsException("init AccsClient params error");
        }
        boolean bl2 = bl = (context.getApplicationInfo().flags & 2) != 0;
        if (bl) {
            ALog.isUseTlog = false;
            anet.channel.util.ALog.setUseTlog((boolean)false);
        }
        mContext = context.getApplicationContext();
        GlobalClientInfo.a = context.getApplicationContext();
        ALog.d(TAG, "init", "config", accsClientConfig);
        return accsClientConfig.getTag();
    }

    public static ACCSClient getAccsClient() throws AccsException {
        return ACCSClient.getAccsClient(null);
    }

    public static synchronized ACCSClient getAccsClient(String string) throws AccsException {
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "default";
            ALog.w(TAG, "getAccsClient", "configTag is null, use default!");
        }
        ALog.i(TAG, "getAccsClient", "configTag", string);
        AccsClientConfig accsClientConfig = AccsClientConfig.getConfigByTag(string);
        if (accsClientConfig == null) {
            ALog.e(TAG, "getAccsClient", "configTag not exist, please init first!!");
            throw new AccsException("configTag not exist");
        }
        ACCSClient aCCSClient = mACCSClients.get(string);
        if (aCCSClient == null) {
            ALog.d(TAG, "getAccsClient create client", new Object[0]);
            aCCSClient = new ACCSClient(accsClientConfig);
            mACCSClients.put(string, aCCSClient);
            aCCSClient.updateConfig(accsClientConfig);
            return aCCSClient;
        }
        if (accsClientConfig.equals(aCCSClient.mConfig)) {
            ALog.i(TAG, "getAccsClient exists", new Object[0]);
        } else {
            ALog.i(TAG, "getAccsClient update config", "old config", aCCSClient.mConfig.getTag(), "new config", accsClientConfig.getTag());
            aCCSClient.updateConfig(accsClientConfig);
        }
        return aCCSClient;
    }

    private void updateConfig(AccsClientConfig accsClientConfig) {
        this.mConfig = accsClientConfig;
        this.mAccsManager = ACCSManager.getAccsInstance(mContext, accsClientConfig.getAppKey(), accsClientConfig.getTag());
        if (this.mAccsManager != null) {
            this.mAccsManager.a(accsClientConfig);
        }
    }

    public static synchronized void setEnvironment(Context context, @AccsClientConfig.ENV int n2) {
        int n3 = n2;
        try {
            int n4;
            if (context != null) {
                int n5 = n4 = (context.getApplicationInfo().flags & 2) != 0 ? 1 : 0;
                if (n4 != 0) {
                    ALog.isUseTlog = false;
                    anet.channel.util.ALog.setUseTlog((boolean)false);
                }
            }
            if (n2 < 0 || n2 > 2) {
                ALog.e(TAG, "env error", "env", n2);
                n3 = 0;
            }
            n4 = AccsClientConfig.mEnv;
            AccsClientConfig.mEnv = n3;
            if (n4 != n3 && x.e(context)) {
                ALog.i(TAG, "setEnvironment", "preEnv", n4, "toEnv", n3);
                x.c(context);
                x.f(context);
                x.d(context);
                if (n3 == 2) {
                    SessionCenter.switchEnvironment((ENV)ENV.TEST);
                } else if (n3 == 1) {
                    SessionCenter.switchEnvironment((ENV)ENV.PREPARE);
                }
                for (Map.Entry<String, ACCSClient> entry : mACCSClients.entrySet()) {
                    try {
                        ACCSClient.getAccsClient(entry.getKey());
                    }
                    catch (AccsException accsException) {
                        ALog.e(TAG, "setEnvironment update client", accsException, new Object[0]);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "setEnvironment", throwable, new Object[0]);
        }
        finally {
            x.a(context, n3);
        }
    }

    public void bindApp(String string, IAppReceiver iAppReceiver) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "bindApp mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.a(mContext, this.mConfig.getAppKey(), this.mConfig.getAppSecret(), string, iAppReceiver);
    }

    public void bindUser(String string) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "bindUser mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.a(mContext, string);
    }

    public void bindUser(String string, boolean bl) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "bindUser mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.a(mContext, string, bl);
    }

    public void unbindUser() {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "unbindUser mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.a(mContext);
    }

    public void bindService(String string) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "bindService mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.b(mContext, string);
    }

    public void unbindService(String string) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "unbindService mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.c(mContext, string);
    }

    public String sendData(ACCSManager.AccsRequest accsRequest) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "sendData mAccsManager null", new Object[0]);
            return null;
        }
        return this.mAccsManager.a(mContext, accsRequest);
    }

    public String sendRequest(ACCSManager.AccsRequest accsRequest) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "sendRequest mAccsManager null", new Object[0]);
            return null;
        }
        return this.mAccsManager.b(mContext, accsRequest);
    }

    public String sendPushResponse(ACCSManager.AccsRequest accsRequest, TaoBaseService.ExtraInfo extraInfo) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "sendPushResponse mAccsManager null", new Object[0]);
            return null;
        }
        return this.mAccsManager.a(mContext, accsRequest, extraInfo);
    }

    public boolean isNetworkReachable() {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "isNetworkReachable mAccsManager null", new Object[0]);
            return false;
        }
        return this.mAccsManager.b(mContext);
    }

    public void forceDisableService() {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "forceDisableService mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.c(mContext);
    }

    public void forceEnableService() {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "forceEnableService mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.d(mContext);
    }

    public void startInAppConnection(String string, IAppReceiver iAppReceiver) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "startInAppConnection mAccsManager null", new Object[0]);
            return;
        }
        String string2 = this.mConfig.getAppKey();
        this.mConfig.getAppSecret();
        this.mAccsManager.a(mContext, string2, string, iAppReceiver);
    }

    public void setLoginInfo(ILoginInfo iLoginInfo) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "setLoginInfo mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.a(mContext, iLoginInfo);
    }

    public void clearLoginInfo() {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "clearLoginInfo mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.e(mContext);
    }

    public boolean cancel(String string) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "cancel mAccsManager null", new Object[0]);
            return false;
        }
        return this.mAccsManager.a(string);
    }

    public boolean isChannelError(int n2) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "isChannelError mAccsManager null", new Object[0]);
            return true;
        }
        return this.mAccsManager.a(n2);
    }

    public Map<String, Boolean> getChannelState() throws Exception {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "getChannelState mAccsManager null", new Object[0]);
            return null;
        }
        return this.mAccsManager.b();
    }

    public Map<String, Boolean> forceReConnectChannel() throws Exception {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "forceReConnectChannel mAccsManager null", new Object[0]);
            return null;
        }
        return this.mAccsManager.c();
    }

    @Deprecated
    public String getUserUnit() {
        return null;
    }

    public void registerSerivce(String string, String string2) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "registerSerivce mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.a(mContext, string, string2);
    }

    public void unRegisterSerivce(String string) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "unRegisterSerivce mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.d(mContext, string);
    }

    public void registerDataListener(String string, AccsAbstractDataListener accsAbstractDataListener) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "registerDataListener mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.a(mContext, string, accsAbstractDataListener);
    }

    public void unRegisterDataListener(String string) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "unRegisterDataListener mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.e(mContext, string);
    }

    public void registerConnectStateListener(AccsConnectStateListener accsConnectStateListener) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "registerConnectStateListener mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.a(accsConnectStateListener);
    }

    public void unRegisterConnectStateListener(AccsConnectStateListener accsConnectStateListener) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "unRegisterConnectStateListener mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.b(accsConnectStateListener);
    }

    public void sendBusinessAck(String string, String string2, String string3, short s2, String string4, Map<Integer, String> map) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "sendBusinessAck mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.a(string, string2, string3, s2, string4, map);
    }

    public boolean isAccsConnected() {
        return this.mAccsManager != null && this.mAccsManager.a();
    }

    static {
        mACCSClients = new ConcurrentHashMap<String, ACCSClient>(2);
    }
}

