/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.accs.ut.monitor;

import anet.channel.statist.Dimension;
import anet.channel.statist.Measure;
import anet.channel.statist.Monitor;
import com.taobao.accs.utl.ALog;
import com.taobao.accs.utl.BaseMonitor;

@Monitor(module="accs", monitorPoint="netperformance")
public class NetPerformanceMonitor
extends BaseMonitor {
    @Measure(max=60000.0, min=0.0, constantValue=0.0)
    public long total_time;
    @Measure(max=60000.0, min=0.0, constantValue=0.0)
    public long start_to_enter_queue_time;
    @Measure(max=60000.0, min=0.0, constantValue=0.0)
    public long in_queue_time;
    @Measure(max=60000.0, min=0.0, constantValue=0.0)
    public long talk_to_send_time;
    @Measure(max=60000.0, min=0.0, constantValue=0.0)
    public long send_to_receive_time;
    @Measure(max=60000.0, min=0.0, constantValue=0.0)
    public long receive_to_distribute_time;
    @Measure(max=60000.0, min=0.0, constantValue=0.0)
    public long distribute_to_service_time;
    @Measure(max=60000.0, min=0.0, constantValue=0.0)
    public long service_to_recv_time;
    @Measure(max=60000.0, min=0.0, constantValue=0.0)
    public long receive_to_call_back_time;
    @Measure(max=60000.0, min=0.0, constantValue=0.0)
    public long receive_accs_to_call_time;
    @Measure(max=60000.0, min=0.0, constantValue=0.0)
    public long receive_agoo_to_call_time;
    @Dimension
    public int accs_sdk_version;
    @Dimension
    public String service_id = "none";
    @Dimension
    public String ret;
    @Dimension
    public int error_code;
    @Dimension
    public String fail_reasons;
    @Dimension
    public int accs_type;
    @Dimension
    public String host;
    @Dimension
    public int retry_times;
    @Dimension
    public int msgType;
    public String data_id;
    public String device_id;
    private long a;
    private long b;
    public long take_date;
    public long to_tnet_date;
    private long c;
    private long d;
    public long start_service;
    public long service_recv;
    public long real_to_bz_date;
    private long e;
    private long f;
    private long g;
    public long thread_schedule_time;
    public long check_routing_ack_time;
    public long check_command_time;
    public long check_space_time;
    public long check_routing_msg_time;
    public long check_process_time;
    public long control_msg_time;

    public void setDeviceId(String string) {
        this.device_id = string;
    }

    public void setServiceId(String string) {
        this.service_id = string;
    }

    public void setDataId(String string) {
        this.data_id = string;
    }

    public void onSend() {
        this.a = System.currentTimeMillis();
    }

    public void onEnterQueueData() {
        this.b = System.currentTimeMillis();
    }

    public void onTakeFromQueue() {
        this.take_date = System.currentTimeMillis();
    }

    public void onSendData() {
        this.to_tnet_date = System.currentTimeMillis();
    }

    public void onReceiveData() {
        this.e = System.currentTimeMillis();
    }

    public void onToAccsTime() {
        this.f = System.currentTimeMillis();
    }

    public void onToAgooTime() {
        this.g = System.currentTimeMillis();
    }

    public void setRet(boolean bl) {
        this.ret = bl ? "y" : "n";
    }

    public void setFailReason(String string) {
        this.fail_reasons = string;
    }

    public void setMsgType(int n2) {
        this.msgType = n2;
    }

    public void setFailReason(int n2) {
        this.error_code = n2;
        switch (n2) {
            case 200: {
                break;
            }
            case -1: {
                this.setFailReason("network fail");
                break;
            }
            case -4: {
                this.setFailReason("msg too large");
                break;
            }
            case 300: {
                this.setFailReason("app not bind");
                break;
            }
            case -2: {
                this.setFailReason("param error");
                break;
            }
            case -3: {
                this.setFailReason("service not available");
                break;
            }
            default: {
                this.setFailReason(String.valueOf(n2));
            }
        }
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void onRecAck() {
        this.c = System.currentTimeMillis();
    }

    public void onToBizDate() {
        this.d = System.currentTimeMillis();
    }

    public void setConnType(int n2) {
        this.accs_type = n2;
    }

    @Override
    public boolean beforeCommit() {
        if (this.real_to_bz_date == 0L) {
            this.real_to_bz_date = this.d;
        }
        this.accs_sdk_version = 221;
        this.total_time = this.a(this.a, this.real_to_bz_date);
        this.start_to_enter_queue_time = this.a(this.a, this.b);
        this.in_queue_time = this.a(this.b, this.take_date);
        this.talk_to_send_time = this.a(this.take_date, this.to_tnet_date);
        this.send_to_receive_time = this.a(this.to_tnet_date, this.c);
        this.receive_to_distribute_time = this.a(this.c, this.d);
        this.distribute_to_service_time = this.a(this.d, this.start_service);
        this.service_to_recv_time = this.a(this.start_service, this.service_recv);
        this.receive_to_call_back_time = this.a(this.service_recv, this.real_to_bz_date);
        this.receive_accs_to_call_time = this.a(this.e, this.f);
        this.receive_agoo_to_call_time = this.a(this.e, this.g);
        if ("accs-impaas".equals(this.service_id)) {
            ALog.e("pref", "netperf", "dataid", this.data_id, "total_time", this.total_time, "before_queue", this.start_to_enter_queue_time, "in_queue", this.in_queue_time, "send", this.talk_to_send_time, "recv", this.send_to_receive_time, "distribute", this.receive_to_distribute_time, "startservice", this.distribute_to_service_time, "servicerecv", this.service_to_recv_time, "tobiz", this.receive_to_call_back_time);
        }
        return super.beforeCommit();
    }

    private long a(long l2, long l3) {
        long l4 = 0L;
        if (l2 > 0L && l3 > 0L) {
            l4 = l3 - l2;
        }
        return l4;
    }
}

