/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.accs;

import android.content.Context;
import android.text.TextUtils;
import com.taobao.accs.AccsException;
import com.taobao.accs.utl.ALog;
import com.taobao.accs.utl.v;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AccsClientConfig
implements Serializable {
    private static final String TAG = "AccsClientConfig";
    public static final int SECURITY_OFF = 2;
    public static final String DEFAULT_CONFIGTAG = "default";
    public static final String[] DEFAULT_CENTER_HOSTS = new String[]{"umengacs.m.taobao.com", "msgacs.wapa.taobao.com", "msgacs.waptest.taobao.com"};
    private static final String[] DEFAULT_CHANNEL_HOSTS = new String[]{"umengjmacs.m.taobao.com", "acs.wapa.taobao.com", "acs.waptest.taobao.com"};
    private static Context mContext;
    public static boolean loadedStaticConfig;
    @ENV
    public static int mEnv;
    public static Map<String, AccsClientConfig> mReleaseConfigs;
    public static Map<String, AccsClientConfig> mPreviewConfigs;
    public static Map<String, AccsClientConfig> mDebugConfigs;
    private String mAppKey;
    private String mAppSecret;
    private String mInappHost;
    private String mChannelHost;
    private String mStoreId;
    private int mSecurity;
    private String mAuthCode;
    private int mInappPubKey;
    private int mChannelPubKey;
    private boolean mKeepalive;
    private boolean mAutoUnit;
    private String mTag;
    private int mConfigEnv;
    private boolean mDisableChannel;
    private boolean mQuickReconnect;
    private boolean mAccsHeartbeatEnable;
    private boolean mPullUpEnable;
    private boolean mForePingEnable;
    private int mPingTimeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Context getContext() {
        if (mContext != null) {
            return mContext;
        }
        Class<AccsClientConfig> clazz = AccsClientConfig.class;
        synchronized (AccsClientConfig.class) {
            if (mContext != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return mContext;
            }
            try {
                Class<?> clazz2 = Class.forName("android.app.ActivityThread");
                Object object = clazz2.getMethod("currentActivityThread", new Class[0]).invoke(clazz2, new Object[0]);
                mContext = (Context)object.getClass().getMethod("getApplication", new Class[0]).invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return mContext;
        }
    }

    protected AccsClientConfig() {
    }

    @Deprecated
    public static AccsClientConfig getConfig(String string) {
        Map<String, AccsClientConfig> map;
        switch (mEnv) {
            case 1: {
                map = mPreviewConfigs;
                break;
            }
            case 2: {
                map = mDebugConfigs;
                break;
            }
            default: {
                map = mReleaseConfigs;
            }
        }
        for (AccsClientConfig accsClientConfig : map.values()) {
            if (!accsClientConfig.mAppKey.equals(string) || accsClientConfig.mConfigEnv != mEnv) continue;
            return accsClientConfig;
        }
        ALog.e(TAG, "getConfigByTag return null", "appkey", string);
        return null;
    }

    public static AccsClientConfig getConfigByTag(String string) {
        AccsClientConfig accsClientConfig;
        switch (mEnv) {
            case 1: {
                accsClientConfig = mPreviewConfigs.get(string);
                break;
            }
            case 2: {
                accsClientConfig = mDebugConfigs.get(string);
                break;
            }
            case 0: {
                accsClientConfig = mReleaseConfigs.get(string);
                break;
            }
            default: {
                accsClientConfig = mReleaseConfigs.get(string);
            }
        }
        if (accsClientConfig == null) {
            ALog.e(TAG, "getConfigByTag return null", "configTag", string);
        }
        return accsClientConfig;
    }

    public String getAppKey() {
        return this.mAppKey;
    }

    public String getAppSecret() {
        return this.mAppSecret;
    }

    public String getInappHost() {
        return this.mInappHost;
    }

    public String getChannelHost() {
        return this.mChannelHost;
    }

    public int getSecurity() {
        return this.mSecurity;
    }

    public String getAuthCode() {
        return this.mAuthCode;
    }

    public int getInappPubKey() {
        return this.mInappPubKey;
    }

    public int getChannelPubKey() {
        return this.mChannelPubKey;
    }

    public boolean isKeepalive() {
        return this.mKeepalive;
    }

    public boolean isAutoUnit() {
        return this.mAutoUnit;
    }

    public String getTag() {
        return this.mTag;
    }

    public int getConfigEnv() {
        return this.mConfigEnv;
    }

    public boolean getDisableChannel() {
        return this.mDisableChannel;
    }

    public boolean isQuickReconnect() {
        return this.mQuickReconnect;
    }

    public String getStoreId() {
        return this.mStoreId;
    }

    public boolean isAccsHeartbeatEnable() {
        return this.mAccsHeartbeatEnable;
    }

    public boolean isPullUpEnable() {
        return this.mPullUpEnable;
    }

    public boolean isForePingEnable() {
        return this.mForePingEnable;
    }

    public void setForePingEnable(boolean bl) {
        this.mForePingEnable = bl;
    }

    public int getPingTimeout() {
        return this.mPingTimeout;
    }

    public String toString() {
        return "AccsClientConfig{mAppKey='" + this.mAppKey + '\'' + ", mAppSecret='" + this.mAppSecret + '\'' + ", mInappHost='" + this.mInappHost + '\'' + ", mChannelHost='" + this.mChannelHost + '\'' + ", mStoreId='" + this.mStoreId + '\'' + ", mSecurity=" + this.mSecurity + ", mAuthCode='" + this.mAuthCode + '\'' + ", mInappPubKey=" + this.mInappPubKey + ", mChannelPubKey=" + this.mChannelPubKey + ", mKeepalive=" + this.mKeepalive + ", mAutoUnit=" + this.mAutoUnit + ", mTag='" + this.mTag + '\'' + ", mConfigEnv=" + this.mConfigEnv + ", mDisableChannel=" + this.mDisableChannel + ", mQuickReconnect=" + this.mQuickReconnect + ", mAccsHeartbeatEnable=" + this.mAccsHeartbeatEnable + ", mPullUpEnable=" + this.mPullUpEnable + ", mForePingEnable=" + this.mForePingEnable + ", mPingTimeout=" + this.mPingTimeout + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AccsClientConfig)) {
            return false;
        }
        AccsClientConfig accsClientConfig = (AccsClientConfig)object;
        return this.mSecurity == accsClientConfig.mSecurity && this.mInappPubKey == accsClientConfig.mInappPubKey && this.mChannelPubKey == accsClientConfig.mChannelPubKey && this.mKeepalive == accsClientConfig.mKeepalive && this.mAutoUnit == accsClientConfig.mAutoUnit && this.mConfigEnv == accsClientConfig.mConfigEnv && this.mDisableChannel == accsClientConfig.mDisableChannel && this.mQuickReconnect == accsClientConfig.mQuickReconnect && this.mAccsHeartbeatEnable == accsClientConfig.mAccsHeartbeatEnable && this.mPullUpEnable == accsClientConfig.mPullUpEnable && this.mForePingEnable == accsClientConfig.mForePingEnable && this.mPingTimeout == accsClientConfig.mPingTimeout && v.a(this.mAppKey, (Object)accsClientConfig.mAppKey) && v.a(this.mAppSecret, (Object)accsClientConfig.mAppSecret) && v.a(this.mInappHost, (Object)accsClientConfig.mInappHost) && v.a(this.mChannelHost, (Object)accsClientConfig.mChannelHost) && v.a(this.mStoreId, (Object)accsClientConfig.mStoreId) && v.a(this.mAuthCode, (Object)accsClientConfig.mAuthCode) && v.a(this.mTag, (Object)accsClientConfig.mTag);
    }

    public static void setAccsConfig(int n2, AccsClientConfig accsClientConfig) {
        Map<String, AccsClientConfig> map;
        switch (n2) {
            case 1: {
                map = mPreviewConfigs;
                break;
            }
            case 2: {
                map = mDebugConfigs;
                break;
            }
            default: {
                map = mReleaseConfigs;
            }
        }
        AccsClientConfig accsClientConfig2 = map.get(accsClientConfig.getTag());
        if (accsClientConfig2 != null) {
            ALog.w(TAG, "build conver", "old config", accsClientConfig2);
        }
        map.put(accsClientConfig.getTag(), accsClientConfig);
    }

    static {
        loadedStaticConfig = false;
        mEnv = 0;
        mReleaseConfigs = new ConcurrentHashMap<String, AccsClientConfig>(1);
        mPreviewConfigs = new ConcurrentHashMap<String, AccsClientConfig>(1);
        mDebugConfigs = new ConcurrentHashMap<String, AccsClientConfig>(1);
    }

    public static class Builder {
        private String mAppKey = "";
        private String mTag = "";
        private String mAppSecret = "";
        private String mInappHost = "";
        private String mChannelHost = "";
        private String mAuthCode = "";
        private String mStoreId = "";
        private int mInappPubKey = -1;
        private int mChannelPubKey = -1;
        private boolean mKeepalive = true;
        private boolean mAutoUnit = true;
        private int mConfigEnv = 0;
        private boolean mDisableChannel = false;
        private boolean mQuickReconnect = false;
        private boolean mAccsHeartbeatEnable = false;
        private boolean mPullUpEnable = true;
        private boolean mForePingEnable = false;
        private int mPingTimeout = 0;

        public Builder setAppKey(String string) {
            this.mAppKey = string;
            return this;
        }

        public Builder setAppSecret(String string) {
            this.mAppSecret = string;
            return this;
        }

        public Builder setInappHost(String string) {
            this.mInappHost = string;
            return this;
        }

        public Builder setChannelHost(String string) {
            this.mChannelHost = string;
            return this;
        }

        public Builder setAutoCode(String string) {
            this.mAuthCode = string;
            return this;
        }

        public Builder setInappPubKey(int n2) {
            this.mInappPubKey = n2;
            return this;
        }

        public Builder setChannelPubKey(int n2) {
            this.mChannelPubKey = n2;
            return this;
        }

        public Builder setKeepAlive(boolean bl) {
            this.mKeepalive = bl;
            return this;
        }

        public Builder setAutoUnit(boolean bl) {
            this.mAutoUnit = bl;
            return this;
        }

        public Builder setConfigEnv(@ENV int n2) {
            this.mConfigEnv = n2;
            return this;
        }

        public Builder setStoreId(String string) {
            this.mStoreId = string;
            return this;
        }

        public Builder setTag(String string) {
            this.mTag = string;
            return this;
        }

        public Builder setDisableChannel(boolean bl) {
            this.mDisableChannel = bl;
            return this;
        }

        public Builder setQuickReconnect(boolean bl) {
            this.mQuickReconnect = bl;
            return this;
        }

        public Builder setAccsHeartbeatEnable(boolean bl) {
            this.mAccsHeartbeatEnable = bl;
            return this;
        }

        public Builder setPullUpEnable(boolean bl) {
            this.mPullUpEnable = bl;
            return this;
        }

        public Builder setForePingEnable(boolean bl) {
            this.mForePingEnable = bl;
            return this;
        }

        public Builder setPingTimeout(int n2) {
            this.mPingTimeout = n2;
            return this;
        }

        public AccsClientConfig build() throws AccsException {
            Map<String, AccsClientConfig> map;
            if (TextUtils.isEmpty((CharSequence)this.mAppKey)) {
                throw new AccsException("appkey null");
            }
            AccsClientConfig accsClientConfig = new AccsClientConfig();
            accsClientConfig.mAppKey = this.mAppKey;
            accsClientConfig.mAppSecret = this.mAppSecret;
            accsClientConfig.mAuthCode = this.mAuthCode;
            accsClientConfig.mKeepalive = this.mKeepalive;
            accsClientConfig.mAutoUnit = this.mAutoUnit;
            accsClientConfig.mInappPubKey = this.mInappPubKey;
            accsClientConfig.mChannelPubKey = this.mChannelPubKey;
            accsClientConfig.mInappHost = this.mInappHost;
            accsClientConfig.mChannelHost = this.mChannelHost;
            accsClientConfig.mTag = this.mTag;
            accsClientConfig.mStoreId = this.mStoreId;
            accsClientConfig.mConfigEnv = this.mConfigEnv;
            accsClientConfig.mDisableChannel = this.mDisableChannel;
            accsClientConfig.mQuickReconnect = this.mQuickReconnect;
            accsClientConfig.mAccsHeartbeatEnable = this.mAccsHeartbeatEnable;
            accsClientConfig.mPullUpEnable = this.mPullUpEnable;
            accsClientConfig.mForePingEnable = this.mForePingEnable;
            accsClientConfig.mPingTimeout = this.mPingTimeout;
            if (accsClientConfig.mConfigEnv < 0) {
                accsClientConfig.mConfigEnv = mEnv;
            }
            accsClientConfig.mSecurity = 2;
            if (TextUtils.isEmpty((CharSequence)accsClientConfig.mInappHost)) {
                accsClientConfig.mInappHost = DEFAULT_CENTER_HOSTS[accsClientConfig.mConfigEnv];
            }
            if (TextUtils.isEmpty((CharSequence)accsClientConfig.mChannelHost)) {
                accsClientConfig.mChannelHost = DEFAULT_CHANNEL_HOSTS[accsClientConfig.mConfigEnv];
            }
            if (TextUtils.isEmpty((CharSequence)accsClientConfig.mTag)) {
                accsClientConfig.mTag = AccsClientConfig.DEFAULT_CONFIGTAG;
            }
            switch (accsClientConfig.mConfigEnv) {
                case 1: {
                    map = mPreviewConfigs;
                    break;
                }
                case 2: {
                    map = mDebugConfigs;
                    break;
                }
                default: {
                    map = mReleaseConfigs;
                }
            }
            ALog.d(AccsClientConfig.TAG, "build", "config", accsClientConfig);
            AccsClientConfig accsClientConfig2 = map.get(accsClientConfig.getTag());
            if (accsClientConfig2 != null) {
                ALog.w(AccsClientConfig.TAG, "build conver", "old config", accsClientConfig2);
            }
            map.put(accsClientConfig.getTag(), accsClientConfig);
            return accsClientConfig;
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface ENV {
    }
}

