/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger;

import android.app.ActivityThread;
import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import com.taobao.aranger.core.adapter.MethodWrapperAdapter;
import com.taobao.aranger.core.adapter.impl.GetInstanceMethodWrapperAdapter;
import com.taobao.aranger.core.adapter.impl.NewInstanceWrapperAdapter;
import com.taobao.aranger.core.entity.Call;
import com.taobao.aranger.core.handler.invoc.MethodInvocationHandler;
import com.taobao.aranger.core.ipc.ChannelManager;
import com.taobao.aranger.core.wrapper.MethodWrapper;
import com.taobao.aranger.core.wrapper.ObjectWrapper;
import com.taobao.aranger.core.wrapper.ParameterWrapper;
import com.taobao.aranger.exception.IPCException;
import com.taobao.aranger.intf.ProcessStateListener;
import com.taobao.aranger.logs.IPCLog;
import com.taobao.aranger.utils.CallbackManager;
import com.taobao.aranger.utils.IPCRecycle;
import com.taobao.aranger.utils.IPCUtils;
import com.taobao.aranger.utils.ParameterTransformer;
import com.taobao.aranger.utils.ReflectUtils;
import com.taobao.aranger.utils.TimeStampGenerator;
import com.taobao.aranger.utils.TypeUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ARanger {
    private static final String TAG = ARanger.class.getSimpleName();
    private static volatile Application sApplication;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Context getContext() {
        if (sApplication != null) return sApplication;
        Class<ARanger> clazz = ARanger.class;
        synchronized (ARanger.class) {
            if (sApplication != null) return sApplication;
            try {
                ActivityThread activityThread = ActivityThread.currentActivityThread();
                if (activityThread != null) {
                    sApplication = activityThread.getApplication();
                }
            }
            catch (Exception e) {
                IPCLog.e(TAG, "[getContext][currentActivityThread]", e, new Object[0]);
            }
            if (sApplication == null) {
                try {
                    Method getActivityThreadMethod = ReflectUtils.getHideMethod(ActivityThread.class, "currentActivityThread", new Class[0]);
                    Method getApplicationMethod = ReflectUtils.getHideMethod(ActivityThread.class, "getApplication", new Class[0]);
                    sApplication = (Application)getApplicationMethod.invoke(getActivityThreadMethod.invoke(ActivityThread.class, new Object[0]), new Object[0]);
                }
                catch (Exception e) {
                    IPCLog.e(TAG, "[getContext][invoke]", e, new Object[0]);
                }
            }
            ARanger.debug((ARanger.sApplication.getApplicationInfo().flags & 2) != 0);
            // ** MonitorExit[var0] (shouldn't be in output)
            return sApplication;
        }
    }

    public static void init(@NonNull Application application) {
        if (sApplication != null) {
            return;
        }
        sApplication = application;
        ARanger.debug((ARanger.sApplication.getApplicationInfo().flags & 2) != 0);
    }

    public static <T> T create(ComponentName providerComponentName, Class<T> clazz, Object ... parameters) throws IPCException {
        ARanger.validate(providerComponentName, clazz);
        return ARanger.createProxy(providerComponentName, clazz, 0, new NewInstanceWrapperAdapter(), parameters);
    }

    public static <T> T createSingleton(ComponentName providerComponentName, Class<T> clazz, Object ... parameters) throws IPCException {
        return ARanger.createProxyByMethodName(providerComponentName, clazz, "getInstance", parameters);
    }

    public static <T> T createSingleton(ComponentName providerComponentName, Class<T> clazz, String methodName, Object ... parameters) throws IPCException {
        return ARanger.createProxyByMethodName(providerComponentName, clazz, methodName, parameters);
    }

    public static void debug(boolean isDebug) {
        IPCLog.setUseTlog(!isDebug);
    }

    public static void connect(ComponentName providerComponentName) throws IPCException {
        TypeUtils.validateComponentName(providerComponentName);
        ChannelManager.getRemoteChannel(IPCUtils.queryContentAuthorityFromProvider(providerComponentName)).connect();
    }

    public static boolean isConnect(ComponentName providerComponentName) {
        try {
            TypeUtils.validateComponentName(providerComponentName);
            return IPCUtils.isProcessAlive(providerComponentName);
        }
        catch (IPCException e) {
            return false;
        }
    }

    public static void registerProcessStateListener(@NonNull ProcessStateListener processStateListener) {
        CallbackManager.getInstance().registerProcessStateListener(processStateListener);
    }

    public static void unRegisterProcessStateListener(@NonNull ProcessStateListener processStateListener) {
        CallbackManager.getInstance().unRegisterProcessStateListener(processStateListener);
    }

    private static void validate(ComponentName providerComponentName, Class clazz) throws IPCException {
        TypeUtils.validateServiceInterface(clazz);
        TypeUtils.validateComponentName(providerComponentName);
    }

    private static <T> T createProxyByMethodName(ComponentName providerComponentName, Class<T> clazz, String methodName, Object ... parameters) throws IPCException {
        ARanger.validate(providerComponentName, clazz);
        return ARanger.createProxy(providerComponentName, clazz, 1, new GetInstanceMethodWrapperAdapter(methodName), parameters);
    }

    private static <T> T createProxy(ComponentName providerComponentName, Class<T> clazz, int objectType, MethodWrapperAdapter methodWrapperAdapter, Object ... parameters) throws IPCException {
        Uri remoteProviderUri = IPCUtils.queryContentAuthorityFromProvider(providerComponentName);
        ObjectWrapper objectWrapper = ObjectWrapper.obtain().setTimeStamp(TimeStampGenerator.getTimeStamp()).setObjectClass(clazz).setType(objectType);
        ParameterWrapper[] parameterWrappers = ParameterTransformer.wrapperParameters(null, parameters);
        MethodWrapper methodWrapper = methodWrapperAdapter.wrapperMethod(parameterWrappers);
        Call call = Call.obtain().setObjectWrapper(objectWrapper).setMethodWrapper(methodWrapper).setParameterWrappers(parameterWrappers).setRemoteProviderUri(remoteProviderUri);
        ChannelManager.getRemoteChannel(remoteProviderUri).sendCall(call);
        return ARanger.getProxy(call);
    }

    private static <T> T getProxy(Call call) {
        ObjectWrapper objectWrapper = call.getObjectWrapper();
        Uri remoteUri = call.getRemoteProviderUri();
        Object proxy = Proxy.newProxyInstance(objectWrapper.getObjectClass().getClassLoader(), new Class[]{objectWrapper.getObjectClass()}, (InvocationHandler)new MethodInvocationHandler(objectWrapper, remoteUri));
        IPCRecycle.getInstance().register(remoteUri, proxy, objectWrapper.getTimeStamp());
        return (T)proxy;
    }
}

