/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.core.handler.invoc;

import android.os.Parcel;
import android.os.Parcelable;
import com.taobao.aranger.annotation.parameter.inout;
import com.taobao.aranger.annotation.parameter.out;
import com.taobao.aranger.core.entity.Reply;
import com.taobao.aranger.exception.IPCException;
import com.taobao.aranger.intf.IDataFlow;
import com.taobao.aranger.logs.IPCLog;
import com.taobao.aranger.utils.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class IPCInvocationHandler
implements InvocationHandler {
    private static final String TAG = IPCInvocationHandler.class.getName();

    IPCInvocationHandler() {
    }

    @Override
    public Object invoke(Object o, Method method, Object[] objects) throws IPCException {
        if (method.getDeclaringClass() == Object.class) {
            try {
                return method.invoke((Object)this, objects);
            }
            catch (Exception e) {
                throw new IPCException(18, (Throwable)e);
            }
        }
        return this.processReply(this.internalInvoke(method, objects), method, objects);
    }

    abstract Reply internalInvoke(Method var1, Object[] var2) throws IPCException;

    private Object processReply(Reply reply, Method method, Object[] destObjects) throws IPCException {
        if (reply.getFlowParameterWrappers() != null && reply.getFlowParameterWrappers().length != 0) {
            Class<?>[] classes = method.getParameterTypes();
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            int index = 0;
            for (int i = 0; i < destObjects.length; ++i) {
                try {
                    if (!TypeUtils.arrayContainsAnnotation(parameterAnnotations[i], out.class) && !TypeUtils.arrayContainsAnnotation(parameterAnnotations[i], inout.class)) continue;
                    Object srcObject = reply.getFlowParameterWrappers()[index++].getData();
                    if (destObjects[i] == null) {
                        destObjects[i] = srcObject;
                        continue;
                    }
                    if (classes[i].isArray()) {
                        TypeUtils.convertObjectToArray(classes[i].getName(), destObjects[i], srcObject);
                        continue;
                    }
                    if (List.class.isAssignableFrom(classes[i])) {
                        Collections.copy((List)destObjects[i], (List)srcObject);
                        continue;
                    }
                    if (Map.class.isAssignableFrom(classes[i])) {
                        Map srcMap = (Map)srcObject;
                        Map destMap = (Map)destObjects[i];
                        destMap.clear();
                        if (srcMap == null) continue;
                        Set entrySet = srcMap.entrySet();
                        for (Map.Entry entry : entrySet) {
                            destMap.put(entry.getKey(), entry.getValue());
                        }
                        continue;
                    }
                    if (IDataFlow.class.isAssignableFrom(classes[i])) {
                        ((IDataFlow)destObjects[i]).readFromObject(srcObject);
                        continue;
                    }
                    if (!Parcelable.class.isAssignableFrom(classes[i])) continue;
                    Method methodReadFromParcel = classes[i].getDeclaredMethod("readFromParcel", Parcel.class);
                    methodReadFromParcel.setAccessible(true);
                    Parcel parcel = Parcel.obtain();
                    ((Parcelable)srcObject).writeToParcel(parcel, 0);
                    parcel.setDataPosition(0);
                    methodReadFromParcel.invoke(destObjects[i], parcel);
                    parcel.recycle();
                    continue;
                }
                catch (Exception e) {
                    IPCLog.e(TAG, "[processReply]", e, new Object[0]);
                    throw new IPCException(26, (Throwable)e);
                }
            }
        }
        return reply.getResult();
    }
}

