/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.core.handler.reply.impl;

import com.taobao.aranger.core.entity.Call;
import com.taobao.aranger.core.handler.reply.BaseReplyHandler;
import com.taobao.aranger.exception.IPCException;
import com.taobao.aranger.intf.IObjectProxy;
import com.taobao.aranger.utils.ObjectCenter;
import com.taobao.aranger.utils.TypeCenter;
import com.taobao.aranger.utils.TypeUtils;
import java.lang.reflect.Constructor;
import java.util.concurrent.ConcurrentHashMap;

public class GetInstanceReplyHandler
extends BaseReplyHandler {
    private IObjectProxy mObjectProxy;
    private Class<?> mObjectClass;
    private String mSingleId;
    private Constructor<?> mProxyConstructor;
    private static final ConcurrentHashMap<String, IObjectProxy> sProxyMap = new ConcurrentHashMap();

    public GetInstanceReplyHandler(Call call) throws IPCException {
        super(call);
        this.mObjectClass = TypeCenter.getInstance().getClassType(call.getObjectWrapper());
        this.mObjectProxy = sProxyMap.get(this.mObjectClass.getName());
        if (this.mObjectProxy == null) {
            this.mSingleId = TypeUtils.getMethodId(call.getMethodWrapper().getName(), call.getParameterWrappers());
            this.mProxyConstructor = TypeUtils.getConstructor(TypeCenter.getInstance().getClassType(this.mObjectClass.getName() + "$$IPCProxy"), new Class[0]);
        }
    }

    @Override
    public Object invoke(Object[] parameters) throws IPCException {
        try {
            if (this.mObjectProxy == null) {
                this.mObjectProxy = (IObjectProxy)this.mProxyConstructor.newInstance(new Object[0]);
                this.mObjectProxy.create(this.mSingleId, parameters);
                sProxyMap.putIfAbsent(this.mObjectClass.getName(), this.mObjectProxy);
            }
            ObjectCenter.getInstance().putObject(this.mCall.getObjectWrapper().getTimeStamp(), this.mObjectProxy);
            return null;
        }
        catch (Exception e) {
            if (e instanceof IPCException) {
                throw (IPCException)e;
            }
            throw new IPCException(24, (Throwable)e);
        }
    }
}

