/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.core.handler.reply.impl;

import com.taobao.aranger.core.entity.Call;
import com.taobao.aranger.core.handler.reply.BaseReplyHandler;
import com.taobao.aranger.exception.IPCException;
import com.taobao.aranger.intf.IObjectProxy;
import com.taobao.aranger.utils.ObjectCenter;
import com.taobao.aranger.utils.TypeUtils;

public class MethodInvokeReplyHandler
extends BaseReplyHandler {
    private final IObjectProxy mObjectProxy;
    private final String mMethodId;

    public MethodInvokeReplyHandler(Call call) {
        super(call);
        this.mObjectProxy = ObjectCenter.getInstance().getObject(call.getObjectWrapper().getTimeStamp());
        this.mMethodId = TypeUtils.getMethodId(call.getMethodWrapper().getName(), call.getMethodWrapper().getParameterTypes());
    }

    @Override
    public Object invoke(Object[] parameters) throws IPCException {
        if (this.mObjectProxy == null) {
            throw new IPCException(22, "can't find ipc object proxy");
        }
        try {
            return this.mObjectProxy.invoke(this.mMethodId, parameters);
        }
        catch (Exception e) {
            if (e instanceof IPCException) {
                throw (IPCException)e;
            }
            throw new IPCException(3, (Throwable)e);
        }
    }
}

