/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.aranger.core.ipc;

import android.net.Uri;
import android.os.IBinder;
import com.taobao.aranger.core.ipc.channel.BaseClientChannel;
import com.taobao.aranger.core.ipc.channel.BaseRemoteChannel;
import com.taobao.aranger.core.ipc.channel.DefaultClientChannel;
import com.taobao.aranger.core.ipc.channel.MixRemoteChannel;
import java.util.concurrent.ConcurrentHashMap;

public class ChannelManager {
    private static final ConcurrentHashMap<Uri, BaseRemoteChannel> sRemoteChannelMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<IBinder, BaseClientChannel> sClientChannelMap = new ConcurrentHashMap();

    public static BaseRemoteChannel getRemoteChannel(Uri remoteProviderUri) {
        BaseRemoteChannel baseRemoteChannel = sRemoteChannelMap.get(remoteProviderUri);
        if (baseRemoteChannel == null) {
            baseRemoteChannel = new MixRemoteChannel(remoteProviderUri);
            sRemoteChannelMap.putIfAbsent(remoteProviderUri, baseRemoteChannel);
        }
        return baseRemoteChannel;
    }

    public static BaseClientChannel getClientChannel(IBinder clientServiceBinder) {
        BaseClientChannel baseClientChannel = sClientChannelMap.get(clientServiceBinder);
        if (baseClientChannel == null) {
            baseClientChannel = new DefaultClientChannel(clientServiceBinder);
            sClientChannelMap.putIfAbsent(clientServiceBinder, baseClientChannel);
        }
        return baseClientChannel;
    }
}

